package net.damschen.swatchit.domain.aggregates.swatch

import net.damschen.swatchit.R
import net.damschen.swatchit.domain.resultWrappers.ValidationResult

@JvmInline
value class SwatchName private constructor(val value: String) {
    init {
        require(validate(value) is ValidationResult.Success) { "SwatchName invalid" }
    }

    companion object {
        private const val MAX = 50
        fun validate(value: String): ValidationResult {
            return when {
                value.length > MAX -> ValidationResult.Error(R.string.max_50)
                else -> ValidationResult.Success
            }
        }

        fun create(value: String): SwatchName? = if (value.isBlank()) null else SwatchName(value)
    }

    override fun toString(): String = value
}
