package net.damschen.swatchit.domain.aggregates.swatch

import net.damschen.swatchit.domain.providers.UUIDProvider
import java.util.UUID

@JvmInline
value class Photo(val identifier: UUID) {

    companion object {
        private const val EXTENSION = ".jpg"
        fun create(provider: UUIDProvider): Photo {
            return Photo(provider.provideNew())
        }
    }

    val fileName: String get() = "$identifier$EXTENSION"
}