package net.damschen.swatchit.domain.aggregates.swatch

import kotlin.math.ceil
import kotlin.math.round

data class Gauge(val nrOfStitches: GaugeCount, val nrOfRows: GaugeCount, val size: GaugeSize) {
    fun calculateHeightFor(rows: Count): Size {
        val result = (rows.value * size.value / nrOfRows.value).roundToOneDecimalPlace()
        return Size(result)
    }

    fun calculateWidthFor(stitches: Count): Size {
        val result = (stitches.value * size.value / nrOfStitches.value).roundToOneDecimalPlace()
        return Size(result)
    }

    fun calculateStitchesFor(width: Size): Count? {
        val calculatedStitches = width.value * nrOfStitches.value / this.size.value
        if (calculatedStitches > Long.MAX_VALUE) return null
        val roundedStitches = ceil(calculatedStitches).toLong()
        return Count(roundedStitches)
    }

    fun calculateRowsFor(height: Size): Count? {
        val calculatedRows = height.value * nrOfRows.value / this.size.value
        if (calculatedRows > Long.MAX_VALUE) return null
        val roundedRows = ceil(calculatedRows).toLong()
        return Count(roundedRows)
    }
}

private fun Double.roundToOneDecimalPlace(): Double {
    val multiplier = 10.0
    return round(this * multiplier) / multiplier
}