package net.damschen.swatchit.di

import android.content.Context
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.android.qualifiers.ApplicationContext
import dagger.hilt.components.SingletonComponent
import kotlinx.coroutines.Dispatchers
import net.damschen.swatchit.infrastructure.services.AndroidPhotoStorageService
import net.damschen.swatchit.infrastructure.services.BitmapDecoder
import net.damschen.swatchit.infrastructure.services.CoilBitmapDecoder
import net.damschen.swatchit.infrastructure.services.PhotoStorageService
import javax.inject.Singleton

@Module
@InstallIn(SingletonComponent::class)
object BitmapDecoderModule {
    @Provides
    @Singleton
    fun provideBitmapDecoder(
        @ApplicationContext context: Context
    ): BitmapDecoder =
        CoilBitmapDecoder(context)
}


@Module
@InstallIn(SingletonComponent::class)
object PhotoStorageServiceModule {
    @Provides
    @Singleton
    fun providePhotoStorageService(
        @ApplicationContext context: Context,
        bitmapDecoder: BitmapDecoder
    ): PhotoStorageService = AndroidPhotoStorageService(context, bitmapDecoder, Dispatchers.IO)
}