package net.damschen.swatchit.di

import android.content.Context
import androidx.room.Room
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.android.qualifiers.ApplicationContext
import dagger.hilt.components.SingletonComponent
import net.damschen.swatchit.infrastructure.database.AppDatabase
import net.damschen.swatchit.infrastructure.database.MIGRATION_2_3
import net.damschen.swatchit.infrastructure.database.MeasurementDao
import net.damschen.swatchit.infrastructure.database.RoomTransactionProvider
import net.damschen.swatchit.infrastructure.database.SwatchDao
import net.damschen.swatchit.infrastructure.database.TransactionProvider
import javax.inject.Singleton


const val DATABASE_NAME = "swatchit_database"
@Module
@InstallIn(SingletonComponent::class)
object DatabaseModule {

    @Provides
    @Singleton
    fun provideDatabase(@ApplicationContext context: Context): AppDatabase {
        return Room.databaseBuilder(
            context,
            AppDatabase::class.java,
            DATABASE_NAME
        ).addMigrations(MIGRATION_2_3).build()
    }

    @Provides
    fun provideSwatchDao(database: AppDatabase): SwatchDao {
        return database.swatchDao()
    }

    @Provides
    fun provideMeasurementDao(database: AppDatabase): MeasurementDao {
        return database.measurementDao()
    }

    @Provides
    fun provideTransactionProvider(database: AppDatabase): TransactionProvider {
        return RoomTransactionProvider(database)
    }
}
