use leptos::prelude::*;
use leptos_router::hooks::use_navigate;
use serde_wasm_bindgen::from_value;
use thaw::Spinner;
use wasm_bindgen::prelude::*;

use crate::{components::invoke, error::CommandError};

#[component]
pub fn Welcome() -> impl IntoView {
    let navigate = RwSignal::new(use_navigate());

    AsyncDerived::new_unsync(move || async move {
        match invoke("initialize", JsValue::NULL).await {
            Ok(success) => {
                if from_value(success).expect("Wrong response from command") {
                    navigate.get_untracked()("/list", Default::default());
                } else {
                    navigate.get_untracked()("/initialize", Default::default());
                }
                Ok(())
            }
            Err(err) => Err(from_value::<CommandError>(err).unwrap()),
        }
    });

    view! {
        <main class="p-4 flex justify-center items-center w-full h-screen">

            <Transition fallback=|| view! { <Spinner /> }>
                <ErrorBoundary fallback=|errors| {
                    view! {
                        <p class="errors">
                            {move || {
                                errors
                                    .get()
                                    .into_iter()
                                    .map(|(_, e)| { e.to_string() })
                                    .collect_view()
                            }}
                        </p>
                    }
                }>
                    <ul>
                        {move || Suspend::new(async move {
                            view! { <Spinner /> }
                        })}
                    </ul>
                </ErrorBoundary>
            </Transition>
        </main>
    }
}
