"use strict";

var _metroFileMap = _interopRequireWildcard(require("metro-file-map"));

function _getRequireWildcardCache(nodeInterop) {
  if (typeof WeakMap !== "function") return null;
  var cacheBabelInterop = new WeakMap();
  var cacheNodeInterop = new WeakMap();
  return (_getRequireWildcardCache = function (nodeInterop) {
    return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
  })(nodeInterop);
}

function _interopRequireWildcard(obj, nodeInterop) {
  if (!nodeInterop && obj && obj.__esModule) {
    return obj;
  }
  if (obj === null || (typeof obj !== "object" && typeof obj !== "function")) {
    return { default: obj };
  }
  var cache = _getRequireWildcardCache(nodeInterop);
  if (cache && cache.has(obj)) {
    return cache.get(obj);
  }
  var newObj = {};
  var hasPropertyDescriptor =
    Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var key in obj) {
    if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
      var desc = hasPropertyDescriptor
        ? Object.getOwnPropertyDescriptor(obj, key)
        : null;
      if (desc && (desc.get || desc.set)) {
        Object.defineProperty(newObj, key, desc);
      } else {
        newObj[key] = obj[key];
      }
    }
  }
  newObj.default = obj;
  if (cache) {
    cache.set(obj, newObj);
  }
  return newObj;
}

/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */
const ci = require("ci-info");

const path = require("path");

function getIgnorePattern(config) {
  // For now we support both options
  const { blockList, blacklistRE } = config.resolver;
  const ignorePattern = blacklistRE || blockList; // If neither option has been set, use default pattern

  if (!ignorePattern) {
    return / ^/;
  }

  const combine = (regexes) =>
    new RegExp(
      regexes
        .map((regex) => "(" + regex.source.replace(/\//g, path.sep) + ")")
        .join("|")
    ); // If ignorePattern is an array, merge it into one

  if (Array.isArray(ignorePattern)) {
    return combine(ignorePattern);
  }

  return ignorePattern;
}

function createHasteMap(config, options) {
  var _config$unstable_file,
    _config$unstable_perf,
    _config$unstable_perf2,
    _options$throwOnModul;

  const dependencyExtractor =
    (options === null || options === void 0
      ? void 0
      : options.extractDependencies) === false
      ? null
      : config.resolver.dependencyExtractor;
  const computeDependencies = dependencyExtractor != null;
  return _metroFileMap.default.create({
    cacheManagerFactory:
      (_config$unstable_file =
        config === null || config === void 0
          ? void 0
          : config.unstable_fileMapCacheManagerFactory) !== null &&
      _config$unstable_file !== void 0
        ? _config$unstable_file
        : (buildParameters) => {
            var _config$fileMapCacheD;

            return new _metroFileMap.DiskCacheManager({
              buildParameters,
              cacheDirectory:
                (_config$fileMapCacheD = config.fileMapCacheDirectory) !==
                  null && _config$fileMapCacheD !== void 0
                  ? _config$fileMapCacheD
                  : config.hasteMapCacheDirectory,
              cacheFilePrefix:
                options === null || options === void 0
                  ? void 0
                  : options.cacheFilePrefix,
            });
          },
    perfLogger:
      (_config$unstable_perf =
        (_config$unstable_perf2 = config.unstable_perfLogger) === null ||
        _config$unstable_perf2 === void 0
          ? void 0
          : _config$unstable_perf2.subSpan("hasteMap")) !== null &&
      _config$unstable_perf !== void 0
        ? _config$unstable_perf
        : null,
    computeDependencies,
    computeSha1: true,
    dependencyExtractor: config.resolver.dependencyExtractor,
    extensions: Array.from(
      new Set([
        ...config.resolver.sourceExts,
        ...config.resolver.assetExts,
        ...config.watcher.additionalExts,
      ])
    ),
    forceNodeFilesystemAPI: !config.resolver.useWatchman,
    hasteImplModulePath: config.resolver.hasteImplModulePath,
    ignorePattern: getIgnorePattern(config),
    maxWorkers: config.maxWorkers,
    mocksPattern: "",
    platforms: config.resolver.platforms,
    retainAllFiles: true,
    resetCache: config.resetCache,
    rootDir: config.projectRoot,
    roots: config.watchFolders,
    throwOnModuleCollision:
      (_options$throwOnModul =
        options === null || options === void 0
          ? void 0
          : options.throwOnModuleCollision) !== null &&
      _options$throwOnModul !== void 0
        ? _options$throwOnModul
        : true,
    useWatchman: config.resolver.useWatchman,
    watch:
      (options === null || options === void 0 ? void 0 : options.watch) == null
        ? !ci.isCI
        : options.watch,
    watchmanDeferStates: config.watcher.watchman.deferStates,
  });
}

module.exports = createHasteMap;
