/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */
"use strict";

const canonicalize = require("metro-core/src/canonicalize");

function getGraphId(
  entryFile,
  options,
  {
    shallow,
    experimentalImportBundleSupport,
    unstable_allowRequireContext,
    resolverOptions,
  }
) {
  var _resolverOptions$cust, _options$customTransf;

  return JSON.stringify(
    {
      entryFile,
      options: {
        customResolverOptions:
          (_resolverOptions$cust = resolverOptions.customResolverOptions) !==
            null && _resolverOptions$cust !== void 0
            ? _resolverOptions$cust
            : {},
        customTransformOptions:
          (_options$customTransf = options.customTransformOptions) !== null &&
          _options$customTransf !== void 0
            ? _options$customTransf
            : null,
        dev: options.dev,
        experimentalImportSupport: options.experimentalImportSupport || false,
        hot: options.hot,
        minify: options.minify,
        unstable_disableES6Transforms: options.unstable_disableES6Transforms,
        platform: options.platform != null ? options.platform : null,
        runtimeBytecodeVersion: options.runtimeBytecodeVersion,
        type: options.type,
        experimentalImportBundleSupport,
        unstable_allowRequireContext,
        shallow,
        unstable_transformProfile:
          options.unstable_transformProfile || "default",
      },
    },
    canonicalize
  );
}

module.exports = getGraphId;
