"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.opTake = exports.opTakeSync = exports.opTakeAsync = void 0;
const util_1 = require("../helpers/util");
function opTakeAsync(count) {
    async function* fn(iter) {
        if (count <= 0)
            return;
        for await (const v of iter) {
            yield v;
            if (--count <= 0)
                return;
        }
    }
    return fn;
}
exports.opTakeAsync = opTakeAsync;
function opTakeSync(count) {
    function* fn(iter) {
        if (count <= 0)
            return;
        for (const v of iter) {
            yield v;
            if (--count <= 0)
                return;
        }
    }
    return fn;
}
exports.opTakeSync = opTakeSync;
const opTake = (count) => (0, util_1.toPipeFn)(opTakeSync(count), opTakeAsync(count));
exports.opTake = opTake;
//# sourceMappingURL=take.js.map