"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.opJoinStrings = exports.opJoinStringsSync = exports.opJoinStringsAsync = void 0;
const helpers_1 = require("../helpers");
const util_1 = require("../helpers/util");
function opJoinStringsAsync(joinCharacter = ',') {
    async function* fn(iter) {
        for await (const v of iter) {
            const a = await (0, helpers_1.toArray)(v);
            yield a.join(joinCharacter);
        }
    }
    return fn;
}
exports.opJoinStringsAsync = opJoinStringsAsync;
function opJoinStringsSync(joinCharacter = ',') {
    function* fn(iter) {
        for (const v of iter) {
            const a = (0, helpers_1.toArray)(v);
            yield a.join(joinCharacter);
        }
    }
    return fn;
}
exports.opJoinStringsSync = opJoinStringsSync;
const opJoinStrings = (joinCharacter = ',') => (0, util_1.toPipeFn)(opJoinStringsSync(joinCharacter), opJoinStringsAsync(joinCharacter));
exports.opJoinStrings = opJoinStrings;
//# sourceMappingURL=joinStrings.js.map