/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Reads the current locale and returns an interface very similar to
 * `Intl.PluralRules`.
 */
export declare function usePluralForm(): {
    /**
     * Give it a `count` and it will select the relevant message from
     * `pluralMessages`. `pluralMessages` should be separated by `|`, and in the
     * order of "zero", "one", "two", "few", "many", "other". The actual selection
     * is done by `Intl.PluralRules`, which tells us all plurals the locale has
     * and which plural we should use for `count`.
     */
    selectMessage: (count: number, pluralMessages: string) => string;
};
//# sourceMappingURL=usePluralForm.d.ts.map