/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Wires the imperative logic of a hideable navbar.
 * @param hideOnScroll If `false`, this hook is basically a no-op.
 */
export declare function useHideableNavbar(hideOnScroll: boolean): {
    /** A ref to the navbar component. Plug this into the actual element. */
    readonly navbarRef: (node: HTMLElement | null) => void;
    /** If `false`, the navbar component should not be rendered. */
    readonly isNavbarVisible: boolean;
};
//# sourceMappingURL=useHideableNavbar.d.ts.map