/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
/** Wires the logic for the back to top button. */
export declare function useBackToTopButton({ threshold, }: {
    /**
     * The minimum vertical scroll position, above which a scroll-up would not
     * cause `shown` to become `true`. This is because BTT is only useful if the
     * user is far down the page.
     */
    threshold: number;
}): {
    /**
     * Whether the button should be displayed. We only show if the user has
     * scrolled up and is on a vertical position greater than `threshold`.
     */
    shown: boolean;
    /**
     * A (memoized) handle for starting the scroll, which you can directly plug
     * into the props.
     */
    scrollToTop: () => void;
};
//# sourceMappingURL=useBackToTopButton.d.ts.map