/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { type ReactNode } from 'react';
/** @internal */
export declare function NavbarSecondaryMenuDisplayProvider({ children, }: {
    children: ReactNode;
}): JSX.Element;
/** Wires the logic for rendering the mobile navbar secondary menu. */
export declare function useNavbarSecondaryMenu(): {
    /** Whether secondary menu is displayed. */
    shown: boolean;
    /**
     * Hide the secondary menu; fired either when hiding the entire sidebar, or
     * when going back to the primary menu.
     */
    hide: () => void;
    /** The content returned from the current secondary menu filler. */
    content: JSX.Element | undefined;
};
//# sourceMappingURL=display.d.ts.map