import { Buffer } from '@craftzdog/react-native-buffer';
import type { ABV } from './Utils';
export declare function randomFill<T extends ABV>(buffer: T, callback: (err: Error | null, buf: T) => void): void;
export declare function randomFill<T extends ABV>(buffer: T, offset: number, callback: (err: Error | null, buf: T) => void): void;
export declare function randomFill<T extends ABV>(buffer: T, offset: number, size: number, callback: (err: Error | null, buf: T) => void): void;
export declare function randomFillSync<T extends ABV>(buffer: T, offset?: number, size?: number): T;
export declare function randomBytes(size: number): Buffer;
export declare function randomBytes(size: number, callback: (err: Error | null, buf?: Buffer) => void): void;
export declare const rng: typeof randomBytes;
export declare const pseudoRandomBytes: typeof randomBytes;
export declare const prng: typeof randomBytes;
type RandomIntCallback = (err: Error | null, value: number) => void;
export declare function randomInt(max: number, callback: RandomIntCallback): void;
export declare function randomInt(max: number): number;
export declare function randomInt(min: number, max: number, callback: RandomIntCallback): void;
export declare function randomInt(min: number, max: number): number;
export type RandomTypedArrays = Int8Array | Int16Array | Int32Array | Uint8Array | Uint16Array | Uint32Array;
export declare function getRandomValues(data: RandomTypedArrays): RandomTypedArrays;
export declare function randomUUID(): string;
export {};
//# sourceMappingURL=random.d.ts.map