import { type BufferLike, type BinaryLike } from './Utils';
import { type ImportFormat, type SubtleAlgorithm, type KeyUsage, KWebCryptoKeyFormat, CryptoKey, type JWK, type CryptoKeyPair } from './keys';
export declare function ecExportKey(key: CryptoKey, format: KWebCryptoKeyFormat): ArrayBuffer;
export declare function ecImportKey(format: ImportFormat, keyData: BufferLike | BinaryLike | JWK, algorithm: SubtleAlgorithm, extractable: boolean, keyUsages: KeyUsage[]): CryptoKey;
export declare const ecdsaSignVerify: (key: CryptoKey, data: BufferLike, { hash }: SubtleAlgorithm, signature?: BufferLike) => boolean | ArrayBuffer;
export declare const ecGenerateKey: (algorithm: SubtleAlgorithm, extractable: boolean, keyUsages: KeyUsage[]) => Promise<CryptoKeyPair>;
//# sourceMappingURL=ec.d.ts.map