import { Buffer as CraftzdogBuffer } from '@craftzdog/react-native-buffer';
import { Buffer as SafeBuffer } from 'safe-buffer';
import type { KeyUsage } from './keys';
import { type CipherKey } from 'crypto';
export type BufferLike = ArrayBuffer | CraftzdogBuffer | SafeBuffer | ArrayBufferView;
export type BinaryLike = string | ArrayBuffer | CraftzdogBuffer | SafeBuffer | TypedArray | DataView;
export type BinaryLikeNode = CipherKey | BinaryLike;
export type BinaryToTextEncoding = 'base64' | 'base64url' | 'hex' | 'binary';
export type CharacterEncoding = 'utf8' | 'utf-8' | 'utf16le' | 'latin1';
export type LegacyCharacterEncoding = 'ascii' | 'binary' | 'ucs2' | 'ucs-2';
export type Encoding = BinaryToTextEncoding | CharacterEncoding | LegacyCharacterEncoding;
export type CipherEncoding = Encoding | 'buffer';
export type CipherType = 'aes128' | 'aes192' | 'aes256' | CipherCBCType | CipherCFBType | CipherCTRType | CipherDESType | CipherECBType | CipherGCMType | CipherOFBType;
export type CipherCBCType = 'aes-128-cbc' | 'aes-192-cbc' | 'aes-256-cbc';
export type CipherCFBType = 'aes-128-cfb' | 'aes-192-cfb' | 'aes-256-cfb' | 'aes-128-cfb1' | 'aes-192-cfb1' | 'aes-256-cfb1' | 'aes-128-cfb8' | 'aes-192-cfb8' | 'aes-256-cfb8';
export type CipherCTRType = 'aes-128-ctr' | 'aes-192-ctr' | 'aes-256-ctr';
export type CipherDESType = 'des' | 'des3' | 'des-cbc' | 'des-ecb' | 'des-ede' | 'des-ede-cbc' | 'des-ede3' | 'des-ede3-cbc';
export type CipherECBType = 'aes-128-ecb' | 'aes-192-ecb' | 'aes-256-ecb';
export type CipherGCMType = 'aes-128-gcm' | 'aes-192-gcm' | 'aes-256-gcm';
export type CipherOFBType = 'aes-128-ofb' | 'aes-192-ofb' | 'aes-256-ofb';
export type TypedArray = Uint8Array | Uint8ClampedArray | Uint16Array | Uint32Array | Int8Array | Int16Array | Int32Array | Float32Array | Float64Array;
export type ABV = TypedArray | DataView | ArrayBufferLike | CraftzdogBuffer;
type DOMName = string | {
    name: string;
    cause: unknown;
};
export declare function setDefaultEncoding(encoding: CipherEncoding): void;
export declare function getDefaultEncoding(): CipherEncoding;
export declare const kEmptyObject: any;
/**
 * Converts supplied argument to an ArrayBuffer.  Note this does not copy the
 * data so it is faster than toArrayBuffer.  Not copying is important for
 * functions like randomFill which need to be able to write to the underlying
 * buffer.
 * @param buf
 * @returns ArrayBuffer
 */
export declare function abvToArrayBuffer(buffer: ABV): ArrayBuffer;
/**
 * Converts supplied argument to an ArrayBuffer.  Note this copies data if the
 * supplied buffer has the .slice() method, so can be a bit slow.
 * @param buf
 * @returns ArrayBuffer
 */
export declare function toArrayBuffer(buf: CraftzdogBuffer | SafeBuffer | ArrayBufferView): ArrayBuffer;
export declare function bufferLikeToArrayBuffer(buf: BufferLike): ArrayBuffer;
export declare function binaryLikeToArrayBuffer(input: BinaryLikeNode, // CipherKey adds compat with node types
encoding?: string): ArrayBuffer;
export declare function ab2str(buf: ArrayBuffer, encoding?: string): string;
export declare function validateString(str: unknown, name?: string): str is string;
export declare function validateFunction(f: unknown): boolean;
export declare function isStringOrBuffer(val: unknown): val is string | ArrayBuffer;
export declare function validateObject<T>(value: unknown, name: string, options?: {
    allowArray: boolean;
    allowFunction: boolean;
    nullable: boolean;
} | null): value is T;
export declare function validateInt32(value: any, name: string, min?: number, max?: number): void;
export declare function validateUint32(value: number, name: string, positive?: boolean): void;
export declare function hasAnyNotIn(set: string[], checks: string[]): boolean;
export declare function lazyDOMException(message: string, domName: DOMName): Error;
export declare const validateMaxBufferLength: (data: BinaryLike | BufferLike, name: string) => void;
export declare const validateBitLength: (length: number, name: string, required?: boolean) => void;
export declare const validateByteLength: (buf: BufferLike, name: string, target: number) => void;
export declare const getUsagesUnion: (usageSet: KeyUsage[], ...usages: KeyUsage[]) => KeyUsage[];
export declare const validateKeyOps: (keyOps: KeyUsage[] | undefined, usagesSet: KeyUsage[]) => void;
export declare const bigIntArrayToUnsignedInt: (input: Uint8Array) => number | undefined;
export declare const getHashes: () => string[];
export declare const getCiphers: () => string[];
export * from './Hashnames';
//# sourceMappingURL=Utils.d.ts.map