import type { KeyObjectHandle } from './webcrypto';
export type InternalSign = {
    init: (algorithm: string) => void;
    update: (data: ArrayBuffer) => void;
    sign: (...args: any) => Uint8Array;
};
export type InternalVerify = {
    init: (algorithm: string) => void;
    update: (data: ArrayBuffer) => void;
    verify: (...args: any) => boolean;
};
export type CreateSignMethod = () => InternalSign;
export type CreateVerifyMethod = () => InternalVerify;
export declare enum DSASigEnc {
    kSigEncDER = 0,
    kSigEncP1363 = 1
}
export declare enum SignMode {
    kSignJobModeSign = 0,
    kSignJobModeVerify = 1
}
export type SignVerify = (mode: SignMode, handle: KeyObjectHandle, unused1: undefined, unused2: undefined, unused3: undefined, data: ArrayBuffer, digest: string | undefined, salt_length: number | undefined, padding: number | undefined, dsa_encoding: DSASigEnc | undefined, signature: ArrayBuffer | undefined) => ArrayBuffer | boolean;
//# sourceMappingURL=sig.d.ts.map