import type { CreateHmacMethod } from './hmac';
import type { CreateHashMethod } from './hash';
import type { Pbkdf2Object } from './pbkdf2';
import type { RandomObject } from './random';
import type { CreateCipherMethod, CreateDecipherMethod, PublicEncryptMethod, PrivateDecryptMethod, GenerateKeyPairMethod, GenerateKeyPairSyncMethod, CreatePublicKeyMethod, CreatePrivateKeyMethod, CreateSecretKeyMethod } from './Cipher';
import type { CreateSignMethod, CreateVerifyMethod } from './sig';
import type { webcrypto } from './webcrypto';
interface NativeQuickCryptoSpec {
    createHmac: CreateHmacMethod;
    pbkdf2: Pbkdf2Object;
    random: RandomObject;
    createHash: CreateHashMethod;
    createCipher: CreateCipherMethod;
    createDecipher: CreateDecipherMethod;
    createPublicKey: CreatePublicKeyMethod;
    createPrivateKey: CreatePrivateKeyMethod;
    createSecretKey: CreateSecretKeyMethod;
    publicEncrypt: PublicEncryptMethod;
    publicDecrypt: PublicEncryptMethod;
    privateDecrypt: PrivateDecryptMethod;
    generateKeyPair: GenerateKeyPairMethod;
    generateKeyPairSync: GenerateKeyPairSyncMethod;
    createSign: CreateSignMethod;
    createVerify: CreateVerifyMethod;
    webcrypto: webcrypto;
}
declare global {
    function nativeCallSyncHook(): unknown;
    let __QuickCryptoProxy: object | undefined;
}
export declare const NativeQuickCrypto: NativeQuickCryptoSpec;
export {};
//# sourceMappingURL=NativeQuickCrypto.d.ts.map