import type { GenerateKeyPairReturn } from '../Cipher';
import type { BinaryLike } from '../Utils';
import type { Buffer } from '@craftzdog/react-native-buffer';
import type { EncodingOptions, KeyEncoding, PrivateKeyObject, PublicKeyObject, SecretKeyObject } from '../keys';
export declare enum KeyVariant {
    RSA_SSA_PKCS1_v1_5 = 0,
    RSA_PSS = 1,
    RSA_OAEP = 2,
    DSA = 3,
    EC = 4,
    NID = 5,
    DH = 6
}
export declare const KeyVariantLookup: Record<string, KeyVariant>;
export type InternalCipher = {
    update: (data: BinaryLike | ArrayBufferView) => ArrayBuffer;
    final: () => ArrayBuffer;
    copy: () => void;
    setAAD: (args: {
        data: BinaryLike;
        plaintextLength?: number;
    }) => InternalCipher;
    setAutoPadding: (autoPad: boolean) => boolean;
    setAuthTag: (tag: ArrayBuffer) => boolean;
    getAuthTag: () => ArrayBuffer;
};
export type CreateCipherMethod = (params: {
    cipher_type: string;
    cipher_key: ArrayBuffer;
    auth_tag_len: number;
}) => InternalCipher;
export type CreateDecipherMethod = (params: {
    cipher_type: string;
    cipher_key: ArrayBuffer;
    auth_tag_len: number;
}) => InternalCipher;
export type PublicEncryptMethod = (data: ArrayBuffer, format: number, type: KeyEncoding | undefined, passphrase: BinaryLike | undefined, buffer: ArrayBuffer, padding: number, oaepHash: string | undefined, oaepLabel: BinaryLike | undefined) => Buffer;
export type PrivateDecryptMethod = (data: ArrayBuffer, format: number, type: KeyEncoding | undefined, passphrase: BinaryLike | undefined, buffer: ArrayBuffer, padding: number, oaepHash: string | undefined, oaepLabel: BinaryLike | undefined) => Buffer;
export type GenerateKeyPairMethod = (keyVariant: KeyVariant, ...rest: unknown[]) => Promise<GenerateKeyPairReturn>;
export type GenerateKeyPairSyncMethod = (keyVariant: KeyVariant, ...rest: unknown[]) => GenerateKeyPairReturn;
export type CreatePublicKeyMethod = (key: BinaryLike | EncodingOptions) => PublicKeyObject;
export type CreatePrivateKeyMethod = (key: BinaryLike | EncodingOptions) => PrivateKeyObject;
export type CreateSecretKeyMethod = (key: BinaryLike | EncodingOptions, encoding?: string) => SecretKeyObject;
//# sourceMappingURL=Cipher.d.ts.map