"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.install = exports.default = void 0;
var _reactNativeBuffer = require("@craftzdog/react-native-buffer");
var pbkdf2 = _interopRequireWildcard(require("./pbkdf2"));
var random = _interopRequireWildcard(require("./random"));
var _Cipher = require("./Cipher");
var _keygen = require("./keygen");
var _sig = require("./sig");
var _Hmac = require("./Hmac");
var _Hash = require("./Hash");
var _constants = require("./constants");
var _subtle = require("./subtle");
var _Utils = require("./Utils");
var _webcrypto = _interopRequireDefault(require("./webcrypto"));
var _keys = require("./keys");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Loosely matches Node.js {crypto} with some unimplemented functionality
 */
const QuickCrypto = {
  createHmac: _Hmac.createHmac,
  Hmac: _Hmac.createHmac,
  Hash: _Hash.createHash,
  createHash: _Hash.createHash,
  createCipher: _Cipher.createCipher,
  createCipheriv: _Cipher.createCipheriv,
  createDecipher: _Cipher.createDecipher,
  createDecipheriv: _Cipher.createDecipheriv,
  createPublicKey: _keys.createPublicKey,
  createPrivateKey: _keys.createPrivateKey,
  createSecretKey: _keys.createSecretKey,
  publicEncrypt: _Cipher.publicEncrypt,
  publicDecrypt: _Cipher.publicDecrypt,
  privateDecrypt: _Cipher.privateDecrypt,
  generateKey: _keygen.generateKey,
  generateKeyPair: _Cipher.generateKeyPair,
  generateKeyPairSync: _Cipher.generateKeyPairSync,
  generateKeySync: _keygen.generateKeySync,
  createSign: _sig.createSign,
  createVerify: _sig.createVerify,
  subtle: _subtle.subtle,
  constants: _constants.constants,
  ...pbkdf2,
  ...random,
  getCiphers: _Utils.getCiphers,
  getHashes: _Utils.getHashes,
  webcrypto: _webcrypto.default
};

/**
 * Optional. Patch global.crypto with quickcrypto and global.Buffer with react-native-buffer.
 */
const install = () => {
  // @ts-expect-error copyBytesFrom and poolSizets are missing from react-native-buffer
  global.Buffer = _reactNativeBuffer.Buffer;

  // @ts-expect-error subtle isn't fully implemented and Cryptokey is missing
  global.crypto = QuickCrypto;
};
exports.install = install;
var _default = exports.default = QuickCrypto; // Additional exports for CommonJS compatibility
module.exports = QuickCrypto;
module.exports.default = QuickCrypto;
module.exports.install = install;
//# sourceMappingURL=index.js.map