import { PackageJson } from 'type-fest';
/**
 * Determines whether or not the node exists in the package.json file
 *
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @return True if the node exists. False if it is not.
 */
export declare const exists: (packageJsonData: PackageJson | any, nodeName: string) => boolean;
/**
 * Search for duplicate properties in package.json file
 *
 * @param packageJsonSource JSON source string
 * @return List of duplicate property names.
 */
export declare const findDuplicatePropNames: (packageJsonSource: string) => string[];
