import { PackageJson } from 'type-fest';
import { LintResult } from './lint-result';
import { Severity } from './severity';
export type StandardLintFunction = (packageJsonData: PackageJson | any, severity: Severity) => LintResult;
export type ArrayLintFunction = <T>(packageJsonData: PackageJson | any, severity: Severity, ruleConfig: T[]) => LintResult;
export type ObjectLintFunction = (packageJsonData: PackageJson | any, severity: Severity, ruleConfig: Record<string, boolean>) => LintResult;
export interface OptionalObjectRuleConfig {
    exceptions?: string[];
}
export type OptionalObjectLintFunction = (packageJsonData: PackageJson | any, severity: Severity, ruleConfig: OptionalObjectRuleConfig) => LintResult;
export type LintFunction = StandardLintFunction | ArrayLintFunction | ObjectLintFunction | OptionalObjectLintFunction;
