import { PackageJson } from 'type-fest';
import { LintResult } from '../types/lint-result';
import { RuleType } from '../types/rule-type';
import { Severity } from '../types/severity';
export declare const ruleType = RuleType.Array;
export declare const minItems = 1;
/**
 * [function description]
 * @param  {Object}   packageJsonData   Valid package.json object
 * @param  {String}   severity          'error' or 'warning'
 * @param  {Array}    validValues       An array of valid values
 * @return {Object|Boolean}             LintIssue object if invalid. True if valid
 */
export declare const lint: (packageJsonData: PackageJson | any, severity: Severity, validValues: string[]) => LintResult;
