import { PackageJson } from 'type-fest';
import { Ignore } from 'ignore';
import { Rules } from '../native-rules';
import { LintIssue } from '../lint-issue';
import { OverallAggregatedResultCounts } from './results-helper';
import { Config } from '../configuration';
import { PackageJsonFileLintingResult } from '../types/package-json-linting-result';
export interface CreateResultObjectOptions {
    /**
     * The current working directory.
     */
    cwd: string;
    /**
     * An optional string representing the package.json file.
     */
    fileName: string;
    /**
     * A flag indicating that the file was skipped.
     */
    ignored: boolean;
    /**
     * A list of issues.
     */
    issues: LintIssue[];
    /**
     * Number of errors.
     */
    errorCount: number;
    /**
     * Number of warnings.
     */
    warningCount: number;
}
export interface LinterResult {
    results: LintIssue[];
    ignoreCount: number;
    /**
     * Number of errors for the package.json file.
     */
    errorCount: number;
    /**
     * Number of warnings for the package.json file.
     */
    warningCount: number;
}
export interface ExecuteOnPackageJsonObjectOptions {
    /**
     * The current working directory.
     */
    cwd: string;
    /**
     *  An object representation of a package.json file.
     */
    packageJsonObject: PackageJson | any;
    /**
     * An optional string representing the texts filename.
     */
    filename?: string;
    /**
     * An instance of the `ignore` module.
     */
    ignorer: Ignore;
    /**
     * An instance of {@Config}.
     */
    configHelper: Config;
    /**
     * An instance of {@link Rules}
     */
    rules: Rules;
}
export interface OverallLintingResult extends OverallAggregatedResultCounts {
    results: PackageJsonFileLintingResult[];
}
/**
 * Executes linter on package.json object
 *
 * @param options A {@link ExecuteOnPackageJsonObjectOptions} object
 * @returns The results {@link OverallLintingResult} from linting a collection of package.json files.
 */
export declare const executeOnPackageJsonObject: (options: ExecuteOnPackageJsonObjectOptions) => OverallLintingResult;
export interface ExecuteOnPackageJsonFilesOptions {
    /**
     * The current working directory.
     */
    cwd: string;
    /**
     * An array of files and directory names.
     */
    fileList: string[];
    /**
     * An instance of the `ignore` module.
     */
    ignorer: Ignore;
    /**
     * An instance of {@Config}.
     */
    configHelper: Config;
    /**
     * An instance of {@link Rules}
     */
    rules: Rules;
}
/**
 * Executes the current configuration on an array of file and directory names.
 * @param options A {@link ExecuteOnPackageJsonFilesOptions} object
 * @returns The results {@link OverallLintingResult} from linting a collection of package.json files.
 */
export declare const executeOnPackageJsonFiles: (options: ExecuteOnPackageJsonFilesOptions) => OverallLintingResult;
