"use strict";

import { PixelRatio, processColor } from 'react-native';
import { DEFAULT_ICON_COLOR, DEFAULT_ICON_SIZE } from "./defaults.js";
import { ensureGetImageAvailable } from "./get-image-library.js";
export const getImageSourceSync = (imageSourceCache, fontReference, glyph, size = DEFAULT_ICON_SIZE, color = DEFAULT_ICON_COLOR) => {
  const NativeIconAPI = ensureGetImageAvailable();
  const processedColor = processColor(color);
  const cacheKey = `${glyph}:${size}:${String(processedColor)}`;
  const maybeCachedValue = imageSourceCache.get(cacheKey);
  if (maybeCachedValue !== undefined) {
    // FIXME: Should this check if it's an error and throw it again?
    return maybeCachedValue;
  }
  try {
    const imagePath = NativeIconAPI.getImageForFontSync(fontReference, glyph, size, processedColor // FIXME what if a non existent colour was passed in?
    );
    const value = {
      uri: imagePath,
      scale: PixelRatio.get()
    };
    imageSourceCache.setValue(cacheKey, value);
    return value;
  } catch (error) {
    imageSourceCache.setError(cacheKey, error);
    throw error;
  }
};
export const getImageSource = async (imageSourceCache, fontReference, glyph, size = DEFAULT_ICON_SIZE, color = DEFAULT_ICON_COLOR) => {
  const NativeIconAPI = ensureGetImageAvailable();
  const processedColor = processColor(color);
  const cacheKey = `${glyph}:${size}:${String(processedColor)}`;
  const maybeCachedValue = imageSourceCache.get(cacheKey);
  if (maybeCachedValue !== undefined) {
    // FIXME: Should this check if it's an error and throw it again?
    return maybeCachedValue;
  }
  try {
    const imagePath = await NativeIconAPI.getImageForFont(fontReference, glyph, size, processedColor // FIXME what if a non existent colour was passed in?
    );
    const value = {
      uri: imagePath,
      scale: PixelRatio.get()
    };
    imageSourceCache.setValue(cacheKey, value);
    return value;
  } catch (error) {
    imageSourceCache.setError(cacheKey, error);
    throw error;
  }
};
//# sourceMappingURL=get-image-source.js.map