import { NativeModules } from 'react-native';
import fallback from 'base64-js';
const Base64Module = NativeModules.QuickBase64;
if (Base64Module && typeof Base64Module.install === 'function') {
  Base64Module.install();
}
// from https://github.com/beatgammit/base64-js/blob/master/index.js
function getLens(b64) {
  let len = b64.length;
  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4');
  }
  let validLen = b64.indexOf('=');
  if (validLen === -1) validLen = len;
  let placeHoldersLen = validLen === len ? 0 : 4 - validLen % 4;
  return [validLen, placeHoldersLen];
}
function uint8ArrayToString(array) {
  let out = '',
    i = 0,
    len = array.length;
  while (i < len) {
    const c = array[i++];
    out += String.fromCharCode(c);
  }
  return out;
}
function stringToArrayBuffer(str) {
  const buf = new ArrayBuffer(str.length);
  const bufView = new Uint8Array(buf);
  for (let i = 0, strLen = str.length; i < strLen; i++) {
    bufView[i] = str.charCodeAt(i);
  }
  return buf;
}
export function byteLength(b64) {
  let lens = getLens(b64);
  let validLen = lens[0];
  let placeHoldersLen = lens[1];
  return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
}
export function toByteArray(b64, removeLinebreaks = false) {
  if (typeof base64ToArrayBuffer !== 'undefined') {
    return new Uint8Array(base64ToArrayBuffer(b64, removeLinebreaks));
  } else {
    return fallback.toByteArray(b64);
  }
}
export function fromByteArray(uint8, urlSafe = false) {
  if (typeof base64FromArrayBuffer !== 'undefined') {
    if (uint8.buffer.byteLength > uint8.byteLength || uint8.byteOffset > 0) {
      return base64FromArrayBuffer(uint8.buffer.slice(uint8.byteOffset, uint8.byteOffset + uint8.byteLength), urlSafe);
    }
    return base64FromArrayBuffer(uint8.buffer, urlSafe);
  } else {
    return fallback.fromByteArray(uint8);
  }
}
export function btoa(data) {
  const ab = stringToArrayBuffer(data);
  if (typeof base64FromArrayBuffer !== 'undefined') {
    return base64FromArrayBuffer(ab);
  } else {
    return fallback.fromByteArray(new Uint8Array(ab));
  }
}
export function atob(b64) {
  const ua = toByteArray(b64);
  return uint8ArrayToString(ua);
}
export function shim() {
  ;
  global.btoa = btoa;
  global.atob = atob;
}
export const getNative = () => ({
  base64FromArrayBuffer,
  base64ToArrayBuffer
});
export const trimBase64Padding = str => {
  return str.replace(/[.=]{1,2}$/, '');
};
//# sourceMappingURL=index.js.map