import { LRLanguage, LanguageSupport } from '@codemirror/language';

/**
A language provider for Angular Templates.
*/
declare const angularLanguage: LRLanguage;
/**
Angular Template language support.
*/
declare function angular(config?: {
    /**
    Provide an HTML language configuration to use as a base. _Must_
    be the result of calling `html()` from `@codemirror/lang-html`,
    not just any `LanguageSupport` object.
    */
    base?: LanguageSupport;
}): LanguageSupport;

export { angular, angularLanguage };
