/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import type { MetadataOptions, PluginOptions, CategoryIndexMatcher, DocMetadataBase, VersionMetadata, LoadedVersion } from '@docusaurus/plugin-content-docs';
import type { LoadContext } from '@docusaurus/types';
import type { SidebarsUtils } from './sidebars/utils';
import type { DocFile } from './types';
export declare function readDocFile(versionMetadata: Pick<VersionMetadata, 'contentPath' | 'contentPathLocalized'>, source: string): Promise<DocFile>;
export declare function readVersionDocs(versionMetadata: VersionMetadata, options: Pick<PluginOptions, 'include' | 'exclude' | 'showLastUpdateAuthor' | 'showLastUpdateTime'>): Promise<DocFile[]>;
export declare type DocEnv = 'production' | 'development';
export declare function processDocMetadata(args: {
    docFile: DocFile;
    versionMetadata: VersionMetadata;
    context: LoadContext;
    options: MetadataOptions;
    env: DocEnv;
}): Promise<DocMetadataBase>;
export declare function addDocNavigation(docsBase: DocMetadataBase[], sidebarsUtils: SidebarsUtils, sidebarFilePath: string): LoadedVersion['docs'];
/**
 * The "main doc" is the "version entry point"
 * We browse this doc by clicking on a version:
 * - the "home" doc (at '/docs/')
 * - the first doc of the first sidebar
 * - a random doc (if no docs are in any sidebar... edge case)
 */
export declare function getMainDocId({ docs, sidebarsUtils, }: {
    docs: DocMetadataBase[];
    sidebarsUtils: SidebarsUtils;
}): string;
export declare const isCategoryIndex: CategoryIndexMatcher;
/**
 * `guides/sidebar/autogenerated.md` ->
 *   `'autogenerated', '.md', ['sidebar', 'guides']`
 */
export declare function toCategoryIndexMatcherParam({ source, sourceDirName, }: Pick<DocMetadataBase, 'source' | 'sourceDirName'>): Parameters<CategoryIndexMatcher>[0];
export declare function getDocIds(doc: DocMetadataBase): [string, string];
export declare function createDocsByIdIndex<Doc extends {
    id: string;
    unversionedId: string;
}>(docs: Doc[]): {
    [docId: string]: Doc;
};
