import { ChainFunction, SequenceBuilder } from './types';
export declare const builder: Readonly<{
    pipe: <T, U>(fn: ChainFunction<T, U>) => SequenceBuilder<T, U>;
    /** keep values where the fnFilter(t) returns true */
    filter: <T_1>(fnFilter: (t: T_1) => boolean) => SequenceBuilder<T_1, T_1>;
    skip: <T_2>(n: number) => SequenceBuilder<T_2, T_2>;
    take: <T_3>(n: number) => SequenceBuilder<T_3, T_3>;
    concat: <T_4>(j: Iterable<T_4>) => SequenceBuilder<T_4, T_4>;
    concatMap: <T_5, U_1>(fn: (t: T_5) => Iterable<U_1>) => SequenceBuilder<T_5, U_1>;
    combine: <T_6, U_2, V>(fn: (t: T_6, u?: U_2 | undefined) => V, j: Iterable<U_2>) => SequenceBuilder<T_6, V>;
    /** map values from type T to type U */
    map: <T_7, U_3>(fnMap: (t: T_7) => U_3) => SequenceBuilder<T_7, U_3>;
    scan: <T_8, U_4>(fnReduce: (previousValue: U_4, currentValue: T_8, currentIndex: number) => U_4, initialValue: U_4) => SequenceBuilder<T_8, U_4>;
}>;
