import { Sequence, GenIterable, Maybe, LazyIterable, ChainFunction, ThenArg } from './types';
export declare class ImplSequence<T> implements Sequence<T> {
    private i;
    private _iterator;
    constructor(i: LazyIterable<T>);
    private get iter();
    private get iterator();
    private inject;
    private chain;
    [Symbol.iterator](): Iterator<T, any, undefined> | IterableIterator<T>;
    next(): IteratorResult<T>;
    filter(fnFilter: (t: T) => boolean): ImplSequence<T>;
    skip(n: number): ImplSequence<T>;
    take(n: number): ImplSequence<T>;
    concat(j: Iterable<T>): ImplSequence<T>;
    concatMap<U>(fn: (t: T) => Iterable<U>): ImplSequence<U>;
    combine<U, V>(fn: (t: T, u?: U) => V, j: Iterable<U>): ImplSequence<V>;
    map<U>(fn: (t: T) => U): ImplSequence<U>;
    scan<U>(fnReduce: (prevValue: U, curValue: T, curIndex: number) => U, initValue: U): ImplSequence<U>;
    pipe(): Sequence<T>;
    pipe<T1>(fn0: ChainFunction<T, T1>): Sequence<T1>;
    pipe<T1, T2>(fn0: ChainFunction<T, T1>, fn1: ChainFunction<T1, T2>): Sequence<T2>;
    pipe<T1, T2, T3>(fn0: ChainFunction<T, T1>, fn1: ChainFunction<T1, T2>, fn2: ChainFunction<T2, T3>): Sequence<T3>;
    pipe<T1, T2, T3, T4>(fn0: ChainFunction<T, T1>, fn1: ChainFunction<T1, T2>, fn2: ChainFunction<T2, T3>, fn3: ChainFunction<T3, T4>): Sequence<T4>;
    pipe<T1, T2, T3, T4, T5>(fn0: ChainFunction<T, T1>, fn1: ChainFunction<T1, T2>, fn2: ChainFunction<T2, T3>, fn3: ChainFunction<T3, T4>, fn4: ChainFunction<T4, T5>): Sequence<T5>;
    pipe<T1, T2, T3, T4, T5, T6>(fn0: ChainFunction<T, T1>, fn1: ChainFunction<T1, T2>, fn2: ChainFunction<T2, T3>, fn3: ChainFunction<T3, T4>, fn4: ChainFunction<T4, T5>, fn5: ChainFunction<T5, T6>): Sequence<T6>;
    pipe<T1, T2, T3, T4, T5, T6>(fn0: ChainFunction<T, T1>, fn1: ChainFunction<T1, T2>, fn2: ChainFunction<T2, T3>, fn3: ChainFunction<T3, T4>, fn4: ChainFunction<T4, T5>, fn5: ChainFunction<T5, T6>, ...fnRest: ChainFunction<T6, T6>[]): Sequence<T6>;
    all(fnFilter: (t: T) => boolean): boolean;
    any(fnFilter: (t: T) => boolean): boolean;
    count(): number;
    first(fnFilter: (t: T) => boolean, defaultValue: T): T;
    forEach(fn: (t: T, index: number) => void): void;
    max(fnSelector?: (t: T) => T): Maybe<T>;
    min(fnSelector?: (t: T) => T): Maybe<T>;
    reduce<U>(fnReduce: (prevValue: U, curValue: T, curIndex: number) => U, initValue?: U): U;
    reduceAsync<U>(fnReduceAsync: (previousValue: ThenArg<U>, currentValue: ThenArg<T>, currentIndex: number) => ThenArg<U> | Promise<ThenArg<U>>, initialValue?: ThenArg<U>): Promise<ThenArg<U>>;
    reduceToSequence<U>(fnReduce: (previousValue: GenIterable<U>, currentValue: T, currentIndex: number) => GenIterable<U>, initialValue: GenIterable<U>): ImplSequence<U>;
    toArray(): T[];
    toIterable(): Generator<T, void, undefined>;
}
