"use strict";

/* eslint-disable react/jsx-pascal-case, no-console */

/**
 * This is a generated file. If you modify it manually, your changes will be lost!
 * Instead, modify the template in `fontawesome-common/generator`.
 *
 * FontAwesome5 icon set component.
 * Usage: <FontAwesome5 name="icon-name" size={20} color="#4F8EF7" />
 */

import { Platform } from 'react-native';
import { createIconSet, DEFAULT_ICON_COLOR, DEFAULT_ICON_SIZE } from '@react-native-vector-icons/common';
import brandGM from '../../glyphmaps/FontAwesome5_brand.json';
import regularGM from '../../glyphmaps/FontAwesome5_regular.json';
import solidGM from '../../glyphmaps/FontAwesome5_solid.json';
import metadata from '../../glyphmaps/FontAwesome5_meta.json';
import { jsx as _jsx } from "react/jsx-runtime";
const glyphValidator = (glyph, iconType) => metadata[iconType]?.includes(glyph);
const fontStyle = fontWeight => Platform.select({
  ios: {
    fontWeight
  },
  default: {}
});

// biome-ignore format: We want these to be consistent and we are fine with single for all
const RegularIcon = createIconSet(regularGM, {
  postScriptName: 'FontAwesome5Free-Regular',
  fontFileName: 'FontAwesome5_Regular.ttf',
  fontSource: require('../../fonts/FontAwesome5_Regular.ttf'),
  // eslint-disable-line @typescript-eslint/no-require-imports, global-require
  fontStyle: fontStyle('400')
});
// biome-ignore format: We want these to be consistent and we are fine with single for all
const SolidIcon = createIconSet(solidGM, {
  postScriptName: 'FontAwesome5Free-Solid',
  fontFileName: 'FontAwesome5_Solid.ttf',
  fontSource: require('../../fonts/FontAwesome5_Solid.ttf'),
  // eslint-disable-line @typescript-eslint/no-require-imports, global-require
  fontStyle: fontStyle('900')
});
// biome-ignore format: We want these to be consistent and we are fine with single for all
const BrandIcon = createIconSet(brandGM, {
  postScriptName: 'FontAwesome5Brands-Regular',
  fontFileName: 'FontAwesome5_Brands.ttf',
  fontSource: require('../../fonts/FontAwesome5_Brands.ttf'),
  // eslint-disable-line @typescript-eslint/no-require-imports, global-require
  fontStyle: fontStyle('400')
});
export const FontAwesome5 = props => {
  const {
    iconStyle,
    name
  } = props;
  if (!iconStyle) {
    if (!glyphValidator(name, 'regular')) {
      console.warn(`noSuchGlyph: glyph ${String(name)} does not exist for 'regular' icon type for FontAwesome5`);
    }
    return /*#__PURE__*/_jsx(RegularIcon, {
      ...props
    });
  }
  if (!glyphValidator(name, iconStyle)) {
    console.warn(`noSuchGlyph: glyph ${String(name)} does not exist for '${iconStyle}' icon type for FontAwesome5`);
    return /*#__PURE__*/_jsx(RegularIcon, {
      ...props
    });
  }
  switch (iconStyle) {
    case 'brand':
      return /*#__PURE__*/_jsx(BrandIcon, {
        ...props
      });
    case 'regular':
      return /*#__PURE__*/_jsx(RegularIcon, {
        ...props
      });
    case 'solid':
      return /*#__PURE__*/_jsx(SolidIcon, {
        ...props
      });
    default:
      console.warn(`noSuchIconTypeName: '${iconStyle}' icon type does not exist for FontAwesome5`);
      return /*#__PURE__*/_jsx(RegularIcon, {
        ...props
      });
  }
};
// biome-ignore format: We want these to be consistent and we are fine with single for all
const getImageSource = (iconStyle, name, size = DEFAULT_ICON_SIZE, color = DEFAULT_ICON_COLOR) => {
  switch (iconStyle) {
    case 'brand':
      return BrandIcon.getImageSource(name, size, color);
    case 'regular':
      return RegularIcon.getImageSource(name, size, color);
    case 'solid':
      return SolidIcon.getImageSource(name, size, color);
    default:
      console.warn(`noSuchIconTypeName: '${iconStyle}' icon type does not exist for FontAwesome5`);
      return RegularIcon.getImageSource(name, size, color);
  }
};
FontAwesome5.getImageSource = getImageSource;
// biome-ignore format: We want these to be consistent and we are fine with single for all
const getImageSourceSync = (iconStyle, name, size = DEFAULT_ICON_SIZE, color = DEFAULT_ICON_COLOR) => {
  switch (iconStyle) {
    case 'brand':
      return BrandIcon.getImageSourceSync(name, size, color);
    case 'regular':
      return RegularIcon.getImageSourceSync(name, size, color);
    case 'solid':
      return SolidIcon.getImageSourceSync(name, size, color);
    default:
      console.warn(`noSuchIconTypeName: '${iconStyle}' icon type does not exist for FontAwesome5`);
      return RegularIcon.getImageSourceSync(name, size, color);
  }
};
FontAwesome5.getImageSourceSync = getImageSourceSync;
/** @alias */
export default FontAwesome5;
//# sourceMappingURL=index.js.map