"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FontAwesome5 = void 0;
var _reactNative = require("react-native");
var _common = require("@react-native-vector-icons/common");
var _FontAwesome5_brand = _interopRequireDefault(require("../../glyphmaps/FontAwesome5_brand.json"));
var _FontAwesome5_regular = _interopRequireDefault(require("../../glyphmaps/FontAwesome5_regular.json"));
var _FontAwesome5_solid = _interopRequireDefault(require("../../glyphmaps/FontAwesome5_solid.json"));
var _FontAwesome5_meta = _interopRequireDefault(require("../../glyphmaps/FontAwesome5_meta.json"));
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/* eslint-disable react/jsx-pascal-case, no-console */

/**
 * This is a generated file. If you modify it manually, your changes will be lost!
 * Instead, modify the template in `fontawesome-common/generator`.
 *
 * FontAwesome5 icon set component.
 * Usage: <FontAwesome5 name="icon-name" size={20} color="#4F8EF7" />
 */

const glyphValidator = (glyph, iconType) => _FontAwesome5_meta.default[iconType]?.includes(glyph);
const fontStyle = fontWeight => _reactNative.Platform.select({
  ios: {
    fontWeight
  },
  default: {}
});

// biome-ignore format: We want these to be consistent and we are fine with single for all
const RegularIcon = (0, _common.createIconSet)(_FontAwesome5_regular.default, {
  postScriptName: 'FontAwesome5Free-Regular',
  fontFileName: 'FontAwesome5_Regular.ttf',
  fontSource: require('../../fonts/FontAwesome5_Regular.ttf'),
  // eslint-disable-line @typescript-eslint/no-require-imports, global-require
  fontStyle: fontStyle('400')
});
// biome-ignore format: We want these to be consistent and we are fine with single for all
const SolidIcon = (0, _common.createIconSet)(_FontAwesome5_solid.default, {
  postScriptName: 'FontAwesome5Free-Solid',
  fontFileName: 'FontAwesome5_Solid.ttf',
  fontSource: require('../../fonts/FontAwesome5_Solid.ttf'),
  // eslint-disable-line @typescript-eslint/no-require-imports, global-require
  fontStyle: fontStyle('900')
});
// biome-ignore format: We want these to be consistent and we are fine with single for all
const BrandIcon = (0, _common.createIconSet)(_FontAwesome5_brand.default, {
  postScriptName: 'FontAwesome5Brands-Regular',
  fontFileName: 'FontAwesome5_Brands.ttf',
  fontSource: require('../../fonts/FontAwesome5_Brands.ttf'),
  // eslint-disable-line @typescript-eslint/no-require-imports, global-require
  fontStyle: fontStyle('400')
});
const FontAwesome5 = props => {
  const {
    iconStyle,
    name
  } = props;
  if (!iconStyle) {
    if (!glyphValidator(name, 'regular')) {
      console.warn(`noSuchGlyph: glyph ${String(name)} does not exist for 'regular' icon type for FontAwesome5`);
    }
    return /*#__PURE__*/(0, _jsxRuntime.jsx)(RegularIcon, {
      ...props
    });
  }
  if (!glyphValidator(name, iconStyle)) {
    console.warn(`noSuchGlyph: glyph ${String(name)} does not exist for '${iconStyle}' icon type for FontAwesome5`);
    return /*#__PURE__*/(0, _jsxRuntime.jsx)(RegularIcon, {
      ...props
    });
  }
  switch (iconStyle) {
    case 'brand':
      return /*#__PURE__*/(0, _jsxRuntime.jsx)(BrandIcon, {
        ...props
      });
    case 'regular':
      return /*#__PURE__*/(0, _jsxRuntime.jsx)(RegularIcon, {
        ...props
      });
    case 'solid':
      return /*#__PURE__*/(0, _jsxRuntime.jsx)(SolidIcon, {
        ...props
      });
    default:
      console.warn(`noSuchIconTypeName: '${iconStyle}' icon type does not exist for FontAwesome5`);
      return /*#__PURE__*/(0, _jsxRuntime.jsx)(RegularIcon, {
        ...props
      });
  }
};
exports.FontAwesome5 = FontAwesome5;
// biome-ignore format: We want these to be consistent and we are fine with single for all
const getImageSource = (iconStyle, name, size = _common.DEFAULT_ICON_SIZE, color = _common.DEFAULT_ICON_COLOR) => {
  switch (iconStyle) {
    case 'brand':
      return BrandIcon.getImageSource(name, size, color);
    case 'regular':
      return RegularIcon.getImageSource(name, size, color);
    case 'solid':
      return SolidIcon.getImageSource(name, size, color);
    default:
      console.warn(`noSuchIconTypeName: '${iconStyle}' icon type does not exist for FontAwesome5`);
      return RegularIcon.getImageSource(name, size, color);
  }
};
FontAwesome5.getImageSource = getImageSource;
// biome-ignore format: We want these to be consistent and we are fine with single for all
const getImageSourceSync = (iconStyle, name, size = _common.DEFAULT_ICON_SIZE, color = _common.DEFAULT_ICON_COLOR) => {
  switch (iconStyle) {
    case 'brand':
      return BrandIcon.getImageSourceSync(name, size, color);
    case 'regular':
      return RegularIcon.getImageSourceSync(name, size, color);
    case 'solid':
      return SolidIcon.getImageSourceSync(name, size, color);
    default:
      console.warn(`noSuchIconTypeName: '${iconStyle}' icon type does not exist for FontAwesome5`);
      return RegularIcon.getImageSourceSync(name, size, color);
  }
};
FontAwesome5.getImageSourceSync = getImageSourceSync;
/** @alias */
var _default = exports.default = FontAwesome5;
//# sourceMappingURL=index.js.map