import {
  cytoscape as cytoscape2
} from "./chunk-COUQ6RZ3.mjs";
import {
  selectSvgElement
} from "./chunk-S7TAX6XP.mjs";
import {
  createText
} from "./chunk-VNOTBLTU.mjs";
import {
  parseFontSize
} from "./chunk-UKINNZLQ.mjs";
import "./chunk-GKOISANM.mjs";
import {
  darken_default,
  defaultConfig_default,
  getConfig2 as getConfig,
  is_dark_default,
  lighten_default,
  log,
  sanitizeText,
  select_default,
  setupGraphViewbox
} from "./chunk-NC4V57XB.mjs";
import "./chunk-HD3LK5B5.mjs";
import {
  __commonJS,
  __name,
  __toESM
} from "./chunk-DLQEHMXD.mjs";

// ../../node_modules/.pnpm/layout-base@1.0.2/node_modules/layout-base/layout-base.js
var require_layout_base = __commonJS({
  "../../node_modules/.pnpm/layout-base@1.0.2/node_modules/layout-base/layout-base.js"(exports, module) {
    "use strict";
    (/* @__PURE__ */ __name(function webpackUniversalModuleDefinition(root, factory) {
      if (typeof exports === "object" && typeof module === "object")
        module.exports = factory();
      else if (typeof define === "function" && define.amd)
        define([], factory);
      else if (typeof exports === "object")
        exports["layoutBase"] = factory();
      else
        root["layoutBase"] = factory();
    }, "webpackUniversalModuleDefinition"))(exports, function() {
      return (
        /******/
        function(modules) {
          var installedModules = {};
          function __webpack_require__(moduleId) {
            if (installedModules[moduleId]) {
              return installedModules[moduleId].exports;
            }
            var module2 = installedModules[moduleId] = {
              /******/
              i: moduleId,
              /******/
              l: false,
              /******/
              exports: {}
              /******/
            };
            modules[moduleId].call(module2.exports, module2, module2.exports, __webpack_require__);
            module2.l = true;
            return module2.exports;
          }
          __name(__webpack_require__, "__webpack_require__");
          __webpack_require__.m = modules;
          __webpack_require__.c = installedModules;
          __webpack_require__.i = function(value) {
            return value;
          };
          __webpack_require__.d = function(exports2, name, getter) {
            if (!__webpack_require__.o(exports2, name)) {
              Object.defineProperty(exports2, name, {
                /******/
                configurable: false,
                /******/
                enumerable: true,
                /******/
                get: getter
                /******/
              });
            }
          };
          __webpack_require__.n = function(module2) {
            var getter = module2 && module2.__esModule ? (
              /******/
              /* @__PURE__ */ __name(function getDefault() {
                return module2["default"];
              }, "getDefault")
            ) : (
              /******/
              /* @__PURE__ */ __name(function getModuleExports() {
                return module2;
              }, "getModuleExports")
            );
            __webpack_require__.d(getter, "a", getter);
            return getter;
          };
          __webpack_require__.o = function(object, property) {
            return Object.prototype.hasOwnProperty.call(object, property);
          };
          __webpack_require__.p = "";
          return __webpack_require__(__webpack_require__.s = 26);
        }([
          /* 0 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            function LayoutConstants() {
            }
            __name(LayoutConstants, "LayoutConstants");
            LayoutConstants.QUALITY = 1;
            LayoutConstants.DEFAULT_CREATE_BENDS_AS_NEEDED = false;
            LayoutConstants.DEFAULT_INCREMENTAL = false;
            LayoutConstants.DEFAULT_ANIMATION_ON_LAYOUT = true;
            LayoutConstants.DEFAULT_ANIMATION_DURING_LAYOUT = false;
            LayoutConstants.DEFAULT_ANIMATION_PERIOD = 50;
            LayoutConstants.DEFAULT_UNIFORM_LEAF_NODE_SIZES = false;
            LayoutConstants.DEFAULT_GRAPH_MARGIN = 15;
            LayoutConstants.NODE_DIMENSIONS_INCLUDE_LABELS = false;
            LayoutConstants.SIMPLE_NODE_SIZE = 40;
            LayoutConstants.SIMPLE_NODE_HALF_SIZE = LayoutConstants.SIMPLE_NODE_SIZE / 2;
            LayoutConstants.EMPTY_COMPOUND_NODE_SIZE = 40;
            LayoutConstants.MIN_EDGE_LENGTH = 1;
            LayoutConstants.WORLD_BOUNDARY = 1e6;
            LayoutConstants.INITIAL_WORLD_BOUNDARY = LayoutConstants.WORLD_BOUNDARY / 1e3;
            LayoutConstants.WORLD_CENTER_X = 1200;
            LayoutConstants.WORLD_CENTER_Y = 900;
            module2.exports = LayoutConstants;
          },
          /* 1 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var LGraphObject = __webpack_require__(2);
            var IGeometry = __webpack_require__(8);
            var IMath = __webpack_require__(9);
            function LEdge(source, target, vEdge) {
              LGraphObject.call(this, vEdge);
              this.isOverlapingSourceAndTarget = false;
              this.vGraphObject = vEdge;
              this.bendpoints = [];
              this.source = source;
              this.target = target;
            }
            __name(LEdge, "LEdge");
            LEdge.prototype = Object.create(LGraphObject.prototype);
            for (var prop in LGraphObject) {
              LEdge[prop] = LGraphObject[prop];
            }
            LEdge.prototype.getSource = function() {
              return this.source;
            };
            LEdge.prototype.getTarget = function() {
              return this.target;
            };
            LEdge.prototype.isInterGraph = function() {
              return this.isInterGraph;
            };
            LEdge.prototype.getLength = function() {
              return this.length;
            };
            LEdge.prototype.isOverlapingSourceAndTarget = function() {
              return this.isOverlapingSourceAndTarget;
            };
            LEdge.prototype.getBendpoints = function() {
              return this.bendpoints;
            };
            LEdge.prototype.getLca = function() {
              return this.lca;
            };
            LEdge.prototype.getSourceInLca = function() {
              return this.sourceInLca;
            };
            LEdge.prototype.getTargetInLca = function() {
              return this.targetInLca;
            };
            LEdge.prototype.getOtherEnd = function(node) {
              if (this.source === node) {
                return this.target;
              } else if (this.target === node) {
                return this.source;
              } else {
                throw "Node is not incident with this edge";
              }
            };
            LEdge.prototype.getOtherEndInGraph = function(node, graph) {
              var otherEnd = this.getOtherEnd(node);
              var root = graph.getGraphManager().getRoot();
              while (true) {
                if (otherEnd.getOwner() == graph) {
                  return otherEnd;
                }
                if (otherEnd.getOwner() == root) {
                  break;
                }
                otherEnd = otherEnd.getOwner().getParent();
              }
              return null;
            };
            LEdge.prototype.updateLength = function() {
              var clipPointCoordinates = new Array(4);
              this.isOverlapingSourceAndTarget = IGeometry.getIntersection(this.target.getRect(), this.source.getRect(), clipPointCoordinates);
              if (!this.isOverlapingSourceAndTarget) {
                this.lengthX = clipPointCoordinates[0] - clipPointCoordinates[2];
                this.lengthY = clipPointCoordinates[1] - clipPointCoordinates[3];
                if (Math.abs(this.lengthX) < 1) {
                  this.lengthX = IMath.sign(this.lengthX);
                }
                if (Math.abs(this.lengthY) < 1) {
                  this.lengthY = IMath.sign(this.lengthY);
                }
                this.length = Math.sqrt(this.lengthX * this.lengthX + this.lengthY * this.lengthY);
              }
            };
            LEdge.prototype.updateLengthSimple = function() {
              this.lengthX = this.target.getCenterX() - this.source.getCenterX();
              this.lengthY = this.target.getCenterY() - this.source.getCenterY();
              if (Math.abs(this.lengthX) < 1) {
                this.lengthX = IMath.sign(this.lengthX);
              }
              if (Math.abs(this.lengthY) < 1) {
                this.lengthY = IMath.sign(this.lengthY);
              }
              this.length = Math.sqrt(this.lengthX * this.lengthX + this.lengthY * this.lengthY);
            };
            module2.exports = LEdge;
          },
          /* 2 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            function LGraphObject(vGraphObject) {
              this.vGraphObject = vGraphObject;
            }
            __name(LGraphObject, "LGraphObject");
            module2.exports = LGraphObject;
          },
          /* 3 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var LGraphObject = __webpack_require__(2);
            var Integer = __webpack_require__(10);
            var RectangleD = __webpack_require__(13);
            var LayoutConstants = __webpack_require__(0);
            var RandomSeed = __webpack_require__(16);
            var PointD = __webpack_require__(4);
            function LNode(gm, loc, size, vNode) {
              if (size == null && vNode == null) {
                vNode = loc;
              }
              LGraphObject.call(this, vNode);
              if (gm.graphManager != null) gm = gm.graphManager;
              this.estimatedSize = Integer.MIN_VALUE;
              this.inclusionTreeDepth = Integer.MAX_VALUE;
              this.vGraphObject = vNode;
              this.edges = [];
              this.graphManager = gm;
              if (size != null && loc != null) this.rect = new RectangleD(loc.x, loc.y, size.width, size.height);
              else this.rect = new RectangleD();
            }
            __name(LNode, "LNode");
            LNode.prototype = Object.create(LGraphObject.prototype);
            for (var prop in LGraphObject) {
              LNode[prop] = LGraphObject[prop];
            }
            LNode.prototype.getEdges = function() {
              return this.edges;
            };
            LNode.prototype.getChild = function() {
              return this.child;
            };
            LNode.prototype.getOwner = function() {
              return this.owner;
            };
            LNode.prototype.getWidth = function() {
              return this.rect.width;
            };
            LNode.prototype.setWidth = function(width) {
              this.rect.width = width;
            };
            LNode.prototype.getHeight = function() {
              return this.rect.height;
            };
            LNode.prototype.setHeight = function(height) {
              this.rect.height = height;
            };
            LNode.prototype.getCenterX = function() {
              return this.rect.x + this.rect.width / 2;
            };
            LNode.prototype.getCenterY = function() {
              return this.rect.y + this.rect.height / 2;
            };
            LNode.prototype.getCenter = function() {
              return new PointD(this.rect.x + this.rect.width / 2, this.rect.y + this.rect.height / 2);
            };
            LNode.prototype.getLocation = function() {
              return new PointD(this.rect.x, this.rect.y);
            };
            LNode.prototype.getRect = function() {
              return this.rect;
            };
            LNode.prototype.getDiagonal = function() {
              return Math.sqrt(this.rect.width * this.rect.width + this.rect.height * this.rect.height);
            };
            LNode.prototype.getHalfTheDiagonal = function() {
              return Math.sqrt(this.rect.height * this.rect.height + this.rect.width * this.rect.width) / 2;
            };
            LNode.prototype.setRect = function(upperLeft, dimension) {
              this.rect.x = upperLeft.x;
              this.rect.y = upperLeft.y;
              this.rect.width = dimension.width;
              this.rect.height = dimension.height;
            };
            LNode.prototype.setCenter = function(cx, cy) {
              this.rect.x = cx - this.rect.width / 2;
              this.rect.y = cy - this.rect.height / 2;
            };
            LNode.prototype.setLocation = function(x, y) {
              this.rect.x = x;
              this.rect.y = y;
            };
            LNode.prototype.moveBy = function(dx, dy) {
              this.rect.x += dx;
              this.rect.y += dy;
            };
            LNode.prototype.getEdgeListToNode = function(to) {
              var edgeList = [];
              var edge;
              var self = this;
              self.edges.forEach(function(edge2) {
                if (edge2.target == to) {
                  if (edge2.source != self) throw "Incorrect edge source!";
                  edgeList.push(edge2);
                }
              });
              return edgeList;
            };
            LNode.prototype.getEdgesBetween = function(other) {
              var edgeList = [];
              var edge;
              var self = this;
              self.edges.forEach(function(edge2) {
                if (!(edge2.source == self || edge2.target == self)) throw "Incorrect edge source and/or target";
                if (edge2.target == other || edge2.source == other) {
                  edgeList.push(edge2);
                }
              });
              return edgeList;
            };
            LNode.prototype.getNeighborsList = function() {
              var neighbors = /* @__PURE__ */ new Set();
              var self = this;
              self.edges.forEach(function(edge) {
                if (edge.source == self) {
                  neighbors.add(edge.target);
                } else {
                  if (edge.target != self) {
                    throw "Incorrect incidency!";
                  }
                  neighbors.add(edge.source);
                }
              });
              return neighbors;
            };
            LNode.prototype.withChildren = function() {
              var withNeighborsList = /* @__PURE__ */ new Set();
              var childNode;
              var children;
              withNeighborsList.add(this);
              if (this.child != null) {
                var nodes = this.child.getNodes();
                for (var i = 0; i < nodes.length; i++) {
                  childNode = nodes[i];
                  children = childNode.withChildren();
                  children.forEach(function(node) {
                    withNeighborsList.add(node);
                  });
                }
              }
              return withNeighborsList;
            };
            LNode.prototype.getNoOfChildren = function() {
              var noOfChildren = 0;
              var childNode;
              if (this.child == null) {
                noOfChildren = 1;
              } else {
                var nodes = this.child.getNodes();
                for (var i = 0; i < nodes.length; i++) {
                  childNode = nodes[i];
                  noOfChildren += childNode.getNoOfChildren();
                }
              }
              if (noOfChildren == 0) {
                noOfChildren = 1;
              }
              return noOfChildren;
            };
            LNode.prototype.getEstimatedSize = function() {
              if (this.estimatedSize == Integer.MIN_VALUE) {
                throw "assert failed";
              }
              return this.estimatedSize;
            };
            LNode.prototype.calcEstimatedSize = function() {
              if (this.child == null) {
                return this.estimatedSize = (this.rect.width + this.rect.height) / 2;
              } else {
                this.estimatedSize = this.child.calcEstimatedSize();
                this.rect.width = this.estimatedSize;
                this.rect.height = this.estimatedSize;
                return this.estimatedSize;
              }
            };
            LNode.prototype.scatter = function() {
              var randomCenterX;
              var randomCenterY;
              var minX = -LayoutConstants.INITIAL_WORLD_BOUNDARY;
              var maxX = LayoutConstants.INITIAL_WORLD_BOUNDARY;
              randomCenterX = LayoutConstants.WORLD_CENTER_X + RandomSeed.nextDouble() * (maxX - minX) + minX;
              var minY = -LayoutConstants.INITIAL_WORLD_BOUNDARY;
              var maxY = LayoutConstants.INITIAL_WORLD_BOUNDARY;
              randomCenterY = LayoutConstants.WORLD_CENTER_Y + RandomSeed.nextDouble() * (maxY - minY) + minY;
              this.rect.x = randomCenterX;
              this.rect.y = randomCenterY;
            };
            LNode.prototype.updateBounds = function() {
              if (this.getChild() == null) {
                throw "assert failed";
              }
              if (this.getChild().getNodes().length != 0) {
                var childGraph = this.getChild();
                childGraph.updateBounds(true);
                this.rect.x = childGraph.getLeft();
                this.rect.y = childGraph.getTop();
                this.setWidth(childGraph.getRight() - childGraph.getLeft());
                this.setHeight(childGraph.getBottom() - childGraph.getTop());
                if (LayoutConstants.NODE_DIMENSIONS_INCLUDE_LABELS) {
                  var width = childGraph.getRight() - childGraph.getLeft();
                  var height = childGraph.getBottom() - childGraph.getTop();
                  if (this.labelWidth > width) {
                    this.rect.x -= (this.labelWidth - width) / 2;
                    this.setWidth(this.labelWidth);
                  }
                  if (this.labelHeight > height) {
                    if (this.labelPos == "center") {
                      this.rect.y -= (this.labelHeight - height) / 2;
                    } else if (this.labelPos == "top") {
                      this.rect.y -= this.labelHeight - height;
                    }
                    this.setHeight(this.labelHeight);
                  }
                }
              }
            };
            LNode.prototype.getInclusionTreeDepth = function() {
              if (this.inclusionTreeDepth == Integer.MAX_VALUE) {
                throw "assert failed";
              }
              return this.inclusionTreeDepth;
            };
            LNode.prototype.transform = function(trans) {
              var left = this.rect.x;
              if (left > LayoutConstants.WORLD_BOUNDARY) {
                left = LayoutConstants.WORLD_BOUNDARY;
              } else if (left < -LayoutConstants.WORLD_BOUNDARY) {
                left = -LayoutConstants.WORLD_BOUNDARY;
              }
              var top = this.rect.y;
              if (top > LayoutConstants.WORLD_BOUNDARY) {
                top = LayoutConstants.WORLD_BOUNDARY;
              } else if (top < -LayoutConstants.WORLD_BOUNDARY) {
                top = -LayoutConstants.WORLD_BOUNDARY;
              }
              var leftTop = new PointD(left, top);
              var vLeftTop = trans.inverseTransformPoint(leftTop);
              this.setLocation(vLeftTop.x, vLeftTop.y);
            };
            LNode.prototype.getLeft = function() {
              return this.rect.x;
            };
            LNode.prototype.getRight = function() {
              return this.rect.x + this.rect.width;
            };
            LNode.prototype.getTop = function() {
              return this.rect.y;
            };
            LNode.prototype.getBottom = function() {
              return this.rect.y + this.rect.height;
            };
            LNode.prototype.getParent = function() {
              if (this.owner == null) {
                return null;
              }
              return this.owner.getParent();
            };
            module2.exports = LNode;
          },
          /* 4 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            function PointD(x, y) {
              if (x == null && y == null) {
                this.x = 0;
                this.y = 0;
              } else {
                this.x = x;
                this.y = y;
              }
            }
            __name(PointD, "PointD");
            PointD.prototype.getX = function() {
              return this.x;
            };
            PointD.prototype.getY = function() {
              return this.y;
            };
            PointD.prototype.setX = function(x) {
              this.x = x;
            };
            PointD.prototype.setY = function(y) {
              this.y = y;
            };
            PointD.prototype.getDifference = function(pt) {
              return new DimensionD(this.x - pt.x, this.y - pt.y);
            };
            PointD.prototype.getCopy = function() {
              return new PointD(this.x, this.y);
            };
            PointD.prototype.translate = function(dim) {
              this.x += dim.width;
              this.y += dim.height;
              return this;
            };
            module2.exports = PointD;
          },
          /* 5 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var LGraphObject = __webpack_require__(2);
            var Integer = __webpack_require__(10);
            var LayoutConstants = __webpack_require__(0);
            var LGraphManager = __webpack_require__(6);
            var LNode = __webpack_require__(3);
            var LEdge = __webpack_require__(1);
            var RectangleD = __webpack_require__(13);
            var Point2 = __webpack_require__(12);
            var LinkedList = __webpack_require__(11);
            function LGraph(parent, obj2, vGraph) {
              LGraphObject.call(this, vGraph);
              this.estimatedSize = Integer.MIN_VALUE;
              this.margin = LayoutConstants.DEFAULT_GRAPH_MARGIN;
              this.edges = [];
              this.nodes = [];
              this.isConnected = false;
              this.parent = parent;
              if (obj2 != null && obj2 instanceof LGraphManager) {
                this.graphManager = obj2;
              } else if (obj2 != null && obj2 instanceof Layout) {
                this.graphManager = obj2.graphManager;
              }
            }
            __name(LGraph, "LGraph");
            LGraph.prototype = Object.create(LGraphObject.prototype);
            for (var prop in LGraphObject) {
              LGraph[prop] = LGraphObject[prop];
            }
            LGraph.prototype.getNodes = function() {
              return this.nodes;
            };
            LGraph.prototype.getEdges = function() {
              return this.edges;
            };
            LGraph.prototype.getGraphManager = function() {
              return this.graphManager;
            };
            LGraph.prototype.getParent = function() {
              return this.parent;
            };
            LGraph.prototype.getLeft = function() {
              return this.left;
            };
            LGraph.prototype.getRight = function() {
              return this.right;
            };
            LGraph.prototype.getTop = function() {
              return this.top;
            };
            LGraph.prototype.getBottom = function() {
              return this.bottom;
            };
            LGraph.prototype.isConnected = function() {
              return this.isConnected;
            };
            LGraph.prototype.add = function(obj1, sourceNode, targetNode) {
              if (sourceNode == null && targetNode == null) {
                var newNode = obj1;
                if (this.graphManager == null) {
                  throw "Graph has no graph mgr!";
                }
                if (this.getNodes().indexOf(newNode) > -1) {
                  throw "Node already in graph!";
                }
                newNode.owner = this;
                this.getNodes().push(newNode);
                return newNode;
              } else {
                var newEdge = obj1;
                if (!(this.getNodes().indexOf(sourceNode) > -1 && this.getNodes().indexOf(targetNode) > -1)) {
                  throw "Source or target not in graph!";
                }
                if (!(sourceNode.owner == targetNode.owner && sourceNode.owner == this)) {
                  throw "Both owners must be this graph!";
                }
                if (sourceNode.owner != targetNode.owner) {
                  return null;
                }
                newEdge.source = sourceNode;
                newEdge.target = targetNode;
                newEdge.isInterGraph = false;
                this.getEdges().push(newEdge);
                sourceNode.edges.push(newEdge);
                if (targetNode != sourceNode) {
                  targetNode.edges.push(newEdge);
                }
                return newEdge;
              }
            };
            LGraph.prototype.remove = function(obj) {
              var node = obj;
              if (obj instanceof LNode) {
                if (node == null) {
                  throw "Node is null!";
                }
                if (!(node.owner != null && node.owner == this)) {
                  throw "Owner graph is invalid!";
                }
                if (this.graphManager == null) {
                  throw "Owner graph manager is invalid!";
                }
                var edgesToBeRemoved = node.edges.slice();
                var edge;
                var s = edgesToBeRemoved.length;
                for (var i = 0; i < s; i++) {
                  edge = edgesToBeRemoved[i];
                  if (edge.isInterGraph) {
                    this.graphManager.remove(edge);
                  } else {
                    edge.source.owner.remove(edge);
                  }
                }
                var index = this.nodes.indexOf(node);
                if (index == -1) {
                  throw "Node not in owner node list!";
                }
                this.nodes.splice(index, 1);
              } else if (obj instanceof LEdge) {
                var edge = obj;
                if (edge == null) {
                  throw "Edge is null!";
                }
                if (!(edge.source != null && edge.target != null)) {
                  throw "Source and/or target is null!";
                }
                if (!(edge.source.owner != null && edge.target.owner != null && edge.source.owner == this && edge.target.owner == this)) {
                  throw "Source and/or target owner is invalid!";
                }
                var sourceIndex = edge.source.edges.indexOf(edge);
                var targetIndex = edge.target.edges.indexOf(edge);
                if (!(sourceIndex > -1 && targetIndex > -1)) {
                  throw "Source and/or target doesn't know this edge!";
                }
                edge.source.edges.splice(sourceIndex, 1);
                if (edge.target != edge.source) {
                  edge.target.edges.splice(targetIndex, 1);
                }
                var index = edge.source.owner.getEdges().indexOf(edge);
                if (index == -1) {
                  throw "Not in owner's edge list!";
                }
                edge.source.owner.getEdges().splice(index, 1);
              }
            };
            LGraph.prototype.updateLeftTop = function() {
              var top = Integer.MAX_VALUE;
              var left = Integer.MAX_VALUE;
              var nodeTop;
              var nodeLeft;
              var margin;
              var nodes = this.getNodes();
              var s = nodes.length;
              for (var i = 0; i < s; i++) {
                var lNode = nodes[i];
                nodeTop = lNode.getTop();
                nodeLeft = lNode.getLeft();
                if (top > nodeTop) {
                  top = nodeTop;
                }
                if (left > nodeLeft) {
                  left = nodeLeft;
                }
              }
              if (top == Integer.MAX_VALUE) {
                return null;
              }
              if (nodes[0].getParent().paddingLeft != void 0) {
                margin = nodes[0].getParent().paddingLeft;
              } else {
                margin = this.margin;
              }
              this.left = left - margin;
              this.top = top - margin;
              return new Point2(this.left, this.top);
            };
            LGraph.prototype.updateBounds = function(recursive) {
              var left = Integer.MAX_VALUE;
              var right = -Integer.MAX_VALUE;
              var top = Integer.MAX_VALUE;
              var bottom = -Integer.MAX_VALUE;
              var nodeLeft;
              var nodeRight;
              var nodeTop;
              var nodeBottom;
              var margin;
              var nodes = this.nodes;
              var s = nodes.length;
              for (var i = 0; i < s; i++) {
                var lNode = nodes[i];
                if (recursive && lNode.child != null) {
                  lNode.updateBounds();
                }
                nodeLeft = lNode.getLeft();
                nodeRight = lNode.getRight();
                nodeTop = lNode.getTop();
                nodeBottom = lNode.getBottom();
                if (left > nodeLeft) {
                  left = nodeLeft;
                }
                if (right < nodeRight) {
                  right = nodeRight;
                }
                if (top > nodeTop) {
                  top = nodeTop;
                }
                if (bottom < nodeBottom) {
                  bottom = nodeBottom;
                }
              }
              var boundingRect = new RectangleD(left, top, right - left, bottom - top);
              if (left == Integer.MAX_VALUE) {
                this.left = this.parent.getLeft();
                this.right = this.parent.getRight();
                this.top = this.parent.getTop();
                this.bottom = this.parent.getBottom();
              }
              if (nodes[0].getParent().paddingLeft != void 0) {
                margin = nodes[0].getParent().paddingLeft;
              } else {
                margin = this.margin;
              }
              this.left = boundingRect.x - margin;
              this.right = boundingRect.x + boundingRect.width + margin;
              this.top = boundingRect.y - margin;
              this.bottom = boundingRect.y + boundingRect.height + margin;
            };
            LGraph.calculateBounds = function(nodes) {
              var left = Integer.MAX_VALUE;
              var right = -Integer.MAX_VALUE;
              var top = Integer.MAX_VALUE;
              var bottom = -Integer.MAX_VALUE;
              var nodeLeft;
              var nodeRight;
              var nodeTop;
              var nodeBottom;
              var s = nodes.length;
              for (var i = 0; i < s; i++) {
                var lNode = nodes[i];
                nodeLeft = lNode.getLeft();
                nodeRight = lNode.getRight();
                nodeTop = lNode.getTop();
                nodeBottom = lNode.getBottom();
                if (left > nodeLeft) {
                  left = nodeLeft;
                }
                if (right < nodeRight) {
                  right = nodeRight;
                }
                if (top > nodeTop) {
                  top = nodeTop;
                }
                if (bottom < nodeBottom) {
                  bottom = nodeBottom;
                }
              }
              var boundingRect = new RectangleD(left, top, right - left, bottom - top);
              return boundingRect;
            };
            LGraph.prototype.getInclusionTreeDepth = function() {
              if (this == this.graphManager.getRoot()) {
                return 1;
              } else {
                return this.parent.getInclusionTreeDepth();
              }
            };
            LGraph.prototype.getEstimatedSize = function() {
              if (this.estimatedSize == Integer.MIN_VALUE) {
                throw "assert failed";
              }
              return this.estimatedSize;
            };
            LGraph.prototype.calcEstimatedSize = function() {
              var size = 0;
              var nodes = this.nodes;
              var s = nodes.length;
              for (var i = 0; i < s; i++) {
                var lNode = nodes[i];
                size += lNode.calcEstimatedSize();
              }
              if (size == 0) {
                this.estimatedSize = LayoutConstants.EMPTY_COMPOUND_NODE_SIZE;
              } else {
                this.estimatedSize = size / Math.sqrt(this.nodes.length);
              }
              return this.estimatedSize;
            };
            LGraph.prototype.updateConnected = function() {
              var self = this;
              if (this.nodes.length == 0) {
                this.isConnected = true;
                return;
              }
              var queue = new LinkedList();
              var visited = /* @__PURE__ */ new Set();
              var currentNode = this.nodes[0];
              var neighborEdges;
              var currentNeighbor;
              var childrenOfNode = currentNode.withChildren();
              childrenOfNode.forEach(function(node) {
                queue.push(node);
                visited.add(node);
              });
              while (queue.length !== 0) {
                currentNode = queue.shift();
                neighborEdges = currentNode.getEdges();
                var size = neighborEdges.length;
                for (var i = 0; i < size; i++) {
                  var neighborEdge = neighborEdges[i];
                  currentNeighbor = neighborEdge.getOtherEndInGraph(currentNode, this);
                  if (currentNeighbor != null && !visited.has(currentNeighbor)) {
                    var childrenOfNeighbor = currentNeighbor.withChildren();
                    childrenOfNeighbor.forEach(function(node) {
                      queue.push(node);
                      visited.add(node);
                    });
                  }
                }
              }
              this.isConnected = false;
              if (visited.size >= this.nodes.length) {
                var noOfVisitedInThisGraph = 0;
                visited.forEach(function(visitedNode) {
                  if (visitedNode.owner == self) {
                    noOfVisitedInThisGraph++;
                  }
                });
                if (noOfVisitedInThisGraph == this.nodes.length) {
                  this.isConnected = true;
                }
              }
            };
            module2.exports = LGraph;
          },
          /* 6 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var LGraph;
            var LEdge = __webpack_require__(1);
            function LGraphManager(layout) {
              LGraph = __webpack_require__(5);
              this.layout = layout;
              this.graphs = [];
              this.edges = [];
            }
            __name(LGraphManager, "LGraphManager");
            LGraphManager.prototype.addRoot = function() {
              var ngraph = this.layout.newGraph();
              var nnode = this.layout.newNode(null);
              var root = this.add(ngraph, nnode);
              this.setRootGraph(root);
              return this.rootGraph;
            };
            LGraphManager.prototype.add = function(newGraph, parentNode, newEdge, sourceNode, targetNode) {
              if (newEdge == null && sourceNode == null && targetNode == null) {
                if (newGraph == null) {
                  throw "Graph is null!";
                }
                if (parentNode == null) {
                  throw "Parent node is null!";
                }
                if (this.graphs.indexOf(newGraph) > -1) {
                  throw "Graph already in this graph mgr!";
                }
                this.graphs.push(newGraph);
                if (newGraph.parent != null) {
                  throw "Already has a parent!";
                }
                if (parentNode.child != null) {
                  throw "Already has a child!";
                }
                newGraph.parent = parentNode;
                parentNode.child = newGraph;
                return newGraph;
              } else {
                targetNode = newEdge;
                sourceNode = parentNode;
                newEdge = newGraph;
                var sourceGraph = sourceNode.getOwner();
                var targetGraph = targetNode.getOwner();
                if (!(sourceGraph != null && sourceGraph.getGraphManager() == this)) {
                  throw "Source not in this graph mgr!";
                }
                if (!(targetGraph != null && targetGraph.getGraphManager() == this)) {
                  throw "Target not in this graph mgr!";
                }
                if (sourceGraph == targetGraph) {
                  newEdge.isInterGraph = false;
                  return sourceGraph.add(newEdge, sourceNode, targetNode);
                } else {
                  newEdge.isInterGraph = true;
                  newEdge.source = sourceNode;
                  newEdge.target = targetNode;
                  if (this.edges.indexOf(newEdge) > -1) {
                    throw "Edge already in inter-graph edge list!";
                  }
                  this.edges.push(newEdge);
                  if (!(newEdge.source != null && newEdge.target != null)) {
                    throw "Edge source and/or target is null!";
                  }
                  if (!(newEdge.source.edges.indexOf(newEdge) == -1 && newEdge.target.edges.indexOf(newEdge) == -1)) {
                    throw "Edge already in source and/or target incidency list!";
                  }
                  newEdge.source.edges.push(newEdge);
                  newEdge.target.edges.push(newEdge);
                  return newEdge;
                }
              }
            };
            LGraphManager.prototype.remove = function(lObj) {
              if (lObj instanceof LGraph) {
                var graph = lObj;
                if (graph.getGraphManager() != this) {
                  throw "Graph not in this graph mgr";
                }
                if (!(graph == this.rootGraph || graph.parent != null && graph.parent.graphManager == this)) {
                  throw "Invalid parent node!";
                }
                var edgesToBeRemoved = [];
                edgesToBeRemoved = edgesToBeRemoved.concat(graph.getEdges());
                var edge;
                var s = edgesToBeRemoved.length;
                for (var i = 0; i < s; i++) {
                  edge = edgesToBeRemoved[i];
                  graph.remove(edge);
                }
                var nodesToBeRemoved = [];
                nodesToBeRemoved = nodesToBeRemoved.concat(graph.getNodes());
                var node;
                s = nodesToBeRemoved.length;
                for (var i = 0; i < s; i++) {
                  node = nodesToBeRemoved[i];
                  graph.remove(node);
                }
                if (graph == this.rootGraph) {
                  this.setRootGraph(null);
                }
                var index = this.graphs.indexOf(graph);
                this.graphs.splice(index, 1);
                graph.parent = null;
              } else if (lObj instanceof LEdge) {
                edge = lObj;
                if (edge == null) {
                  throw "Edge is null!";
                }
                if (!edge.isInterGraph) {
                  throw "Not an inter-graph edge!";
                }
                if (!(edge.source != null && edge.target != null)) {
                  throw "Source and/or target is null!";
                }
                if (!(edge.source.edges.indexOf(edge) != -1 && edge.target.edges.indexOf(edge) != -1)) {
                  throw "Source and/or target doesn't know this edge!";
                }
                var index = edge.source.edges.indexOf(edge);
                edge.source.edges.splice(index, 1);
                index = edge.target.edges.indexOf(edge);
                edge.target.edges.splice(index, 1);
                if (!(edge.source.owner != null && edge.source.owner.getGraphManager() != null)) {
                  throw "Edge owner graph or owner graph manager is null!";
                }
                if (edge.source.owner.getGraphManager().edges.indexOf(edge) == -1) {
                  throw "Not in owner graph manager's edge list!";
                }
                var index = edge.source.owner.getGraphManager().edges.indexOf(edge);
                edge.source.owner.getGraphManager().edges.splice(index, 1);
              }
            };
            LGraphManager.prototype.updateBounds = function() {
              this.rootGraph.updateBounds(true);
            };
            LGraphManager.prototype.getGraphs = function() {
              return this.graphs;
            };
            LGraphManager.prototype.getAllNodes = function() {
              if (this.allNodes == null) {
                var nodeList = [];
                var graphs = this.getGraphs();
                var s = graphs.length;
                for (var i = 0; i < s; i++) {
                  nodeList = nodeList.concat(graphs[i].getNodes());
                }
                this.allNodes = nodeList;
              }
              return this.allNodes;
            };
            LGraphManager.prototype.resetAllNodes = function() {
              this.allNodes = null;
            };
            LGraphManager.prototype.resetAllEdges = function() {
              this.allEdges = null;
            };
            LGraphManager.prototype.resetAllNodesToApplyGravitation = function() {
              this.allNodesToApplyGravitation = null;
            };
            LGraphManager.prototype.getAllEdges = function() {
              if (this.allEdges == null) {
                var edgeList = [];
                var graphs = this.getGraphs();
                var s = graphs.length;
                for (var i = 0; i < graphs.length; i++) {
                  edgeList = edgeList.concat(graphs[i].getEdges());
                }
                edgeList = edgeList.concat(this.edges);
                this.allEdges = edgeList;
              }
              return this.allEdges;
            };
            LGraphManager.prototype.getAllNodesToApplyGravitation = function() {
              return this.allNodesToApplyGravitation;
            };
            LGraphManager.prototype.setAllNodesToApplyGravitation = function(nodeList) {
              if (this.allNodesToApplyGravitation != null) {
                throw "assert failed";
              }
              this.allNodesToApplyGravitation = nodeList;
            };
            LGraphManager.prototype.getRoot = function() {
              return this.rootGraph;
            };
            LGraphManager.prototype.setRootGraph = function(graph) {
              if (graph.getGraphManager() != this) {
                throw "Root not in this graph mgr!";
              }
              this.rootGraph = graph;
              if (graph.parent == null) {
                graph.parent = this.layout.newNode("Root node");
              }
            };
            LGraphManager.prototype.getLayout = function() {
              return this.layout;
            };
            LGraphManager.prototype.isOneAncestorOfOther = function(firstNode, secondNode) {
              if (!(firstNode != null && secondNode != null)) {
                throw "assert failed";
              }
              if (firstNode == secondNode) {
                return true;
              }
              var ownerGraph = firstNode.getOwner();
              var parentNode;
              do {
                parentNode = ownerGraph.getParent();
                if (parentNode == null) {
                  break;
                }
                if (parentNode == secondNode) {
                  return true;
                }
                ownerGraph = parentNode.getOwner();
                if (ownerGraph == null) {
                  break;
                }
              } while (true);
              ownerGraph = secondNode.getOwner();
              do {
                parentNode = ownerGraph.getParent();
                if (parentNode == null) {
                  break;
                }
                if (parentNode == firstNode) {
                  return true;
                }
                ownerGraph = parentNode.getOwner();
                if (ownerGraph == null) {
                  break;
                }
              } while (true);
              return false;
            };
            LGraphManager.prototype.calcLowestCommonAncestors = function() {
              var edge;
              var sourceNode;
              var targetNode;
              var sourceAncestorGraph;
              var targetAncestorGraph;
              var edges = this.getAllEdges();
              var s = edges.length;
              for (var i = 0; i < s; i++) {
                edge = edges[i];
                sourceNode = edge.source;
                targetNode = edge.target;
                edge.lca = null;
                edge.sourceInLca = sourceNode;
                edge.targetInLca = targetNode;
                if (sourceNode == targetNode) {
                  edge.lca = sourceNode.getOwner();
                  continue;
                }
                sourceAncestorGraph = sourceNode.getOwner();
                while (edge.lca == null) {
                  edge.targetInLca = targetNode;
                  targetAncestorGraph = targetNode.getOwner();
                  while (edge.lca == null) {
                    if (targetAncestorGraph == sourceAncestorGraph) {
                      edge.lca = targetAncestorGraph;
                      break;
                    }
                    if (targetAncestorGraph == this.rootGraph) {
                      break;
                    }
                    if (edge.lca != null) {
                      throw "assert failed";
                    }
                    edge.targetInLca = targetAncestorGraph.getParent();
                    targetAncestorGraph = edge.targetInLca.getOwner();
                  }
                  if (sourceAncestorGraph == this.rootGraph) {
                    break;
                  }
                  if (edge.lca == null) {
                    edge.sourceInLca = sourceAncestorGraph.getParent();
                    sourceAncestorGraph = edge.sourceInLca.getOwner();
                  }
                }
                if (edge.lca == null) {
                  throw "assert failed";
                }
              }
            };
            LGraphManager.prototype.calcLowestCommonAncestor = function(firstNode, secondNode) {
              if (firstNode == secondNode) {
                return firstNode.getOwner();
              }
              var firstOwnerGraph = firstNode.getOwner();
              do {
                if (firstOwnerGraph == null) {
                  break;
                }
                var secondOwnerGraph = secondNode.getOwner();
                do {
                  if (secondOwnerGraph == null) {
                    break;
                  }
                  if (secondOwnerGraph == firstOwnerGraph) {
                    return secondOwnerGraph;
                  }
                  secondOwnerGraph = secondOwnerGraph.getParent().getOwner();
                } while (true);
                firstOwnerGraph = firstOwnerGraph.getParent().getOwner();
              } while (true);
              return firstOwnerGraph;
            };
            LGraphManager.prototype.calcInclusionTreeDepths = function(graph, depth) {
              if (graph == null && depth == null) {
                graph = this.rootGraph;
                depth = 1;
              }
              var node;
              var nodes = graph.getNodes();
              var s = nodes.length;
              for (var i = 0; i < s; i++) {
                node = nodes[i];
                node.inclusionTreeDepth = depth;
                if (node.child != null) {
                  this.calcInclusionTreeDepths(node.child, depth + 1);
                }
              }
            };
            LGraphManager.prototype.includesInvalidEdge = function() {
              var edge;
              var s = this.edges.length;
              for (var i = 0; i < s; i++) {
                edge = this.edges[i];
                if (this.isOneAncestorOfOther(edge.source, edge.target)) {
                  return true;
                }
              }
              return false;
            };
            module2.exports = LGraphManager;
          },
          /* 7 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var LayoutConstants = __webpack_require__(0);
            function FDLayoutConstants() {
            }
            __name(FDLayoutConstants, "FDLayoutConstants");
            for (var prop in LayoutConstants) {
              FDLayoutConstants[prop] = LayoutConstants[prop];
            }
            FDLayoutConstants.MAX_ITERATIONS = 2500;
            FDLayoutConstants.DEFAULT_EDGE_LENGTH = 50;
            FDLayoutConstants.DEFAULT_SPRING_STRENGTH = 0.45;
            FDLayoutConstants.DEFAULT_REPULSION_STRENGTH = 4500;
            FDLayoutConstants.DEFAULT_GRAVITY_STRENGTH = 0.4;
            FDLayoutConstants.DEFAULT_COMPOUND_GRAVITY_STRENGTH = 1;
            FDLayoutConstants.DEFAULT_GRAVITY_RANGE_FACTOR = 3.8;
            FDLayoutConstants.DEFAULT_COMPOUND_GRAVITY_RANGE_FACTOR = 1.5;
            FDLayoutConstants.DEFAULT_USE_SMART_IDEAL_EDGE_LENGTH_CALCULATION = true;
            FDLayoutConstants.DEFAULT_USE_SMART_REPULSION_RANGE_CALCULATION = true;
            FDLayoutConstants.DEFAULT_COOLING_FACTOR_INCREMENTAL = 0.3;
            FDLayoutConstants.COOLING_ADAPTATION_FACTOR = 0.33;
            FDLayoutConstants.ADAPTATION_LOWER_NODE_LIMIT = 1e3;
            FDLayoutConstants.ADAPTATION_UPPER_NODE_LIMIT = 5e3;
            FDLayoutConstants.MAX_NODE_DISPLACEMENT_INCREMENTAL = 100;
            FDLayoutConstants.MAX_NODE_DISPLACEMENT = FDLayoutConstants.MAX_NODE_DISPLACEMENT_INCREMENTAL * 3;
            FDLayoutConstants.MIN_REPULSION_DIST = FDLayoutConstants.DEFAULT_EDGE_LENGTH / 10;
            FDLayoutConstants.CONVERGENCE_CHECK_PERIOD = 100;
            FDLayoutConstants.PER_LEVEL_IDEAL_EDGE_LENGTH_FACTOR = 0.1;
            FDLayoutConstants.MIN_EDGE_LENGTH = 1;
            FDLayoutConstants.GRID_CALCULATION_CHECK_PERIOD = 10;
            module2.exports = FDLayoutConstants;
          },
          /* 8 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var Point2 = __webpack_require__(12);
            function IGeometry() {
            }
            __name(IGeometry, "IGeometry");
            IGeometry.calcSeparationAmount = function(rectA, rectB, overlapAmount, separationBuffer) {
              if (!rectA.intersects(rectB)) {
                throw "assert failed";
              }
              var directions = new Array(2);
              this.decideDirectionsForOverlappingNodes(rectA, rectB, directions);
              overlapAmount[0] = Math.min(rectA.getRight(), rectB.getRight()) - Math.max(rectA.x, rectB.x);
              overlapAmount[1] = Math.min(rectA.getBottom(), rectB.getBottom()) - Math.max(rectA.y, rectB.y);
              if (rectA.getX() <= rectB.getX() && rectA.getRight() >= rectB.getRight()) {
                overlapAmount[0] += Math.min(rectB.getX() - rectA.getX(), rectA.getRight() - rectB.getRight());
              } else if (rectB.getX() <= rectA.getX() && rectB.getRight() >= rectA.getRight()) {
                overlapAmount[0] += Math.min(rectA.getX() - rectB.getX(), rectB.getRight() - rectA.getRight());
              }
              if (rectA.getY() <= rectB.getY() && rectA.getBottom() >= rectB.getBottom()) {
                overlapAmount[1] += Math.min(rectB.getY() - rectA.getY(), rectA.getBottom() - rectB.getBottom());
              } else if (rectB.getY() <= rectA.getY() && rectB.getBottom() >= rectA.getBottom()) {
                overlapAmount[1] += Math.min(rectA.getY() - rectB.getY(), rectB.getBottom() - rectA.getBottom());
              }
              var slope = Math.abs((rectB.getCenterY() - rectA.getCenterY()) / (rectB.getCenterX() - rectA.getCenterX()));
              if (rectB.getCenterY() === rectA.getCenterY() && rectB.getCenterX() === rectA.getCenterX()) {
                slope = 1;
              }
              var moveByY = slope * overlapAmount[0];
              var moveByX = overlapAmount[1] / slope;
              if (overlapAmount[0] < moveByX) {
                moveByX = overlapAmount[0];
              } else {
                moveByY = overlapAmount[1];
              }
              overlapAmount[0] = -1 * directions[0] * (moveByX / 2 + separationBuffer);
              overlapAmount[1] = -1 * directions[1] * (moveByY / 2 + separationBuffer);
            };
            IGeometry.decideDirectionsForOverlappingNodes = function(rectA, rectB, directions) {
              if (rectA.getCenterX() < rectB.getCenterX()) {
                directions[0] = -1;
              } else {
                directions[0] = 1;
              }
              if (rectA.getCenterY() < rectB.getCenterY()) {
                directions[1] = -1;
              } else {
                directions[1] = 1;
              }
            };
            IGeometry.getIntersection2 = function(rectA, rectB, result) {
              var p1x = rectA.getCenterX();
              var p1y = rectA.getCenterY();
              var p2x = rectB.getCenterX();
              var p2y = rectB.getCenterY();
              if (rectA.intersects(rectB)) {
                result[0] = p1x;
                result[1] = p1y;
                result[2] = p2x;
                result[3] = p2y;
                return true;
              }
              var topLeftAx = rectA.getX();
              var topLeftAy = rectA.getY();
              var topRightAx = rectA.getRight();
              var bottomLeftAx = rectA.getX();
              var bottomLeftAy = rectA.getBottom();
              var bottomRightAx = rectA.getRight();
              var halfWidthA = rectA.getWidthHalf();
              var halfHeightA = rectA.getHeightHalf();
              var topLeftBx = rectB.getX();
              var topLeftBy = rectB.getY();
              var topRightBx = rectB.getRight();
              var bottomLeftBx = rectB.getX();
              var bottomLeftBy = rectB.getBottom();
              var bottomRightBx = rectB.getRight();
              var halfWidthB = rectB.getWidthHalf();
              var halfHeightB = rectB.getHeightHalf();
              var clipPointAFound = false;
              var clipPointBFound = false;
              if (p1x === p2x) {
                if (p1y > p2y) {
                  result[0] = p1x;
                  result[1] = topLeftAy;
                  result[2] = p2x;
                  result[3] = bottomLeftBy;
                  return false;
                } else if (p1y < p2y) {
                  result[0] = p1x;
                  result[1] = bottomLeftAy;
                  result[2] = p2x;
                  result[3] = topLeftBy;
                  return false;
                } else {
                }
              } else if (p1y === p2y) {
                if (p1x > p2x) {
                  result[0] = topLeftAx;
                  result[1] = p1y;
                  result[2] = topRightBx;
                  result[3] = p2y;
                  return false;
                } else if (p1x < p2x) {
                  result[0] = topRightAx;
                  result[1] = p1y;
                  result[2] = topLeftBx;
                  result[3] = p2y;
                  return false;
                } else {
                }
              } else {
                var slopeA = rectA.height / rectA.width;
                var slopeB = rectB.height / rectB.width;
                var slopePrime = (p2y - p1y) / (p2x - p1x);
                var cardinalDirectionA = void 0;
                var cardinalDirectionB = void 0;
                var tempPointAx = void 0;
                var tempPointAy = void 0;
                var tempPointBx = void 0;
                var tempPointBy = void 0;
                if (-slopeA === slopePrime) {
                  if (p1x > p2x) {
                    result[0] = bottomLeftAx;
                    result[1] = bottomLeftAy;
                    clipPointAFound = true;
                  } else {
                    result[0] = topRightAx;
                    result[1] = topLeftAy;
                    clipPointAFound = true;
                  }
                } else if (slopeA === slopePrime) {
                  if (p1x > p2x) {
                    result[0] = topLeftAx;
                    result[1] = topLeftAy;
                    clipPointAFound = true;
                  } else {
                    result[0] = bottomRightAx;
                    result[1] = bottomLeftAy;
                    clipPointAFound = true;
                  }
                }
                if (-slopeB === slopePrime) {
                  if (p2x > p1x) {
                    result[2] = bottomLeftBx;
                    result[3] = bottomLeftBy;
                    clipPointBFound = true;
                  } else {
                    result[2] = topRightBx;
                    result[3] = topLeftBy;
                    clipPointBFound = true;
                  }
                } else if (slopeB === slopePrime) {
                  if (p2x > p1x) {
                    result[2] = topLeftBx;
                    result[3] = topLeftBy;
                    clipPointBFound = true;
                  } else {
                    result[2] = bottomRightBx;
                    result[3] = bottomLeftBy;
                    clipPointBFound = true;
                  }
                }
                if (clipPointAFound && clipPointBFound) {
                  return false;
                }
                if (p1x > p2x) {
                  if (p1y > p2y) {
                    cardinalDirectionA = this.getCardinalDirection(slopeA, slopePrime, 4);
                    cardinalDirectionB = this.getCardinalDirection(slopeB, slopePrime, 2);
                  } else {
                    cardinalDirectionA = this.getCardinalDirection(-slopeA, slopePrime, 3);
                    cardinalDirectionB = this.getCardinalDirection(-slopeB, slopePrime, 1);
                  }
                } else {
                  if (p1y > p2y) {
                    cardinalDirectionA = this.getCardinalDirection(-slopeA, slopePrime, 1);
                    cardinalDirectionB = this.getCardinalDirection(-slopeB, slopePrime, 3);
                  } else {
                    cardinalDirectionA = this.getCardinalDirection(slopeA, slopePrime, 2);
                    cardinalDirectionB = this.getCardinalDirection(slopeB, slopePrime, 4);
                  }
                }
                if (!clipPointAFound) {
                  switch (cardinalDirectionA) {
                    case 1:
                      tempPointAy = topLeftAy;
                      tempPointAx = p1x + -halfHeightA / slopePrime;
                      result[0] = tempPointAx;
                      result[1] = tempPointAy;
                      break;
                    case 2:
                      tempPointAx = bottomRightAx;
                      tempPointAy = p1y + halfWidthA * slopePrime;
                      result[0] = tempPointAx;
                      result[1] = tempPointAy;
                      break;
                    case 3:
                      tempPointAy = bottomLeftAy;
                      tempPointAx = p1x + halfHeightA / slopePrime;
                      result[0] = tempPointAx;
                      result[1] = tempPointAy;
                      break;
                    case 4:
                      tempPointAx = bottomLeftAx;
                      tempPointAy = p1y + -halfWidthA * slopePrime;
                      result[0] = tempPointAx;
                      result[1] = tempPointAy;
                      break;
                  }
                }
                if (!clipPointBFound) {
                  switch (cardinalDirectionB) {
                    case 1:
                      tempPointBy = topLeftBy;
                      tempPointBx = p2x + -halfHeightB / slopePrime;
                      result[2] = tempPointBx;
                      result[3] = tempPointBy;
                      break;
                    case 2:
                      tempPointBx = bottomRightBx;
                      tempPointBy = p2y + halfWidthB * slopePrime;
                      result[2] = tempPointBx;
                      result[3] = tempPointBy;
                      break;
                    case 3:
                      tempPointBy = bottomLeftBy;
                      tempPointBx = p2x + halfHeightB / slopePrime;
                      result[2] = tempPointBx;
                      result[3] = tempPointBy;
                      break;
                    case 4:
                      tempPointBx = bottomLeftBx;
                      tempPointBy = p2y + -halfWidthB * slopePrime;
                      result[2] = tempPointBx;
                      result[3] = tempPointBy;
                      break;
                  }
                }
              }
              return false;
            };
            IGeometry.getCardinalDirection = function(slope, slopePrime, line) {
              if (slope > slopePrime) {
                return line;
              } else {
                return 1 + line % 4;
              }
            };
            IGeometry.getIntersection = function(s1, s2, f1, f2) {
              if (f2 == null) {
                return this.getIntersection2(s1, s2, f1);
              }
              var x1 = s1.x;
              var y1 = s1.y;
              var x2 = s2.x;
              var y2 = s2.y;
              var x3 = f1.x;
              var y3 = f1.y;
              var x4 = f2.x;
              var y4 = f2.y;
              var x = void 0, y = void 0;
              var a1 = void 0, a2 = void 0, b1 = void 0, b2 = void 0, c1 = void 0, c2 = void 0;
              var denom = void 0;
              a1 = y2 - y1;
              b1 = x1 - x2;
              c1 = x2 * y1 - x1 * y2;
              a2 = y4 - y3;
              b2 = x3 - x4;
              c2 = x4 * y3 - x3 * y4;
              denom = a1 * b2 - a2 * b1;
              if (denom === 0) {
                return null;
              }
              x = (b1 * c2 - b2 * c1) / denom;
              y = (a2 * c1 - a1 * c2) / denom;
              return new Point2(x, y);
            };
            IGeometry.angleOfVector = function(Cx, Cy, Nx, Ny) {
              var C_angle = void 0;
              if (Cx !== Nx) {
                C_angle = Math.atan((Ny - Cy) / (Nx - Cx));
                if (Nx < Cx) {
                  C_angle += Math.PI;
                } else if (Ny < Cy) {
                  C_angle += this.TWO_PI;
                }
              } else if (Ny < Cy) {
                C_angle = this.ONE_AND_HALF_PI;
              } else {
                C_angle = this.HALF_PI;
              }
              return C_angle;
            };
            IGeometry.doIntersect = function(p1, p2, p3, p4) {
              var a = p1.x;
              var b = p1.y;
              var c = p2.x;
              var d = p2.y;
              var p = p3.x;
              var q = p3.y;
              var r = p4.x;
              var s = p4.y;
              var det = (c - a) * (s - q) - (r - p) * (d - b);
              if (det === 0) {
                return false;
              } else {
                var lambda = ((s - q) * (r - a) + (p - r) * (s - b)) / det;
                var gamma = ((b - d) * (r - a) + (c - a) * (s - b)) / det;
                return 0 < lambda && lambda < 1 && 0 < gamma && gamma < 1;
              }
            };
            IGeometry.HALF_PI = 0.5 * Math.PI;
            IGeometry.ONE_AND_HALF_PI = 1.5 * Math.PI;
            IGeometry.TWO_PI = 2 * Math.PI;
            IGeometry.THREE_PI = 3 * Math.PI;
            module2.exports = IGeometry;
          },
          /* 9 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            function IMath() {
            }
            __name(IMath, "IMath");
            IMath.sign = function(value) {
              if (value > 0) {
                return 1;
              } else if (value < 0) {
                return -1;
              } else {
                return 0;
              }
            };
            IMath.floor = function(value) {
              return value < 0 ? Math.ceil(value) : Math.floor(value);
            };
            IMath.ceil = function(value) {
              return value < 0 ? Math.floor(value) : Math.ceil(value);
            };
            module2.exports = IMath;
          },
          /* 10 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            function Integer() {
            }
            __name(Integer, "Integer");
            Integer.MAX_VALUE = 2147483647;
            Integer.MIN_VALUE = -2147483648;
            module2.exports = Integer;
          },
          /* 11 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var _createClass = /* @__PURE__ */ function() {
              function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                  var descriptor = props[i];
                  descriptor.enumerable = descriptor.enumerable || false;
                  descriptor.configurable = true;
                  if ("value" in descriptor) descriptor.writable = true;
                  Object.defineProperty(target, descriptor.key, descriptor);
                }
              }
              __name(defineProperties, "defineProperties");
              return function(Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
              };
            }();
            function _classCallCheck(instance2, Constructor) {
              if (!(instance2 instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
              }
            }
            __name(_classCallCheck, "_classCallCheck");
            var nodeFrom = /* @__PURE__ */ __name(function nodeFrom2(value) {
              return { value, next: null, prev: null };
            }, "nodeFrom");
            var add = /* @__PURE__ */ __name(function add2(prev, node, next2, list) {
              if (prev !== null) {
                prev.next = node;
              } else {
                list.head = node;
              }
              if (next2 !== null) {
                next2.prev = node;
              } else {
                list.tail = node;
              }
              node.prev = prev;
              node.next = next2;
              list.length++;
              return node;
            }, "add");
            var _remove = /* @__PURE__ */ __name(function _remove2(node, list) {
              var prev = node.prev, next2 = node.next;
              if (prev !== null) {
                prev.next = next2;
              } else {
                list.head = next2;
              }
              if (next2 !== null) {
                next2.prev = prev;
              } else {
                list.tail = prev;
              }
              node.prev = node.next = null;
              list.length--;
              return node;
            }, "_remove");
            var LinkedList = function() {
              function LinkedList2(vals) {
                var _this = this;
                _classCallCheck(this, LinkedList2);
                this.length = 0;
                this.head = null;
                this.tail = null;
                if (vals != null) {
                  vals.forEach(function(v) {
                    return _this.push(v);
                  });
                }
              }
              __name(LinkedList2, "LinkedList");
              _createClass(LinkedList2, [{
                key: "size",
                value: /* @__PURE__ */ __name(function size() {
                  return this.length;
                }, "size")
              }, {
                key: "insertBefore",
                value: /* @__PURE__ */ __name(function insertBefore(val, otherNode) {
                  return add(otherNode.prev, nodeFrom(val), otherNode, this);
                }, "insertBefore")
              }, {
                key: "insertAfter",
                value: /* @__PURE__ */ __name(function insertAfter(val, otherNode) {
                  return add(otherNode, nodeFrom(val), otherNode.next, this);
                }, "insertAfter")
              }, {
                key: "insertNodeBefore",
                value: /* @__PURE__ */ __name(function insertNodeBefore(newNode, otherNode) {
                  return add(otherNode.prev, newNode, otherNode, this);
                }, "insertNodeBefore")
              }, {
                key: "insertNodeAfter",
                value: /* @__PURE__ */ __name(function insertNodeAfter(newNode, otherNode) {
                  return add(otherNode, newNode, otherNode.next, this);
                }, "insertNodeAfter")
              }, {
                key: "push",
                value: /* @__PURE__ */ __name(function push(val) {
                  return add(this.tail, nodeFrom(val), null, this);
                }, "push")
              }, {
                key: "unshift",
                value: /* @__PURE__ */ __name(function unshift(val) {
                  return add(null, nodeFrom(val), this.head, this);
                }, "unshift")
              }, {
                key: "remove",
                value: /* @__PURE__ */ __name(function remove(node) {
                  return _remove(node, this);
                }, "remove")
              }, {
                key: "pop",
                value: /* @__PURE__ */ __name(function pop() {
                  return _remove(this.tail, this).value;
                }, "pop")
              }, {
                key: "popNode",
                value: /* @__PURE__ */ __name(function popNode() {
                  return _remove(this.tail, this);
                }, "popNode")
              }, {
                key: "shift",
                value: /* @__PURE__ */ __name(function shift() {
                  return _remove(this.head, this).value;
                }, "shift")
              }, {
                key: "shiftNode",
                value: /* @__PURE__ */ __name(function shiftNode() {
                  return _remove(this.head, this);
                }, "shiftNode")
              }, {
                key: "get_object_at",
                value: /* @__PURE__ */ __name(function get_object_at(index) {
                  if (index <= this.length()) {
                    var i = 1;
                    var current = this.head;
                    while (i < index) {
                      current = current.next;
                      i++;
                    }
                    return current.value;
                  }
                }, "get_object_at")
              }, {
                key: "set_object_at",
                value: /* @__PURE__ */ __name(function set_object_at(index, value) {
                  if (index <= this.length()) {
                    var i = 1;
                    var current = this.head;
                    while (i < index) {
                      current = current.next;
                      i++;
                    }
                    current.value = value;
                  }
                }, "set_object_at")
              }]);
              return LinkedList2;
            }();
            module2.exports = LinkedList;
          },
          /* 12 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            function Point2(x, y, p) {
              this.x = null;
              this.y = null;
              if (x == null && y == null && p == null) {
                this.x = 0;
                this.y = 0;
              } else if (typeof x == "number" && typeof y == "number" && p == null) {
                this.x = x;
                this.y = y;
              } else if (x.constructor.name == "Point" && y == null && p == null) {
                p = x;
                this.x = p.x;
                this.y = p.y;
              }
            }
            __name(Point2, "Point");
            Point2.prototype.getX = function() {
              return this.x;
            };
            Point2.prototype.getY = function() {
              return this.y;
            };
            Point2.prototype.getLocation = function() {
              return new Point2(this.x, this.y);
            };
            Point2.prototype.setLocation = function(x, y, p) {
              if (x.constructor.name == "Point" && y == null && p == null) {
                p = x;
                this.setLocation(p.x, p.y);
              } else if (typeof x == "number" && typeof y == "number" && p == null) {
                if (parseInt(x) == x && parseInt(y) == y) {
                  this.move(x, y);
                } else {
                  this.x = Math.floor(x + 0.5);
                  this.y = Math.floor(y + 0.5);
                }
              }
            };
            Point2.prototype.move = function(x, y) {
              this.x = x;
              this.y = y;
            };
            Point2.prototype.translate = function(dx, dy) {
              this.x += dx;
              this.y += dy;
            };
            Point2.prototype.equals = function(obj) {
              if (obj.constructor.name == "Point") {
                var pt = obj;
                return this.x == pt.x && this.y == pt.y;
              }
              return this == obj;
            };
            Point2.prototype.toString = function() {
              return new Point2().constructor.name + "[x=" + this.x + ",y=" + this.y + "]";
            };
            module2.exports = Point2;
          },
          /* 13 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            function RectangleD(x, y, width, height) {
              this.x = 0;
              this.y = 0;
              this.width = 0;
              this.height = 0;
              if (x != null && y != null && width != null && height != null) {
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
              }
            }
            __name(RectangleD, "RectangleD");
            RectangleD.prototype.getX = function() {
              return this.x;
            };
            RectangleD.prototype.setX = function(x) {
              this.x = x;
            };
            RectangleD.prototype.getY = function() {
              return this.y;
            };
            RectangleD.prototype.setY = function(y) {
              this.y = y;
            };
            RectangleD.prototype.getWidth = function() {
              return this.width;
            };
            RectangleD.prototype.setWidth = function(width) {
              this.width = width;
            };
            RectangleD.prototype.getHeight = function() {
              return this.height;
            };
            RectangleD.prototype.setHeight = function(height) {
              this.height = height;
            };
            RectangleD.prototype.getRight = function() {
              return this.x + this.width;
            };
            RectangleD.prototype.getBottom = function() {
              return this.y + this.height;
            };
            RectangleD.prototype.intersects = function(a) {
              if (this.getRight() < a.x) {
                return false;
              }
              if (this.getBottom() < a.y) {
                return false;
              }
              if (a.getRight() < this.x) {
                return false;
              }
              if (a.getBottom() < this.y) {
                return false;
              }
              return true;
            };
            RectangleD.prototype.getCenterX = function() {
              return this.x + this.width / 2;
            };
            RectangleD.prototype.getMinX = function() {
              return this.getX();
            };
            RectangleD.prototype.getMaxX = function() {
              return this.getX() + this.width;
            };
            RectangleD.prototype.getCenterY = function() {
              return this.y + this.height / 2;
            };
            RectangleD.prototype.getMinY = function() {
              return this.getY();
            };
            RectangleD.prototype.getMaxY = function() {
              return this.getY() + this.height;
            };
            RectangleD.prototype.getWidthHalf = function() {
              return this.width / 2;
            };
            RectangleD.prototype.getHeightHalf = function() {
              return this.height / 2;
            };
            module2.exports = RectangleD;
          },
          /* 14 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function(obj) {
              return typeof obj;
            } : function(obj) {
              return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
            };
            function UniqueIDGeneretor() {
            }
            __name(UniqueIDGeneretor, "UniqueIDGeneretor");
            UniqueIDGeneretor.lastID = 0;
            UniqueIDGeneretor.createID = function(obj) {
              if (UniqueIDGeneretor.isPrimitive(obj)) {
                return obj;
              }
              if (obj.uniqueID != null) {
                return obj.uniqueID;
              }
              obj.uniqueID = UniqueIDGeneretor.getString();
              UniqueIDGeneretor.lastID++;
              return obj.uniqueID;
            };
            UniqueIDGeneretor.getString = function(id) {
              if (id == null) id = UniqueIDGeneretor.lastID;
              return "Object#" + id;
            };
            UniqueIDGeneretor.isPrimitive = function(arg) {
              var type = typeof arg === "undefined" ? "undefined" : _typeof(arg);
              return arg == null || type != "object" && type != "function";
            };
            module2.exports = UniqueIDGeneretor;
          },
          /* 15 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            function _toConsumableArray(arr) {
              if (Array.isArray(arr)) {
                for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                  arr2[i] = arr[i];
                }
                return arr2;
              } else {
                return Array.from(arr);
              }
            }
            __name(_toConsumableArray, "_toConsumableArray");
            var LayoutConstants = __webpack_require__(0);
            var LGraphManager = __webpack_require__(6);
            var LNode = __webpack_require__(3);
            var LEdge = __webpack_require__(1);
            var LGraph = __webpack_require__(5);
            var PointD = __webpack_require__(4);
            var Transform = __webpack_require__(17);
            var Emitter = __webpack_require__(27);
            function Layout2(isRemoteUse) {
              Emitter.call(this);
              this.layoutQuality = LayoutConstants.QUALITY;
              this.createBendsAsNeeded = LayoutConstants.DEFAULT_CREATE_BENDS_AS_NEEDED;
              this.incremental = LayoutConstants.DEFAULT_INCREMENTAL;
              this.animationOnLayout = LayoutConstants.DEFAULT_ANIMATION_ON_LAYOUT;
              this.animationDuringLayout = LayoutConstants.DEFAULT_ANIMATION_DURING_LAYOUT;
              this.animationPeriod = LayoutConstants.DEFAULT_ANIMATION_PERIOD;
              this.uniformLeafNodeSizes = LayoutConstants.DEFAULT_UNIFORM_LEAF_NODE_SIZES;
              this.edgeToDummyNodes = /* @__PURE__ */ new Map();
              this.graphManager = new LGraphManager(this);
              this.isLayoutFinished = false;
              this.isSubLayout = false;
              this.isRemoteUse = false;
              if (isRemoteUse != null) {
                this.isRemoteUse = isRemoteUse;
              }
            }
            __name(Layout2, "Layout");
            Layout2.RANDOM_SEED = 1;
            Layout2.prototype = Object.create(Emitter.prototype);
            Layout2.prototype.getGraphManager = function() {
              return this.graphManager;
            };
            Layout2.prototype.getAllNodes = function() {
              return this.graphManager.getAllNodes();
            };
            Layout2.prototype.getAllEdges = function() {
              return this.graphManager.getAllEdges();
            };
            Layout2.prototype.getAllNodesToApplyGravitation = function() {
              return this.graphManager.getAllNodesToApplyGravitation();
            };
            Layout2.prototype.newGraphManager = function() {
              var gm = new LGraphManager(this);
              this.graphManager = gm;
              return gm;
            };
            Layout2.prototype.newGraph = function(vGraph) {
              return new LGraph(null, this.graphManager, vGraph);
            };
            Layout2.prototype.newNode = function(vNode) {
              return new LNode(this.graphManager, vNode);
            };
            Layout2.prototype.newEdge = function(vEdge) {
              return new LEdge(null, null, vEdge);
            };
            Layout2.prototype.checkLayoutSuccess = function() {
              return this.graphManager.getRoot() == null || this.graphManager.getRoot().getNodes().length == 0 || this.graphManager.includesInvalidEdge();
            };
            Layout2.prototype.runLayout = function() {
              this.isLayoutFinished = false;
              if (this.tilingPreLayout) {
                this.tilingPreLayout();
              }
              this.initParameters();
              var isLayoutSuccessfull;
              if (this.checkLayoutSuccess()) {
                isLayoutSuccessfull = false;
              } else {
                isLayoutSuccessfull = this.layout();
              }
              if (LayoutConstants.ANIMATE === "during") {
                return false;
              }
              if (isLayoutSuccessfull) {
                if (!this.isSubLayout) {
                  this.doPostLayout();
                }
              }
              if (this.tilingPostLayout) {
                this.tilingPostLayout();
              }
              this.isLayoutFinished = true;
              return isLayoutSuccessfull;
            };
            Layout2.prototype.doPostLayout = function() {
              if (!this.incremental) {
                this.transform();
              }
              this.update();
            };
            Layout2.prototype.update2 = function() {
              if (this.createBendsAsNeeded) {
                this.createBendpointsFromDummyNodes();
                this.graphManager.resetAllEdges();
              }
              if (!this.isRemoteUse) {
                var edge;
                var allEdges = this.graphManager.getAllEdges();
                for (var i = 0; i < allEdges.length; i++) {
                  edge = allEdges[i];
                }
                var node;
                var nodes = this.graphManager.getRoot().getNodes();
                for (var i = 0; i < nodes.length; i++) {
                  node = nodes[i];
                }
                this.update(this.graphManager.getRoot());
              }
            };
            Layout2.prototype.update = function(obj) {
              if (obj == null) {
                this.update2();
              } else if (obj instanceof LNode) {
                var node = obj;
                if (node.getChild() != null) {
                  var nodes = node.getChild().getNodes();
                  for (var i = 0; i < nodes.length; i++) {
                    update(nodes[i]);
                  }
                }
                if (node.vGraphObject != null) {
                  var vNode = node.vGraphObject;
                  vNode.update(node);
                }
              } else if (obj instanceof LEdge) {
                var edge = obj;
                if (edge.vGraphObject != null) {
                  var vEdge = edge.vGraphObject;
                  vEdge.update(edge);
                }
              } else if (obj instanceof LGraph) {
                var graph = obj;
                if (graph.vGraphObject != null) {
                  var vGraph = graph.vGraphObject;
                  vGraph.update(graph);
                }
              }
            };
            Layout2.prototype.initParameters = function() {
              if (!this.isSubLayout) {
                this.layoutQuality = LayoutConstants.QUALITY;
                this.animationDuringLayout = LayoutConstants.DEFAULT_ANIMATION_DURING_LAYOUT;
                this.animationPeriod = LayoutConstants.DEFAULT_ANIMATION_PERIOD;
                this.animationOnLayout = LayoutConstants.DEFAULT_ANIMATION_ON_LAYOUT;
                this.incremental = LayoutConstants.DEFAULT_INCREMENTAL;
                this.createBendsAsNeeded = LayoutConstants.DEFAULT_CREATE_BENDS_AS_NEEDED;
                this.uniformLeafNodeSizes = LayoutConstants.DEFAULT_UNIFORM_LEAF_NODE_SIZES;
              }
              if (this.animationDuringLayout) {
                this.animationOnLayout = false;
              }
            };
            Layout2.prototype.transform = function(newLeftTop) {
              if (newLeftTop == void 0) {
                this.transform(new PointD(0, 0));
              } else {
                var trans = new Transform();
                var leftTop = this.graphManager.getRoot().updateLeftTop();
                if (leftTop != null) {
                  trans.setWorldOrgX(newLeftTop.x);
                  trans.setWorldOrgY(newLeftTop.y);
                  trans.setDeviceOrgX(leftTop.x);
                  trans.setDeviceOrgY(leftTop.y);
                  var nodes = this.getAllNodes();
                  var node;
                  for (var i = 0; i < nodes.length; i++) {
                    node = nodes[i];
                    node.transform(trans);
                  }
                }
              }
            };
            Layout2.prototype.positionNodesRandomly = function(graph) {
              if (graph == void 0) {
                this.positionNodesRandomly(this.getGraphManager().getRoot());
                this.getGraphManager().getRoot().updateBounds(true);
              } else {
                var lNode;
                var childGraph;
                var nodes = graph.getNodes();
                for (var i = 0; i < nodes.length; i++) {
                  lNode = nodes[i];
                  childGraph = lNode.getChild();
                  if (childGraph == null) {
                    lNode.scatter();
                  } else if (childGraph.getNodes().length == 0) {
                    lNode.scatter();
                  } else {
                    this.positionNodesRandomly(childGraph);
                    lNode.updateBounds();
                  }
                }
              }
            };
            Layout2.prototype.getFlatForest = function() {
              var flatForest = [];
              var isForest = true;
              var allNodes = this.graphManager.getRoot().getNodes();
              var isFlat = true;
              for (var i = 0; i < allNodes.length; i++) {
                if (allNodes[i].getChild() != null) {
                  isFlat = false;
                }
              }
              if (!isFlat) {
                return flatForest;
              }
              var visited = /* @__PURE__ */ new Set();
              var toBeVisited = [];
              var parents = /* @__PURE__ */ new Map();
              var unProcessedNodes = [];
              unProcessedNodes = unProcessedNodes.concat(allNodes);
              while (unProcessedNodes.length > 0 && isForest) {
                toBeVisited.push(unProcessedNodes[0]);
                while (toBeVisited.length > 0 && isForest) {
                  var currentNode = toBeVisited[0];
                  toBeVisited.splice(0, 1);
                  visited.add(currentNode);
                  var neighborEdges = currentNode.getEdges();
                  for (var i = 0; i < neighborEdges.length; i++) {
                    var currentNeighbor = neighborEdges[i].getOtherEnd(currentNode);
                    if (parents.get(currentNode) != currentNeighbor) {
                      if (!visited.has(currentNeighbor)) {
                        toBeVisited.push(currentNeighbor);
                        parents.set(currentNeighbor, currentNode);
                      } else {
                        isForest = false;
                        break;
                      }
                    }
                  }
                }
                if (!isForest) {
                  flatForest = [];
                } else {
                  var temp = [].concat(_toConsumableArray(visited));
                  flatForest.push(temp);
                  for (var i = 0; i < temp.length; i++) {
                    var value = temp[i];
                    var index = unProcessedNodes.indexOf(value);
                    if (index > -1) {
                      unProcessedNodes.splice(index, 1);
                    }
                  }
                  visited = /* @__PURE__ */ new Set();
                  parents = /* @__PURE__ */ new Map();
                }
              }
              return flatForest;
            };
            Layout2.prototype.createDummyNodesForBendpoints = function(edge) {
              var dummyNodes = [];
              var prev = edge.source;
              var graph = this.graphManager.calcLowestCommonAncestor(edge.source, edge.target);
              for (var i = 0; i < edge.bendpoints.length; i++) {
                var dummyNode = this.newNode(null);
                dummyNode.setRect(new Point(0, 0), new Dimension(1, 1));
                graph.add(dummyNode);
                var dummyEdge = this.newEdge(null);
                this.graphManager.add(dummyEdge, prev, dummyNode);
                dummyNodes.add(dummyNode);
                prev = dummyNode;
              }
              var dummyEdge = this.newEdge(null);
              this.graphManager.add(dummyEdge, prev, edge.target);
              this.edgeToDummyNodes.set(edge, dummyNodes);
              if (edge.isInterGraph()) {
                this.graphManager.remove(edge);
              } else {
                graph.remove(edge);
              }
              return dummyNodes;
            };
            Layout2.prototype.createBendpointsFromDummyNodes = function() {
              var edges = [];
              edges = edges.concat(this.graphManager.getAllEdges());
              edges = [].concat(_toConsumableArray(this.edgeToDummyNodes.keys())).concat(edges);
              for (var k = 0; k < edges.length; k++) {
                var lEdge = edges[k];
                if (lEdge.bendpoints.length > 0) {
                  var path = this.edgeToDummyNodes.get(lEdge);
                  for (var i = 0; i < path.length; i++) {
                    var dummyNode = path[i];
                    var p = new PointD(dummyNode.getCenterX(), dummyNode.getCenterY());
                    var ebp = lEdge.bendpoints.get(i);
                    ebp.x = p.x;
                    ebp.y = p.y;
                    dummyNode.getOwner().remove(dummyNode);
                  }
                  this.graphManager.add(lEdge, lEdge.source, lEdge.target);
                }
              }
            };
            Layout2.transform = function(sliderValue, defaultValue, minDiv, maxMul) {
              if (minDiv != void 0 && maxMul != void 0) {
                var value = defaultValue;
                if (sliderValue <= 50) {
                  var minValue = defaultValue / minDiv;
                  value -= (defaultValue - minValue) / 50 * (50 - sliderValue);
                } else {
                  var maxValue = defaultValue * maxMul;
                  value += (maxValue - defaultValue) / 50 * (sliderValue - 50);
                }
                return value;
              } else {
                var a, b;
                if (sliderValue <= 50) {
                  a = 9 * defaultValue / 500;
                  b = defaultValue / 10;
                } else {
                  a = 9 * defaultValue / 50;
                  b = -8 * defaultValue;
                }
                return a * sliderValue + b;
              }
            };
            Layout2.findCenterOfTree = function(nodes) {
              var list = [];
              list = list.concat(nodes);
              var removedNodes = [];
              var remainingDegrees = /* @__PURE__ */ new Map();
              var foundCenter = false;
              var centerNode = null;
              if (list.length == 1 || list.length == 2) {
                foundCenter = true;
                centerNode = list[0];
              }
              for (var i = 0; i < list.length; i++) {
                var node = list[i];
                var degree = node.getNeighborsList().size;
                remainingDegrees.set(node, node.getNeighborsList().size);
                if (degree == 1) {
                  removedNodes.push(node);
                }
              }
              var tempList = [];
              tempList = tempList.concat(removedNodes);
              while (!foundCenter) {
                var tempList2 = [];
                tempList2 = tempList2.concat(tempList);
                tempList = [];
                for (var i = 0; i < list.length; i++) {
                  var node = list[i];
                  var index = list.indexOf(node);
                  if (index >= 0) {
                    list.splice(index, 1);
                  }
                  var neighbours = node.getNeighborsList();
                  neighbours.forEach(function(neighbour) {
                    if (removedNodes.indexOf(neighbour) < 0) {
                      var otherDegree = remainingDegrees.get(neighbour);
                      var newDegree = otherDegree - 1;
                      if (newDegree == 1) {
                        tempList.push(neighbour);
                      }
                      remainingDegrees.set(neighbour, newDegree);
                    }
                  });
                }
                removedNodes = removedNodes.concat(tempList);
                if (list.length == 1 || list.length == 2) {
                  foundCenter = true;
                  centerNode = list[0];
                }
              }
              return centerNode;
            };
            Layout2.prototype.setGraphManager = function(gm) {
              this.graphManager = gm;
            };
            module2.exports = Layout2;
          },
          /* 16 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            function RandomSeed() {
            }
            __name(RandomSeed, "RandomSeed");
            RandomSeed.seed = 1;
            RandomSeed.x = 0;
            RandomSeed.nextDouble = function() {
              RandomSeed.x = Math.sin(RandomSeed.seed++) * 1e4;
              return RandomSeed.x - Math.floor(RandomSeed.x);
            };
            module2.exports = RandomSeed;
          },
          /* 17 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var PointD = __webpack_require__(4);
            function Transform(x, y) {
              this.lworldOrgX = 0;
              this.lworldOrgY = 0;
              this.ldeviceOrgX = 0;
              this.ldeviceOrgY = 0;
              this.lworldExtX = 1;
              this.lworldExtY = 1;
              this.ldeviceExtX = 1;
              this.ldeviceExtY = 1;
            }
            __name(Transform, "Transform");
            Transform.prototype.getWorldOrgX = function() {
              return this.lworldOrgX;
            };
            Transform.prototype.setWorldOrgX = function(wox) {
              this.lworldOrgX = wox;
            };
            Transform.prototype.getWorldOrgY = function() {
              return this.lworldOrgY;
            };
            Transform.prototype.setWorldOrgY = function(woy) {
              this.lworldOrgY = woy;
            };
            Transform.prototype.getWorldExtX = function() {
              return this.lworldExtX;
            };
            Transform.prototype.setWorldExtX = function(wex) {
              this.lworldExtX = wex;
            };
            Transform.prototype.getWorldExtY = function() {
              return this.lworldExtY;
            };
            Transform.prototype.setWorldExtY = function(wey) {
              this.lworldExtY = wey;
            };
            Transform.prototype.getDeviceOrgX = function() {
              return this.ldeviceOrgX;
            };
            Transform.prototype.setDeviceOrgX = function(dox) {
              this.ldeviceOrgX = dox;
            };
            Transform.prototype.getDeviceOrgY = function() {
              return this.ldeviceOrgY;
            };
            Transform.prototype.setDeviceOrgY = function(doy) {
              this.ldeviceOrgY = doy;
            };
            Transform.prototype.getDeviceExtX = function() {
              return this.ldeviceExtX;
            };
            Transform.prototype.setDeviceExtX = function(dex) {
              this.ldeviceExtX = dex;
            };
            Transform.prototype.getDeviceExtY = function() {
              return this.ldeviceExtY;
            };
            Transform.prototype.setDeviceExtY = function(dey) {
              this.ldeviceExtY = dey;
            };
            Transform.prototype.transformX = function(x) {
              var xDevice = 0;
              var worldExtX = this.lworldExtX;
              if (worldExtX != 0) {
                xDevice = this.ldeviceOrgX + (x - this.lworldOrgX) * this.ldeviceExtX / worldExtX;
              }
              return xDevice;
            };
            Transform.prototype.transformY = function(y) {
              var yDevice = 0;
              var worldExtY = this.lworldExtY;
              if (worldExtY != 0) {
                yDevice = this.ldeviceOrgY + (y - this.lworldOrgY) * this.ldeviceExtY / worldExtY;
              }
              return yDevice;
            };
            Transform.prototype.inverseTransformX = function(x) {
              var xWorld = 0;
              var deviceExtX = this.ldeviceExtX;
              if (deviceExtX != 0) {
                xWorld = this.lworldOrgX + (x - this.ldeviceOrgX) * this.lworldExtX / deviceExtX;
              }
              return xWorld;
            };
            Transform.prototype.inverseTransformY = function(y) {
              var yWorld = 0;
              var deviceExtY = this.ldeviceExtY;
              if (deviceExtY != 0) {
                yWorld = this.lworldOrgY + (y - this.ldeviceOrgY) * this.lworldExtY / deviceExtY;
              }
              return yWorld;
            };
            Transform.prototype.inverseTransformPoint = function(inPoint) {
              var outPoint = new PointD(this.inverseTransformX(inPoint.x), this.inverseTransformY(inPoint.y));
              return outPoint;
            };
            module2.exports = Transform;
          },
          /* 18 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            function _toConsumableArray(arr) {
              if (Array.isArray(arr)) {
                for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                  arr2[i] = arr[i];
                }
                return arr2;
              } else {
                return Array.from(arr);
              }
            }
            __name(_toConsumableArray, "_toConsumableArray");
            var Layout2 = __webpack_require__(15);
            var FDLayoutConstants = __webpack_require__(7);
            var LayoutConstants = __webpack_require__(0);
            var IGeometry = __webpack_require__(8);
            var IMath = __webpack_require__(9);
            function FDLayout() {
              Layout2.call(this);
              this.useSmartIdealEdgeLengthCalculation = FDLayoutConstants.DEFAULT_USE_SMART_IDEAL_EDGE_LENGTH_CALCULATION;
              this.idealEdgeLength = FDLayoutConstants.DEFAULT_EDGE_LENGTH;
              this.springConstant = FDLayoutConstants.DEFAULT_SPRING_STRENGTH;
              this.repulsionConstant = FDLayoutConstants.DEFAULT_REPULSION_STRENGTH;
              this.gravityConstant = FDLayoutConstants.DEFAULT_GRAVITY_STRENGTH;
              this.compoundGravityConstant = FDLayoutConstants.DEFAULT_COMPOUND_GRAVITY_STRENGTH;
              this.gravityRangeFactor = FDLayoutConstants.DEFAULT_GRAVITY_RANGE_FACTOR;
              this.compoundGravityRangeFactor = FDLayoutConstants.DEFAULT_COMPOUND_GRAVITY_RANGE_FACTOR;
              this.displacementThresholdPerNode = 3 * FDLayoutConstants.DEFAULT_EDGE_LENGTH / 100;
              this.coolingFactor = FDLayoutConstants.DEFAULT_COOLING_FACTOR_INCREMENTAL;
              this.initialCoolingFactor = FDLayoutConstants.DEFAULT_COOLING_FACTOR_INCREMENTAL;
              this.totalDisplacement = 0;
              this.oldTotalDisplacement = 0;
              this.maxIterations = FDLayoutConstants.MAX_ITERATIONS;
            }
            __name(FDLayout, "FDLayout");
            FDLayout.prototype = Object.create(Layout2.prototype);
            for (var prop in Layout2) {
              FDLayout[prop] = Layout2[prop];
            }
            FDLayout.prototype.initParameters = function() {
              Layout2.prototype.initParameters.call(this, arguments);
              this.totalIterations = 0;
              this.notAnimatedIterations = 0;
              this.useFRGridVariant = FDLayoutConstants.DEFAULT_USE_SMART_REPULSION_RANGE_CALCULATION;
              this.grid = [];
            };
            FDLayout.prototype.calcIdealEdgeLengths = function() {
              var edge;
              var lcaDepth;
              var source;
              var target;
              var sizeOfSourceInLca;
              var sizeOfTargetInLca;
              var allEdges = this.getGraphManager().getAllEdges();
              for (var i = 0; i < allEdges.length; i++) {
                edge = allEdges[i];
                edge.idealLength = this.idealEdgeLength;
                if (edge.isInterGraph) {
                  source = edge.getSource();
                  target = edge.getTarget();
                  sizeOfSourceInLca = edge.getSourceInLca().getEstimatedSize();
                  sizeOfTargetInLca = edge.getTargetInLca().getEstimatedSize();
                  if (this.useSmartIdealEdgeLengthCalculation) {
                    edge.idealLength += sizeOfSourceInLca + sizeOfTargetInLca - 2 * LayoutConstants.SIMPLE_NODE_SIZE;
                  }
                  lcaDepth = edge.getLca().getInclusionTreeDepth();
                  edge.idealLength += FDLayoutConstants.DEFAULT_EDGE_LENGTH * FDLayoutConstants.PER_LEVEL_IDEAL_EDGE_LENGTH_FACTOR * (source.getInclusionTreeDepth() + target.getInclusionTreeDepth() - 2 * lcaDepth);
                }
              }
            };
            FDLayout.prototype.initSpringEmbedder = function() {
              var s = this.getAllNodes().length;
              if (this.incremental) {
                if (s > FDLayoutConstants.ADAPTATION_LOWER_NODE_LIMIT) {
                  this.coolingFactor = Math.max(this.coolingFactor * FDLayoutConstants.COOLING_ADAPTATION_FACTOR, this.coolingFactor - (s - FDLayoutConstants.ADAPTATION_LOWER_NODE_LIMIT) / (FDLayoutConstants.ADAPTATION_UPPER_NODE_LIMIT - FDLayoutConstants.ADAPTATION_LOWER_NODE_LIMIT) * this.coolingFactor * (1 - FDLayoutConstants.COOLING_ADAPTATION_FACTOR));
                }
                this.maxNodeDisplacement = FDLayoutConstants.MAX_NODE_DISPLACEMENT_INCREMENTAL;
              } else {
                if (s > FDLayoutConstants.ADAPTATION_LOWER_NODE_LIMIT) {
                  this.coolingFactor = Math.max(FDLayoutConstants.COOLING_ADAPTATION_FACTOR, 1 - (s - FDLayoutConstants.ADAPTATION_LOWER_NODE_LIMIT) / (FDLayoutConstants.ADAPTATION_UPPER_NODE_LIMIT - FDLayoutConstants.ADAPTATION_LOWER_NODE_LIMIT) * (1 - FDLayoutConstants.COOLING_ADAPTATION_FACTOR));
                } else {
                  this.coolingFactor = 1;
                }
                this.initialCoolingFactor = this.coolingFactor;
                this.maxNodeDisplacement = FDLayoutConstants.MAX_NODE_DISPLACEMENT;
              }
              this.maxIterations = Math.max(this.getAllNodes().length * 5, this.maxIterations);
              this.totalDisplacementThreshold = this.displacementThresholdPerNode * this.getAllNodes().length;
              this.repulsionRange = this.calcRepulsionRange();
            };
            FDLayout.prototype.calcSpringForces = function() {
              var lEdges = this.getAllEdges();
              var edge;
              for (var i = 0; i < lEdges.length; i++) {
                edge = lEdges[i];
                this.calcSpringForce(edge, edge.idealLength);
              }
            };
            FDLayout.prototype.calcRepulsionForces = function() {
              var gridUpdateAllowed = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : true;
              var forceToNodeSurroundingUpdate = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
              var i, j;
              var nodeA, nodeB;
              var lNodes = this.getAllNodes();
              var processedNodeSet;
              if (this.useFRGridVariant) {
                if (this.totalIterations % FDLayoutConstants.GRID_CALCULATION_CHECK_PERIOD == 1 && gridUpdateAllowed) {
                  this.updateGrid();
                }
                processedNodeSet = /* @__PURE__ */ new Set();
                for (i = 0; i < lNodes.length; i++) {
                  nodeA = lNodes[i];
                  this.calculateRepulsionForceOfANode(nodeA, processedNodeSet, gridUpdateAllowed, forceToNodeSurroundingUpdate);
                  processedNodeSet.add(nodeA);
                }
              } else {
                for (i = 0; i < lNodes.length; i++) {
                  nodeA = lNodes[i];
                  for (j = i + 1; j < lNodes.length; j++) {
                    nodeB = lNodes[j];
                    if (nodeA.getOwner() != nodeB.getOwner()) {
                      continue;
                    }
                    this.calcRepulsionForce(nodeA, nodeB);
                  }
                }
              }
            };
            FDLayout.prototype.calcGravitationalForces = function() {
              var node;
              var lNodes = this.getAllNodesToApplyGravitation();
              for (var i = 0; i < lNodes.length; i++) {
                node = lNodes[i];
                this.calcGravitationalForce(node);
              }
            };
            FDLayout.prototype.moveNodes = function() {
              var lNodes = this.getAllNodes();
              var node;
              for (var i = 0; i < lNodes.length; i++) {
                node = lNodes[i];
                node.move();
              }
            };
            FDLayout.prototype.calcSpringForce = function(edge, idealLength) {
              var sourceNode = edge.getSource();
              var targetNode = edge.getTarget();
              var length;
              var springForce;
              var springForceX;
              var springForceY;
              if (this.uniformLeafNodeSizes && sourceNode.getChild() == null && targetNode.getChild() == null) {
                edge.updateLengthSimple();
              } else {
                edge.updateLength();
                if (edge.isOverlapingSourceAndTarget) {
                  return;
                }
              }
              length = edge.getLength();
              if (length == 0) return;
              springForce = this.springConstant * (length - idealLength);
              springForceX = springForce * (edge.lengthX / length);
              springForceY = springForce * (edge.lengthY / length);
              sourceNode.springForceX += springForceX;
              sourceNode.springForceY += springForceY;
              targetNode.springForceX -= springForceX;
              targetNode.springForceY -= springForceY;
            };
            FDLayout.prototype.calcRepulsionForce = function(nodeA, nodeB) {
              var rectA = nodeA.getRect();
              var rectB = nodeB.getRect();
              var overlapAmount = new Array(2);
              var clipPoints = new Array(4);
              var distanceX;
              var distanceY;
              var distanceSquared;
              var distance;
              var repulsionForce;
              var repulsionForceX;
              var repulsionForceY;
              if (rectA.intersects(rectB)) {
                IGeometry.calcSeparationAmount(rectA, rectB, overlapAmount, FDLayoutConstants.DEFAULT_EDGE_LENGTH / 2);
                repulsionForceX = 2 * overlapAmount[0];
                repulsionForceY = 2 * overlapAmount[1];
                var childrenConstant = nodeA.noOfChildren * nodeB.noOfChildren / (nodeA.noOfChildren + nodeB.noOfChildren);
                nodeA.repulsionForceX -= childrenConstant * repulsionForceX;
                nodeA.repulsionForceY -= childrenConstant * repulsionForceY;
                nodeB.repulsionForceX += childrenConstant * repulsionForceX;
                nodeB.repulsionForceY += childrenConstant * repulsionForceY;
              } else {
                if (this.uniformLeafNodeSizes && nodeA.getChild() == null && nodeB.getChild() == null) {
                  distanceX = rectB.getCenterX() - rectA.getCenterX();
                  distanceY = rectB.getCenterY() - rectA.getCenterY();
                } else {
                  IGeometry.getIntersection(rectA, rectB, clipPoints);
                  distanceX = clipPoints[2] - clipPoints[0];
                  distanceY = clipPoints[3] - clipPoints[1];
                }
                if (Math.abs(distanceX) < FDLayoutConstants.MIN_REPULSION_DIST) {
                  distanceX = IMath.sign(distanceX) * FDLayoutConstants.MIN_REPULSION_DIST;
                }
                if (Math.abs(distanceY) < FDLayoutConstants.MIN_REPULSION_DIST) {
                  distanceY = IMath.sign(distanceY) * FDLayoutConstants.MIN_REPULSION_DIST;
                }
                distanceSquared = distanceX * distanceX + distanceY * distanceY;
                distance = Math.sqrt(distanceSquared);
                repulsionForce = this.repulsionConstant * nodeA.noOfChildren * nodeB.noOfChildren / distanceSquared;
                repulsionForceX = repulsionForce * distanceX / distance;
                repulsionForceY = repulsionForce * distanceY / distance;
                nodeA.repulsionForceX -= repulsionForceX;
                nodeA.repulsionForceY -= repulsionForceY;
                nodeB.repulsionForceX += repulsionForceX;
                nodeB.repulsionForceY += repulsionForceY;
              }
            };
            FDLayout.prototype.calcGravitationalForce = function(node) {
              var ownerGraph;
              var ownerCenterX;
              var ownerCenterY;
              var distanceX;
              var distanceY;
              var absDistanceX;
              var absDistanceY;
              var estimatedSize;
              ownerGraph = node.getOwner();
              ownerCenterX = (ownerGraph.getRight() + ownerGraph.getLeft()) / 2;
              ownerCenterY = (ownerGraph.getTop() + ownerGraph.getBottom()) / 2;
              distanceX = node.getCenterX() - ownerCenterX;
              distanceY = node.getCenterY() - ownerCenterY;
              absDistanceX = Math.abs(distanceX) + node.getWidth() / 2;
              absDistanceY = Math.abs(distanceY) + node.getHeight() / 2;
              if (node.getOwner() == this.graphManager.getRoot()) {
                estimatedSize = ownerGraph.getEstimatedSize() * this.gravityRangeFactor;
                if (absDistanceX > estimatedSize || absDistanceY > estimatedSize) {
                  node.gravitationForceX = -this.gravityConstant * distanceX;
                  node.gravitationForceY = -this.gravityConstant * distanceY;
                }
              } else {
                estimatedSize = ownerGraph.getEstimatedSize() * this.compoundGravityRangeFactor;
                if (absDistanceX > estimatedSize || absDistanceY > estimatedSize) {
                  node.gravitationForceX = -this.gravityConstant * distanceX * this.compoundGravityConstant;
                  node.gravitationForceY = -this.gravityConstant * distanceY * this.compoundGravityConstant;
                }
              }
            };
            FDLayout.prototype.isConverged = function() {
              var converged;
              var oscilating = false;
              if (this.totalIterations > this.maxIterations / 3) {
                oscilating = Math.abs(this.totalDisplacement - this.oldTotalDisplacement) < 2;
              }
              converged = this.totalDisplacement < this.totalDisplacementThreshold;
              this.oldTotalDisplacement = this.totalDisplacement;
              return converged || oscilating;
            };
            FDLayout.prototype.animate = function() {
              if (this.animationDuringLayout && !this.isSubLayout) {
                if (this.notAnimatedIterations == this.animationPeriod) {
                  this.update();
                  this.notAnimatedIterations = 0;
                } else {
                  this.notAnimatedIterations++;
                }
              }
            };
            FDLayout.prototype.calcNoOfChildrenForAllNodes = function() {
              var node;
              var allNodes = this.graphManager.getAllNodes();
              for (var i = 0; i < allNodes.length; i++) {
                node = allNodes[i];
                node.noOfChildren = node.getNoOfChildren();
              }
            };
            FDLayout.prototype.calcGrid = function(graph) {
              var sizeX = 0;
              var sizeY = 0;
              sizeX = parseInt(Math.ceil((graph.getRight() - graph.getLeft()) / this.repulsionRange));
              sizeY = parseInt(Math.ceil((graph.getBottom() - graph.getTop()) / this.repulsionRange));
              var grid = new Array(sizeX);
              for (var i = 0; i < sizeX; i++) {
                grid[i] = new Array(sizeY);
              }
              for (var i = 0; i < sizeX; i++) {
                for (var j = 0; j < sizeY; j++) {
                  grid[i][j] = new Array();
                }
              }
              return grid;
            };
            FDLayout.prototype.addNodeToGrid = function(v, left, top) {
              var startX = 0;
              var finishX = 0;
              var startY = 0;
              var finishY = 0;
              startX = parseInt(Math.floor((v.getRect().x - left) / this.repulsionRange));
              finishX = parseInt(Math.floor((v.getRect().width + v.getRect().x - left) / this.repulsionRange));
              startY = parseInt(Math.floor((v.getRect().y - top) / this.repulsionRange));
              finishY = parseInt(Math.floor((v.getRect().height + v.getRect().y - top) / this.repulsionRange));
              for (var i = startX; i <= finishX; i++) {
                for (var j = startY; j <= finishY; j++) {
                  this.grid[i][j].push(v);
                  v.setGridCoordinates(startX, finishX, startY, finishY);
                }
              }
            };
            FDLayout.prototype.updateGrid = function() {
              var i;
              var nodeA;
              var lNodes = this.getAllNodes();
              this.grid = this.calcGrid(this.graphManager.getRoot());
              for (i = 0; i < lNodes.length; i++) {
                nodeA = lNodes[i];
                this.addNodeToGrid(nodeA, this.graphManager.getRoot().getLeft(), this.graphManager.getRoot().getTop());
              }
            };
            FDLayout.prototype.calculateRepulsionForceOfANode = function(nodeA, processedNodeSet, gridUpdateAllowed, forceToNodeSurroundingUpdate) {
              if (this.totalIterations % FDLayoutConstants.GRID_CALCULATION_CHECK_PERIOD == 1 && gridUpdateAllowed || forceToNodeSurroundingUpdate) {
                var surrounding = /* @__PURE__ */ new Set();
                nodeA.surrounding = new Array();
                var nodeB;
                var grid = this.grid;
                for (var i = nodeA.startX - 1; i < nodeA.finishX + 2; i++) {
                  for (var j = nodeA.startY - 1; j < nodeA.finishY + 2; j++) {
                    if (!(i < 0 || j < 0 || i >= grid.length || j >= grid[0].length)) {
                      for (var k = 0; k < grid[i][j].length; k++) {
                        nodeB = grid[i][j][k];
                        if (nodeA.getOwner() != nodeB.getOwner() || nodeA == nodeB) {
                          continue;
                        }
                        if (!processedNodeSet.has(nodeB) && !surrounding.has(nodeB)) {
                          var distanceX = Math.abs(nodeA.getCenterX() - nodeB.getCenterX()) - (nodeA.getWidth() / 2 + nodeB.getWidth() / 2);
                          var distanceY = Math.abs(nodeA.getCenterY() - nodeB.getCenterY()) - (nodeA.getHeight() / 2 + nodeB.getHeight() / 2);
                          if (distanceX <= this.repulsionRange && distanceY <= this.repulsionRange) {
                            surrounding.add(nodeB);
                          }
                        }
                      }
                    }
                  }
                }
                nodeA.surrounding = [].concat(_toConsumableArray(surrounding));
              }
              for (i = 0; i < nodeA.surrounding.length; i++) {
                this.calcRepulsionForce(nodeA, nodeA.surrounding[i]);
              }
            };
            FDLayout.prototype.calcRepulsionRange = function() {
              return 0;
            };
            module2.exports = FDLayout;
          },
          /* 19 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var LEdge = __webpack_require__(1);
            var FDLayoutConstants = __webpack_require__(7);
            function FDLayoutEdge(source, target, vEdge) {
              LEdge.call(this, source, target, vEdge);
              this.idealLength = FDLayoutConstants.DEFAULT_EDGE_LENGTH;
            }
            __name(FDLayoutEdge, "FDLayoutEdge");
            FDLayoutEdge.prototype = Object.create(LEdge.prototype);
            for (var prop in LEdge) {
              FDLayoutEdge[prop] = LEdge[prop];
            }
            module2.exports = FDLayoutEdge;
          },
          /* 20 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var LNode = __webpack_require__(3);
            function FDLayoutNode(gm, loc, size, vNode) {
              LNode.call(this, gm, loc, size, vNode);
              this.springForceX = 0;
              this.springForceY = 0;
              this.repulsionForceX = 0;
              this.repulsionForceY = 0;
              this.gravitationForceX = 0;
              this.gravitationForceY = 0;
              this.displacementX = 0;
              this.displacementY = 0;
              this.startX = 0;
              this.finishX = 0;
              this.startY = 0;
              this.finishY = 0;
              this.surrounding = [];
            }
            __name(FDLayoutNode, "FDLayoutNode");
            FDLayoutNode.prototype = Object.create(LNode.prototype);
            for (var prop in LNode) {
              FDLayoutNode[prop] = LNode[prop];
            }
            FDLayoutNode.prototype.setGridCoordinates = function(_startX, _finishX, _startY, _finishY) {
              this.startX = _startX;
              this.finishX = _finishX;
              this.startY = _startY;
              this.finishY = _finishY;
            };
            module2.exports = FDLayoutNode;
          },
          /* 21 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            function DimensionD2(width, height) {
              this.width = 0;
              this.height = 0;
              if (width !== null && height !== null) {
                this.height = height;
                this.width = width;
              }
            }
            __name(DimensionD2, "DimensionD");
            DimensionD2.prototype.getWidth = function() {
              return this.width;
            };
            DimensionD2.prototype.setWidth = function(width) {
              this.width = width;
            };
            DimensionD2.prototype.getHeight = function() {
              return this.height;
            };
            DimensionD2.prototype.setHeight = function(height) {
              this.height = height;
            };
            module2.exports = DimensionD2;
          },
          /* 22 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var UniqueIDGeneretor = __webpack_require__(14);
            function HashMap() {
              this.map = {};
              this.keys = [];
            }
            __name(HashMap, "HashMap");
            HashMap.prototype.put = function(key, value) {
              var theId = UniqueIDGeneretor.createID(key);
              if (!this.contains(theId)) {
                this.map[theId] = value;
                this.keys.push(key);
              }
            };
            HashMap.prototype.contains = function(key) {
              var theId = UniqueIDGeneretor.createID(key);
              return this.map[key] != null;
            };
            HashMap.prototype.get = function(key) {
              var theId = UniqueIDGeneretor.createID(key);
              return this.map[theId];
            };
            HashMap.prototype.keySet = function() {
              return this.keys;
            };
            module2.exports = HashMap;
          },
          /* 23 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var UniqueIDGeneretor = __webpack_require__(14);
            function HashSet() {
              this.set = {};
            }
            __name(HashSet, "HashSet");
            ;
            HashSet.prototype.add = function(obj) {
              var theId = UniqueIDGeneretor.createID(obj);
              if (!this.contains(theId)) this.set[theId] = obj;
            };
            HashSet.prototype.remove = function(obj) {
              delete this.set[UniqueIDGeneretor.createID(obj)];
            };
            HashSet.prototype.clear = function() {
              this.set = {};
            };
            HashSet.prototype.contains = function(obj) {
              return this.set[UniqueIDGeneretor.createID(obj)] == obj;
            };
            HashSet.prototype.isEmpty = function() {
              return this.size() === 0;
            };
            HashSet.prototype.size = function() {
              return Object.keys(this.set).length;
            };
            HashSet.prototype.addAllTo = function(list) {
              var keys = Object.keys(this.set);
              var length = keys.length;
              for (var i = 0; i < length; i++) {
                list.push(this.set[keys[i]]);
              }
            };
            HashSet.prototype.size = function() {
              return Object.keys(this.set).length;
            };
            HashSet.prototype.addAll = function(list) {
              var s = list.length;
              for (var i = 0; i < s; i++) {
                var v = list[i];
                this.add(v);
              }
            };
            module2.exports = HashSet;
          },
          /* 24 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var _createClass = /* @__PURE__ */ function() {
              function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                  var descriptor = props[i];
                  descriptor.enumerable = descriptor.enumerable || false;
                  descriptor.configurable = true;
                  if ("value" in descriptor) descriptor.writable = true;
                  Object.defineProperty(target, descriptor.key, descriptor);
                }
              }
              __name(defineProperties, "defineProperties");
              return function(Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
              };
            }();
            function _classCallCheck(instance2, Constructor) {
              if (!(instance2 instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
              }
            }
            __name(_classCallCheck, "_classCallCheck");
            var LinkedList = __webpack_require__(11);
            var Quicksort = function() {
              function Quicksort2(A, compareFunction) {
                _classCallCheck(this, Quicksort2);
                if (compareFunction !== null || compareFunction !== void 0) this.compareFunction = this._defaultCompareFunction;
                var length = void 0;
                if (A instanceof LinkedList) length = A.size();
                else length = A.length;
                this._quicksort(A, 0, length - 1);
              }
              __name(Quicksort2, "Quicksort");
              _createClass(Quicksort2, [{
                key: "_quicksort",
                value: /* @__PURE__ */ __name(function _quicksort(A, p, r) {
                  if (p < r) {
                    var q = this._partition(A, p, r);
                    this._quicksort(A, p, q);
                    this._quicksort(A, q + 1, r);
                  }
                }, "_quicksort")
              }, {
                key: "_partition",
                value: /* @__PURE__ */ __name(function _partition(A, p, r) {
                  var x = this._get(A, p);
                  var i = p;
                  var j = r;
                  while (true) {
                    while (this.compareFunction(x, this._get(A, j))) {
                      j--;
                    }
                    while (this.compareFunction(this._get(A, i), x)) {
                      i++;
                    }
                    if (i < j) {
                      this._swap(A, i, j);
                      i++;
                      j--;
                    } else return j;
                  }
                }, "_partition")
              }, {
                key: "_get",
                value: /* @__PURE__ */ __name(function _get(object, index) {
                  if (object instanceof LinkedList) return object.get_object_at(index);
                  else return object[index];
                }, "_get")
              }, {
                key: "_set",
                value: /* @__PURE__ */ __name(function _set(object, index, value) {
                  if (object instanceof LinkedList) object.set_object_at(index, value);
                  else object[index] = value;
                }, "_set")
              }, {
                key: "_swap",
                value: /* @__PURE__ */ __name(function _swap(A, i, j) {
                  var temp = this._get(A, i);
                  this._set(A, i, this._get(A, j));
                  this._set(A, j, temp);
                }, "_swap")
              }, {
                key: "_defaultCompareFunction",
                value: /* @__PURE__ */ __name(function _defaultCompareFunction(a, b) {
                  return b > a;
                }, "_defaultCompareFunction")
              }]);
              return Quicksort2;
            }();
            module2.exports = Quicksort;
          },
          /* 25 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var _createClass = /* @__PURE__ */ function() {
              function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                  var descriptor = props[i];
                  descriptor.enumerable = descriptor.enumerable || false;
                  descriptor.configurable = true;
                  if ("value" in descriptor) descriptor.writable = true;
                  Object.defineProperty(target, descriptor.key, descriptor);
                }
              }
              __name(defineProperties, "defineProperties");
              return function(Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
              };
            }();
            function _classCallCheck(instance2, Constructor) {
              if (!(instance2 instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
              }
            }
            __name(_classCallCheck, "_classCallCheck");
            var NeedlemanWunsch = function() {
              function NeedlemanWunsch2(sequence1, sequence2) {
                var match_score = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : 1;
                var mismatch_penalty = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : -1;
                var gap_penalty = arguments.length > 4 && arguments[4] !== void 0 ? arguments[4] : -1;
                _classCallCheck(this, NeedlemanWunsch2);
                this.sequence1 = sequence1;
                this.sequence2 = sequence2;
                this.match_score = match_score;
                this.mismatch_penalty = mismatch_penalty;
                this.gap_penalty = gap_penalty;
                this.iMax = sequence1.length + 1;
                this.jMax = sequence2.length + 1;
                this.grid = new Array(this.iMax);
                for (var i = 0; i < this.iMax; i++) {
                  this.grid[i] = new Array(this.jMax);
                  for (var j = 0; j < this.jMax; j++) {
                    this.grid[i][j] = 0;
                  }
                }
                this.tracebackGrid = new Array(this.iMax);
                for (var _i = 0; _i < this.iMax; _i++) {
                  this.tracebackGrid[_i] = new Array(this.jMax);
                  for (var _j = 0; _j < this.jMax; _j++) {
                    this.tracebackGrid[_i][_j] = [null, null, null];
                  }
                }
                this.alignments = [];
                this.score = -1;
                this.computeGrids();
              }
              __name(NeedlemanWunsch2, "NeedlemanWunsch");
              _createClass(NeedlemanWunsch2, [{
                key: "getScore",
                value: /* @__PURE__ */ __name(function getScore() {
                  return this.score;
                }, "getScore")
              }, {
                key: "getAlignments",
                value: /* @__PURE__ */ __name(function getAlignments() {
                  return this.alignments;
                }, "getAlignments")
                // Main dynamic programming procedure
              }, {
                key: "computeGrids",
                value: /* @__PURE__ */ __name(function computeGrids() {
                  for (var j = 1; j < this.jMax; j++) {
                    this.grid[0][j] = this.grid[0][j - 1] + this.gap_penalty;
                    this.tracebackGrid[0][j] = [false, false, true];
                  }
                  for (var i = 1; i < this.iMax; i++) {
                    this.grid[i][0] = this.grid[i - 1][0] + this.gap_penalty;
                    this.tracebackGrid[i][0] = [false, true, false];
                  }
                  for (var _i2 = 1; _i2 < this.iMax; _i2++) {
                    for (var _j2 = 1; _j2 < this.jMax; _j2++) {
                      var diag = void 0;
                      if (this.sequence1[_i2 - 1] === this.sequence2[_j2 - 1]) diag = this.grid[_i2 - 1][_j2 - 1] + this.match_score;
                      else diag = this.grid[_i2 - 1][_j2 - 1] + this.mismatch_penalty;
                      var up = this.grid[_i2 - 1][_j2] + this.gap_penalty;
                      var left = this.grid[_i2][_j2 - 1] + this.gap_penalty;
                      var maxOf = [diag, up, left];
                      var indices = this.arrayAllMaxIndexes(maxOf);
                      this.grid[_i2][_j2] = maxOf[indices[0]];
                      this.tracebackGrid[_i2][_j2] = [indices.includes(0), indices.includes(1), indices.includes(2)];
                    }
                  }
                  this.score = this.grid[this.iMax - 1][this.jMax - 1];
                }, "computeGrids")
                // Gets all possible valid sequence combinations
              }, {
                key: "alignmentTraceback",
                value: /* @__PURE__ */ __name(function alignmentTraceback() {
                  var inProcessAlignments = [];
                  inProcessAlignments.push({
                    pos: [this.sequence1.length, this.sequence2.length],
                    seq1: "",
                    seq2: ""
                  });
                  while (inProcessAlignments[0]) {
                    var current = inProcessAlignments[0];
                    var directions = this.tracebackGrid[current.pos[0]][current.pos[1]];
                    if (directions[0]) {
                      inProcessAlignments.push({
                        pos: [current.pos[0] - 1, current.pos[1] - 1],
                        seq1: this.sequence1[current.pos[0] - 1] + current.seq1,
                        seq2: this.sequence2[current.pos[1] - 1] + current.seq2
                      });
                    }
                    if (directions[1]) {
                      inProcessAlignments.push({
                        pos: [current.pos[0] - 1, current.pos[1]],
                        seq1: this.sequence1[current.pos[0] - 1] + current.seq1,
                        seq2: "-" + current.seq2
                      });
                    }
                    if (directions[2]) {
                      inProcessAlignments.push({
                        pos: [current.pos[0], current.pos[1] - 1],
                        seq1: "-" + current.seq1,
                        seq2: this.sequence2[current.pos[1] - 1] + current.seq2
                      });
                    }
                    if (current.pos[0] === 0 && current.pos[1] === 0) this.alignments.push({
                      sequence1: current.seq1,
                      sequence2: current.seq2
                    });
                    inProcessAlignments.shift();
                  }
                  return this.alignments;
                }, "alignmentTraceback")
                // Helper Functions
              }, {
                key: "getAllIndexes",
                value: /* @__PURE__ */ __name(function getAllIndexes(arr, val) {
                  var indexes = [], i = -1;
                  while ((i = arr.indexOf(val, i + 1)) !== -1) {
                    indexes.push(i);
                  }
                  return indexes;
                }, "getAllIndexes")
              }, {
                key: "arrayAllMaxIndexes",
                value: /* @__PURE__ */ __name(function arrayAllMaxIndexes(array) {
                  return this.getAllIndexes(array, Math.max.apply(null, array));
                }, "arrayAllMaxIndexes")
              }]);
              return NeedlemanWunsch2;
            }();
            module2.exports = NeedlemanWunsch;
          },
          /* 26 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var layoutBase = /* @__PURE__ */ __name(function layoutBase2() {
              return;
            }, "layoutBase");
            layoutBase.FDLayout = __webpack_require__(18);
            layoutBase.FDLayoutConstants = __webpack_require__(7);
            layoutBase.FDLayoutEdge = __webpack_require__(19);
            layoutBase.FDLayoutNode = __webpack_require__(20);
            layoutBase.DimensionD = __webpack_require__(21);
            layoutBase.HashMap = __webpack_require__(22);
            layoutBase.HashSet = __webpack_require__(23);
            layoutBase.IGeometry = __webpack_require__(8);
            layoutBase.IMath = __webpack_require__(9);
            layoutBase.Integer = __webpack_require__(10);
            layoutBase.Point = __webpack_require__(12);
            layoutBase.PointD = __webpack_require__(4);
            layoutBase.RandomSeed = __webpack_require__(16);
            layoutBase.RectangleD = __webpack_require__(13);
            layoutBase.Transform = __webpack_require__(17);
            layoutBase.UniqueIDGeneretor = __webpack_require__(14);
            layoutBase.Quicksort = __webpack_require__(24);
            layoutBase.LinkedList = __webpack_require__(11);
            layoutBase.LGraphObject = __webpack_require__(2);
            layoutBase.LGraph = __webpack_require__(5);
            layoutBase.LEdge = __webpack_require__(1);
            layoutBase.LGraphManager = __webpack_require__(6);
            layoutBase.LNode = __webpack_require__(3);
            layoutBase.Layout = __webpack_require__(15);
            layoutBase.LayoutConstants = __webpack_require__(0);
            layoutBase.NeedlemanWunsch = __webpack_require__(25);
            module2.exports = layoutBase;
          },
          /* 27 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            function Emitter() {
              this.listeners = [];
            }
            __name(Emitter, "Emitter");
            var p = Emitter.prototype;
            p.addListener = function(event, callback) {
              this.listeners.push({
                event,
                callback
              });
            };
            p.removeListener = function(event, callback) {
              for (var i = this.listeners.length; i >= 0; i--) {
                var l = this.listeners[i];
                if (l.event === event && l.callback === callback) {
                  this.listeners.splice(i, 1);
                }
              }
            };
            p.emit = function(event, data) {
              for (var i = 0; i < this.listeners.length; i++) {
                var l = this.listeners[i];
                if (event === l.event) {
                  l.callback(data);
                }
              }
            };
            module2.exports = Emitter;
          }
          /******/
        ])
      );
    });
  }
});

// ../../node_modules/.pnpm/cose-base@1.0.3/node_modules/cose-base/cose-base.js
var require_cose_base = __commonJS({
  "../../node_modules/.pnpm/cose-base@1.0.3/node_modules/cose-base/cose-base.js"(exports, module) {
    "use strict";
    (/* @__PURE__ */ __name(function webpackUniversalModuleDefinition(root, factory) {
      if (typeof exports === "object" && typeof module === "object")
        module.exports = factory(require_layout_base());
      else if (typeof define === "function" && define.amd)
        define(["layout-base"], factory);
      else if (typeof exports === "object")
        exports["coseBase"] = factory(require_layout_base());
      else
        root["coseBase"] = factory(root["layoutBase"]);
    }, "webpackUniversalModuleDefinition"))(exports, function(__WEBPACK_EXTERNAL_MODULE_0__) {
      return (
        /******/
        function(modules) {
          var installedModules = {};
          function __webpack_require__(moduleId) {
            if (installedModules[moduleId]) {
              return installedModules[moduleId].exports;
            }
            var module2 = installedModules[moduleId] = {
              /******/
              i: moduleId,
              /******/
              l: false,
              /******/
              exports: {}
              /******/
            };
            modules[moduleId].call(module2.exports, module2, module2.exports, __webpack_require__);
            module2.l = true;
            return module2.exports;
          }
          __name(__webpack_require__, "__webpack_require__");
          __webpack_require__.m = modules;
          __webpack_require__.c = installedModules;
          __webpack_require__.i = function(value) {
            return value;
          };
          __webpack_require__.d = function(exports2, name, getter) {
            if (!__webpack_require__.o(exports2, name)) {
              Object.defineProperty(exports2, name, {
                /******/
                configurable: false,
                /******/
                enumerable: true,
                /******/
                get: getter
                /******/
              });
            }
          };
          __webpack_require__.n = function(module2) {
            var getter = module2 && module2.__esModule ? (
              /******/
              /* @__PURE__ */ __name(function getDefault() {
                return module2["default"];
              }, "getDefault")
            ) : (
              /******/
              /* @__PURE__ */ __name(function getModuleExports() {
                return module2;
              }, "getModuleExports")
            );
            __webpack_require__.d(getter, "a", getter);
            return getter;
          };
          __webpack_require__.o = function(object, property) {
            return Object.prototype.hasOwnProperty.call(object, property);
          };
          __webpack_require__.p = "";
          return __webpack_require__(__webpack_require__.s = 7);
        }([
          /* 0 */
          /***/
          function(module2, exports2) {
            module2.exports = __WEBPACK_EXTERNAL_MODULE_0__;
          },
          /* 1 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var FDLayoutConstants = __webpack_require__(0).FDLayoutConstants;
            function CoSEConstants() {
            }
            __name(CoSEConstants, "CoSEConstants");
            for (var prop in FDLayoutConstants) {
              CoSEConstants[prop] = FDLayoutConstants[prop];
            }
            CoSEConstants.DEFAULT_USE_MULTI_LEVEL_SCALING = false;
            CoSEConstants.DEFAULT_RADIAL_SEPARATION = FDLayoutConstants.DEFAULT_EDGE_LENGTH;
            CoSEConstants.DEFAULT_COMPONENT_SEPERATION = 60;
            CoSEConstants.TILE = true;
            CoSEConstants.TILING_PADDING_VERTICAL = 10;
            CoSEConstants.TILING_PADDING_HORIZONTAL = 10;
            CoSEConstants.TREE_REDUCTION_ON_INCREMENTAL = false;
            module2.exports = CoSEConstants;
          },
          /* 2 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var FDLayoutEdge = __webpack_require__(0).FDLayoutEdge;
            function CoSEEdge(source, target, vEdge) {
              FDLayoutEdge.call(this, source, target, vEdge);
            }
            __name(CoSEEdge, "CoSEEdge");
            CoSEEdge.prototype = Object.create(FDLayoutEdge.prototype);
            for (var prop in FDLayoutEdge) {
              CoSEEdge[prop] = FDLayoutEdge[prop];
            }
            module2.exports = CoSEEdge;
          },
          /* 3 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var LGraph = __webpack_require__(0).LGraph;
            function CoSEGraph(parent, graphMgr, vGraph) {
              LGraph.call(this, parent, graphMgr, vGraph);
            }
            __name(CoSEGraph, "CoSEGraph");
            CoSEGraph.prototype = Object.create(LGraph.prototype);
            for (var prop in LGraph) {
              CoSEGraph[prop] = LGraph[prop];
            }
            module2.exports = CoSEGraph;
          },
          /* 4 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var LGraphManager = __webpack_require__(0).LGraphManager;
            function CoSEGraphManager(layout) {
              LGraphManager.call(this, layout);
            }
            __name(CoSEGraphManager, "CoSEGraphManager");
            CoSEGraphManager.prototype = Object.create(LGraphManager.prototype);
            for (var prop in LGraphManager) {
              CoSEGraphManager[prop] = LGraphManager[prop];
            }
            module2.exports = CoSEGraphManager;
          },
          /* 5 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var FDLayoutNode = __webpack_require__(0).FDLayoutNode;
            var IMath = __webpack_require__(0).IMath;
            function CoSENode(gm, loc, size, vNode) {
              FDLayoutNode.call(this, gm, loc, size, vNode);
            }
            __name(CoSENode, "CoSENode");
            CoSENode.prototype = Object.create(FDLayoutNode.prototype);
            for (var prop in FDLayoutNode) {
              CoSENode[prop] = FDLayoutNode[prop];
            }
            CoSENode.prototype.move = function() {
              var layout = this.graphManager.getLayout();
              this.displacementX = layout.coolingFactor * (this.springForceX + this.repulsionForceX + this.gravitationForceX) / this.noOfChildren;
              this.displacementY = layout.coolingFactor * (this.springForceY + this.repulsionForceY + this.gravitationForceY) / this.noOfChildren;
              if (Math.abs(this.displacementX) > layout.coolingFactor * layout.maxNodeDisplacement) {
                this.displacementX = layout.coolingFactor * layout.maxNodeDisplacement * IMath.sign(this.displacementX);
              }
              if (Math.abs(this.displacementY) > layout.coolingFactor * layout.maxNodeDisplacement) {
                this.displacementY = layout.coolingFactor * layout.maxNodeDisplacement * IMath.sign(this.displacementY);
              }
              if (this.child == null) {
                this.moveBy(this.displacementX, this.displacementY);
              } else if (this.child.getNodes().length == 0) {
                this.moveBy(this.displacementX, this.displacementY);
              } else {
                this.propogateDisplacementToChildren(this.displacementX, this.displacementY);
              }
              layout.totalDisplacement += Math.abs(this.displacementX) + Math.abs(this.displacementY);
              this.springForceX = 0;
              this.springForceY = 0;
              this.repulsionForceX = 0;
              this.repulsionForceY = 0;
              this.gravitationForceX = 0;
              this.gravitationForceY = 0;
              this.displacementX = 0;
              this.displacementY = 0;
            };
            CoSENode.prototype.propogateDisplacementToChildren = function(dX, dY) {
              var nodes = this.getChild().getNodes();
              var node;
              for (var i = 0; i < nodes.length; i++) {
                node = nodes[i];
                if (node.getChild() == null) {
                  node.moveBy(dX, dY);
                  node.displacementX += dX;
                  node.displacementY += dY;
                } else {
                  node.propogateDisplacementToChildren(dX, dY);
                }
              }
            };
            CoSENode.prototype.setPred1 = function(pred12) {
              this.pred1 = pred12;
            };
            CoSENode.prototype.getPred1 = function() {
              return pred1;
            };
            CoSENode.prototype.getPred2 = function() {
              return pred2;
            };
            CoSENode.prototype.setNext = function(next2) {
              this.next = next2;
            };
            CoSENode.prototype.getNext = function() {
              return next;
            };
            CoSENode.prototype.setProcessed = function(processed2) {
              this.processed = processed2;
            };
            CoSENode.prototype.isProcessed = function() {
              return processed;
            };
            module2.exports = CoSENode;
          },
          /* 6 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var FDLayout = __webpack_require__(0).FDLayout;
            var CoSEGraphManager = __webpack_require__(4);
            var CoSEGraph = __webpack_require__(3);
            var CoSENode = __webpack_require__(5);
            var CoSEEdge = __webpack_require__(2);
            var CoSEConstants = __webpack_require__(1);
            var FDLayoutConstants = __webpack_require__(0).FDLayoutConstants;
            var LayoutConstants = __webpack_require__(0).LayoutConstants;
            var Point2 = __webpack_require__(0).Point;
            var PointD = __webpack_require__(0).PointD;
            var Layout2 = __webpack_require__(0).Layout;
            var Integer = __webpack_require__(0).Integer;
            var IGeometry = __webpack_require__(0).IGeometry;
            var LGraph = __webpack_require__(0).LGraph;
            var Transform = __webpack_require__(0).Transform;
            function CoSELayout() {
              FDLayout.call(this);
              this.toBeTiled = {};
            }
            __name(CoSELayout, "CoSELayout");
            CoSELayout.prototype = Object.create(FDLayout.prototype);
            for (var prop in FDLayout) {
              CoSELayout[prop] = FDLayout[prop];
            }
            CoSELayout.prototype.newGraphManager = function() {
              var gm = new CoSEGraphManager(this);
              this.graphManager = gm;
              return gm;
            };
            CoSELayout.prototype.newGraph = function(vGraph) {
              return new CoSEGraph(null, this.graphManager, vGraph);
            };
            CoSELayout.prototype.newNode = function(vNode) {
              return new CoSENode(this.graphManager, vNode);
            };
            CoSELayout.prototype.newEdge = function(vEdge) {
              return new CoSEEdge(null, null, vEdge);
            };
            CoSELayout.prototype.initParameters = function() {
              FDLayout.prototype.initParameters.call(this, arguments);
              if (!this.isSubLayout) {
                if (CoSEConstants.DEFAULT_EDGE_LENGTH < 10) {
                  this.idealEdgeLength = 10;
                } else {
                  this.idealEdgeLength = CoSEConstants.DEFAULT_EDGE_LENGTH;
                }
                this.useSmartIdealEdgeLengthCalculation = CoSEConstants.DEFAULT_USE_SMART_IDEAL_EDGE_LENGTH_CALCULATION;
                this.springConstant = FDLayoutConstants.DEFAULT_SPRING_STRENGTH;
                this.repulsionConstant = FDLayoutConstants.DEFAULT_REPULSION_STRENGTH;
                this.gravityConstant = FDLayoutConstants.DEFAULT_GRAVITY_STRENGTH;
                this.compoundGravityConstant = FDLayoutConstants.DEFAULT_COMPOUND_GRAVITY_STRENGTH;
                this.gravityRangeFactor = FDLayoutConstants.DEFAULT_GRAVITY_RANGE_FACTOR;
                this.compoundGravityRangeFactor = FDLayoutConstants.DEFAULT_COMPOUND_GRAVITY_RANGE_FACTOR;
                this.prunedNodesAll = [];
                this.growTreeIterations = 0;
                this.afterGrowthIterations = 0;
                this.isTreeGrowing = false;
                this.isGrowthFinished = false;
                this.coolingCycle = 0;
                this.maxCoolingCycle = this.maxIterations / FDLayoutConstants.CONVERGENCE_CHECK_PERIOD;
                this.finalTemperature = FDLayoutConstants.CONVERGENCE_CHECK_PERIOD / this.maxIterations;
                this.coolingAdjuster = 1;
              }
            };
            CoSELayout.prototype.layout = function() {
              var createBendsAsNeeded = LayoutConstants.DEFAULT_CREATE_BENDS_AS_NEEDED;
              if (createBendsAsNeeded) {
                this.createBendpoints();
                this.graphManager.resetAllEdges();
              }
              this.level = 0;
              return this.classicLayout();
            };
            CoSELayout.prototype.classicLayout = function() {
              this.nodesWithGravity = this.calculateNodesToApplyGravitationTo();
              this.graphManager.setAllNodesToApplyGravitation(this.nodesWithGravity);
              this.calcNoOfChildrenForAllNodes();
              this.graphManager.calcLowestCommonAncestors();
              this.graphManager.calcInclusionTreeDepths();
              this.graphManager.getRoot().calcEstimatedSize();
              this.calcIdealEdgeLengths();
              if (!this.incremental) {
                var forest = this.getFlatForest();
                if (forest.length > 0) {
                  this.positionNodesRadially(forest);
                } else {
                  this.reduceTrees();
                  this.graphManager.resetAllNodesToApplyGravitation();
                  var allNodes = new Set(this.getAllNodes());
                  var intersection = this.nodesWithGravity.filter(function(x) {
                    return allNodes.has(x);
                  });
                  this.graphManager.setAllNodesToApplyGravitation(intersection);
                  this.positionNodesRandomly();
                }
              } else {
                if (CoSEConstants.TREE_REDUCTION_ON_INCREMENTAL) {
                  this.reduceTrees();
                  this.graphManager.resetAllNodesToApplyGravitation();
                  var allNodes = new Set(this.getAllNodes());
                  var intersection = this.nodesWithGravity.filter(function(x) {
                    return allNodes.has(x);
                  });
                  this.graphManager.setAllNodesToApplyGravitation(intersection);
                }
              }
              this.initSpringEmbedder();
              this.runSpringEmbedder();
              return true;
            };
            CoSELayout.prototype.tick = function() {
              this.totalIterations++;
              if (this.totalIterations === this.maxIterations && !this.isTreeGrowing && !this.isGrowthFinished) {
                if (this.prunedNodesAll.length > 0) {
                  this.isTreeGrowing = true;
                } else {
                  return true;
                }
              }
              if (this.totalIterations % FDLayoutConstants.CONVERGENCE_CHECK_PERIOD == 0 && !this.isTreeGrowing && !this.isGrowthFinished) {
                if (this.isConverged()) {
                  if (this.prunedNodesAll.length > 0) {
                    this.isTreeGrowing = true;
                  } else {
                    return true;
                  }
                }
                this.coolingCycle++;
                if (this.layoutQuality == 0) {
                  this.coolingAdjuster = this.coolingCycle;
                } else if (this.layoutQuality == 1) {
                  this.coolingAdjuster = this.coolingCycle / 3;
                }
                this.coolingFactor = Math.max(this.initialCoolingFactor - Math.pow(this.coolingCycle, Math.log(100 * (this.initialCoolingFactor - this.finalTemperature)) / Math.log(this.maxCoolingCycle)) / 100 * this.coolingAdjuster, this.finalTemperature);
                this.animationPeriod = Math.ceil(this.initialAnimationPeriod * Math.sqrt(this.coolingFactor));
              }
              if (this.isTreeGrowing) {
                if (this.growTreeIterations % 10 == 0) {
                  if (this.prunedNodesAll.length > 0) {
                    this.graphManager.updateBounds();
                    this.updateGrid();
                    this.growTree(this.prunedNodesAll);
                    this.graphManager.resetAllNodesToApplyGravitation();
                    var allNodes = new Set(this.getAllNodes());
                    var intersection = this.nodesWithGravity.filter(function(x) {
                      return allNodes.has(x);
                    });
                    this.graphManager.setAllNodesToApplyGravitation(intersection);
                    this.graphManager.updateBounds();
                    this.updateGrid();
                    this.coolingFactor = FDLayoutConstants.DEFAULT_COOLING_FACTOR_INCREMENTAL;
                  } else {
                    this.isTreeGrowing = false;
                    this.isGrowthFinished = true;
                  }
                }
                this.growTreeIterations++;
              }
              if (this.isGrowthFinished) {
                if (this.isConverged()) {
                  return true;
                }
                if (this.afterGrowthIterations % 10 == 0) {
                  this.graphManager.updateBounds();
                  this.updateGrid();
                }
                this.coolingFactor = FDLayoutConstants.DEFAULT_COOLING_FACTOR_INCREMENTAL * ((100 - this.afterGrowthIterations) / 100);
                this.afterGrowthIterations++;
              }
              var gridUpdateAllowed = !this.isTreeGrowing && !this.isGrowthFinished;
              var forceToNodeSurroundingUpdate = this.growTreeIterations % 10 == 1 && this.isTreeGrowing || this.afterGrowthIterations % 10 == 1 && this.isGrowthFinished;
              this.totalDisplacement = 0;
              this.graphManager.updateBounds();
              this.calcSpringForces();
              this.calcRepulsionForces(gridUpdateAllowed, forceToNodeSurroundingUpdate);
              this.calcGravitationalForces();
              this.moveNodes();
              this.animate();
              return false;
            };
            CoSELayout.prototype.getPositionsData = function() {
              var allNodes = this.graphManager.getAllNodes();
              var pData = {};
              for (var i = 0; i < allNodes.length; i++) {
                var rect = allNodes[i].rect;
                var id = allNodes[i].id;
                pData[id] = {
                  id,
                  x: rect.getCenterX(),
                  y: rect.getCenterY(),
                  w: rect.width,
                  h: rect.height
                };
              }
              return pData;
            };
            CoSELayout.prototype.runSpringEmbedder = function() {
              this.initialAnimationPeriod = 25;
              this.animationPeriod = this.initialAnimationPeriod;
              var layoutEnded = false;
              if (FDLayoutConstants.ANIMATE === "during") {
                this.emit("layoutstarted");
              } else {
                while (!layoutEnded) {
                  layoutEnded = this.tick();
                }
                this.graphManager.updateBounds();
              }
            };
            CoSELayout.prototype.calculateNodesToApplyGravitationTo = function() {
              var nodeList = [];
              var graph;
              var graphs = this.graphManager.getGraphs();
              var size = graphs.length;
              var i;
              for (i = 0; i < size; i++) {
                graph = graphs[i];
                graph.updateConnected();
                if (!graph.isConnected) {
                  nodeList = nodeList.concat(graph.getNodes());
                }
              }
              return nodeList;
            };
            CoSELayout.prototype.createBendpoints = function() {
              var edges = [];
              edges = edges.concat(this.graphManager.getAllEdges());
              var visited = /* @__PURE__ */ new Set();
              var i;
              for (i = 0; i < edges.length; i++) {
                var edge = edges[i];
                if (!visited.has(edge)) {
                  var source = edge.getSource();
                  var target = edge.getTarget();
                  if (source == target) {
                    edge.getBendpoints().push(new PointD());
                    edge.getBendpoints().push(new PointD());
                    this.createDummyNodesForBendpoints(edge);
                    visited.add(edge);
                  } else {
                    var edgeList = [];
                    edgeList = edgeList.concat(source.getEdgeListToNode(target));
                    edgeList = edgeList.concat(target.getEdgeListToNode(source));
                    if (!visited.has(edgeList[0])) {
                      if (edgeList.length > 1) {
                        var k;
                        for (k = 0; k < edgeList.length; k++) {
                          var multiEdge = edgeList[k];
                          multiEdge.getBendpoints().push(new PointD());
                          this.createDummyNodesForBendpoints(multiEdge);
                        }
                      }
                      edgeList.forEach(function(edge2) {
                        visited.add(edge2);
                      });
                    }
                  }
                }
                if (visited.size == edges.length) {
                  break;
                }
              }
            };
            CoSELayout.prototype.positionNodesRadially = function(forest) {
              var currentStartingPoint = new Point2(0, 0);
              var numberOfColumns = Math.ceil(Math.sqrt(forest.length));
              var height = 0;
              var currentY = 0;
              var currentX = 0;
              var point = new PointD(0, 0);
              for (var i = 0; i < forest.length; i++) {
                if (i % numberOfColumns == 0) {
                  currentX = 0;
                  currentY = height;
                  if (i != 0) {
                    currentY += CoSEConstants.DEFAULT_COMPONENT_SEPERATION;
                  }
                  height = 0;
                }
                var tree = forest[i];
                var centerNode = Layout2.findCenterOfTree(tree);
                currentStartingPoint.x = currentX;
                currentStartingPoint.y = currentY;
                point = CoSELayout.radialLayout(tree, centerNode, currentStartingPoint);
                if (point.y > height) {
                  height = Math.floor(point.y);
                }
                currentX = Math.floor(point.x + CoSEConstants.DEFAULT_COMPONENT_SEPERATION);
              }
              this.transform(new PointD(LayoutConstants.WORLD_CENTER_X - point.x / 2, LayoutConstants.WORLD_CENTER_Y - point.y / 2));
            };
            CoSELayout.radialLayout = function(tree, centerNode, startingPoint) {
              var radialSep = Math.max(this.maxDiagonalInTree(tree), CoSEConstants.DEFAULT_RADIAL_SEPARATION);
              CoSELayout.branchRadialLayout(centerNode, null, 0, 359, 0, radialSep);
              var bounds = LGraph.calculateBounds(tree);
              var transform = new Transform();
              transform.setDeviceOrgX(bounds.getMinX());
              transform.setDeviceOrgY(bounds.getMinY());
              transform.setWorldOrgX(startingPoint.x);
              transform.setWorldOrgY(startingPoint.y);
              for (var i = 0; i < tree.length; i++) {
                var node = tree[i];
                node.transform(transform);
              }
              var bottomRight = new PointD(bounds.getMaxX(), bounds.getMaxY());
              return transform.inverseTransformPoint(bottomRight);
            };
            CoSELayout.branchRadialLayout = function(node, parentOfNode, startAngle, endAngle, distance, radialSeparation) {
              var halfInterval = (endAngle - startAngle + 1) / 2;
              if (halfInterval < 0) {
                halfInterval += 180;
              }
              var nodeAngle = (halfInterval + startAngle) % 360;
              var teta = nodeAngle * IGeometry.TWO_PI / 360;
              var cos_teta = Math.cos(teta);
              var x_ = distance * Math.cos(teta);
              var y_ = distance * Math.sin(teta);
              node.setCenter(x_, y_);
              var neighborEdges = [];
              neighborEdges = neighborEdges.concat(node.getEdges());
              var childCount = neighborEdges.length;
              if (parentOfNode != null) {
                childCount--;
              }
              var branchCount = 0;
              var incEdgesCount = neighborEdges.length;
              var startIndex;
              var edges = node.getEdgesBetween(parentOfNode);
              while (edges.length > 1) {
                var temp = edges[0];
                edges.splice(0, 1);
                var index = neighborEdges.indexOf(temp);
                if (index >= 0) {
                  neighborEdges.splice(index, 1);
                }
                incEdgesCount--;
                childCount--;
              }
              if (parentOfNode != null) {
                startIndex = (neighborEdges.indexOf(edges[0]) + 1) % incEdgesCount;
              } else {
                startIndex = 0;
              }
              var stepAngle = Math.abs(endAngle - startAngle) / childCount;
              for (var i = startIndex; branchCount != childCount; i = ++i % incEdgesCount) {
                var currentNeighbor = neighborEdges[i].getOtherEnd(node);
                if (currentNeighbor == parentOfNode) {
                  continue;
                }
                var childStartAngle = (startAngle + branchCount * stepAngle) % 360;
                var childEndAngle = (childStartAngle + stepAngle) % 360;
                CoSELayout.branchRadialLayout(currentNeighbor, node, childStartAngle, childEndAngle, distance + radialSeparation, radialSeparation);
                branchCount++;
              }
            };
            CoSELayout.maxDiagonalInTree = function(tree) {
              var maxDiagonal = Integer.MIN_VALUE;
              for (var i = 0; i < tree.length; i++) {
                var node = tree[i];
                var diagonal = node.getDiagonal();
                if (diagonal > maxDiagonal) {
                  maxDiagonal = diagonal;
                }
              }
              return maxDiagonal;
            };
            CoSELayout.prototype.calcRepulsionRange = function() {
              return 2 * (this.level + 1) * this.idealEdgeLength;
            };
            CoSELayout.prototype.groupZeroDegreeMembers = function() {
              var self = this;
              var tempMemberGroups = {};
              this.memberGroups = {};
              this.idToDummyNode = {};
              var zeroDegree = [];
              var allNodes = this.graphManager.getAllNodes();
              for (var i = 0; i < allNodes.length; i++) {
                var node = allNodes[i];
                var parent = node.getParent();
                if (this.getNodeDegreeWithChildren(node) === 0 && (parent.id == void 0 || !this.getToBeTiled(parent))) {
                  zeroDegree.push(node);
                }
              }
              for (var i = 0; i < zeroDegree.length; i++) {
                var node = zeroDegree[i];
                var p_id = node.getParent().id;
                if (typeof tempMemberGroups[p_id] === "undefined") tempMemberGroups[p_id] = [];
                tempMemberGroups[p_id] = tempMemberGroups[p_id].concat(node);
              }
              Object.keys(tempMemberGroups).forEach(function(p_id2) {
                if (tempMemberGroups[p_id2].length > 1) {
                  var dummyCompoundId = "DummyCompound_" + p_id2;
                  self.memberGroups[dummyCompoundId] = tempMemberGroups[p_id2];
                  var parent2 = tempMemberGroups[p_id2][0].getParent();
                  var dummyCompound = new CoSENode(self.graphManager);
                  dummyCompound.id = dummyCompoundId;
                  dummyCompound.paddingLeft = parent2.paddingLeft || 0;
                  dummyCompound.paddingRight = parent2.paddingRight || 0;
                  dummyCompound.paddingBottom = parent2.paddingBottom || 0;
                  dummyCompound.paddingTop = parent2.paddingTop || 0;
                  self.idToDummyNode[dummyCompoundId] = dummyCompound;
                  var dummyParentGraph = self.getGraphManager().add(self.newGraph(), dummyCompound);
                  var parentGraph = parent2.getChild();
                  parentGraph.add(dummyCompound);
                  for (var i2 = 0; i2 < tempMemberGroups[p_id2].length; i2++) {
                    var node2 = tempMemberGroups[p_id2][i2];
                    parentGraph.remove(node2);
                    dummyParentGraph.add(node2);
                  }
                }
              });
            };
            CoSELayout.prototype.clearCompounds = function() {
              var childGraphMap = {};
              var idToNode = {};
              this.performDFSOnCompounds();
              for (var i = 0; i < this.compoundOrder.length; i++) {
                idToNode[this.compoundOrder[i].id] = this.compoundOrder[i];
                childGraphMap[this.compoundOrder[i].id] = [].concat(this.compoundOrder[i].getChild().getNodes());
                this.graphManager.remove(this.compoundOrder[i].getChild());
                this.compoundOrder[i].child = null;
              }
              this.graphManager.resetAllNodes();
              this.tileCompoundMembers(childGraphMap, idToNode);
            };
            CoSELayout.prototype.clearZeroDegreeMembers = function() {
              var self = this;
              var tiledZeroDegreePack = this.tiledZeroDegreePack = [];
              Object.keys(this.memberGroups).forEach(function(id) {
                var compoundNode = self.idToDummyNode[id];
                tiledZeroDegreePack[id] = self.tileNodes(self.memberGroups[id], compoundNode.paddingLeft + compoundNode.paddingRight);
                compoundNode.rect.width = tiledZeroDegreePack[id].width;
                compoundNode.rect.height = tiledZeroDegreePack[id].height;
              });
            };
            CoSELayout.prototype.repopulateCompounds = function() {
              for (var i = this.compoundOrder.length - 1; i >= 0; i--) {
                var lCompoundNode = this.compoundOrder[i];
                var id = lCompoundNode.id;
                var horizontalMargin = lCompoundNode.paddingLeft;
                var verticalMargin = lCompoundNode.paddingTop;
                this.adjustLocations(this.tiledMemberPack[id], lCompoundNode.rect.x, lCompoundNode.rect.y, horizontalMargin, verticalMargin);
              }
            };
            CoSELayout.prototype.repopulateZeroDegreeMembers = function() {
              var self = this;
              var tiledPack = this.tiledZeroDegreePack;
              Object.keys(tiledPack).forEach(function(id) {
                var compoundNode = self.idToDummyNode[id];
                var horizontalMargin = compoundNode.paddingLeft;
                var verticalMargin = compoundNode.paddingTop;
                self.adjustLocations(tiledPack[id], compoundNode.rect.x, compoundNode.rect.y, horizontalMargin, verticalMargin);
              });
            };
            CoSELayout.prototype.getToBeTiled = function(node) {
              var id = node.id;
              if (this.toBeTiled[id] != null) {
                return this.toBeTiled[id];
              }
              var childGraph = node.getChild();
              if (childGraph == null) {
                this.toBeTiled[id] = false;
                return false;
              }
              var children = childGraph.getNodes();
              for (var i = 0; i < children.length; i++) {
                var theChild = children[i];
                if (this.getNodeDegree(theChild) > 0) {
                  this.toBeTiled[id] = false;
                  return false;
                }
                if (theChild.getChild() == null) {
                  this.toBeTiled[theChild.id] = false;
                  continue;
                }
                if (!this.getToBeTiled(theChild)) {
                  this.toBeTiled[id] = false;
                  return false;
                }
              }
              this.toBeTiled[id] = true;
              return true;
            };
            CoSELayout.prototype.getNodeDegree = function(node) {
              var id = node.id;
              var edges = node.getEdges();
              var degree = 0;
              for (var i = 0; i < edges.length; i++) {
                var edge = edges[i];
                if (edge.getSource().id !== edge.getTarget().id) {
                  degree = degree + 1;
                }
              }
              return degree;
            };
            CoSELayout.prototype.getNodeDegreeWithChildren = function(node) {
              var degree = this.getNodeDegree(node);
              if (node.getChild() == null) {
                return degree;
              }
              var children = node.getChild().getNodes();
              for (var i = 0; i < children.length; i++) {
                var child = children[i];
                degree += this.getNodeDegreeWithChildren(child);
              }
              return degree;
            };
            CoSELayout.prototype.performDFSOnCompounds = function() {
              this.compoundOrder = [];
              this.fillCompexOrderByDFS(this.graphManager.getRoot().getNodes());
            };
            CoSELayout.prototype.fillCompexOrderByDFS = function(children) {
              for (var i = 0; i < children.length; i++) {
                var child = children[i];
                if (child.getChild() != null) {
                  this.fillCompexOrderByDFS(child.getChild().getNodes());
                }
                if (this.getToBeTiled(child)) {
                  this.compoundOrder.push(child);
                }
              }
            };
            CoSELayout.prototype.adjustLocations = function(organization, x, y, compoundHorizontalMargin, compoundVerticalMargin) {
              x += compoundHorizontalMargin;
              y += compoundVerticalMargin;
              var left = x;
              for (var i = 0; i < organization.rows.length; i++) {
                var row = organization.rows[i];
                x = left;
                var maxHeight = 0;
                for (var j = 0; j < row.length; j++) {
                  var lnode = row[j];
                  lnode.rect.x = x;
                  lnode.rect.y = y;
                  x += lnode.rect.width + organization.horizontalPadding;
                  if (lnode.rect.height > maxHeight) maxHeight = lnode.rect.height;
                }
                y += maxHeight + organization.verticalPadding;
              }
            };
            CoSELayout.prototype.tileCompoundMembers = function(childGraphMap, idToNode) {
              var self = this;
              this.tiledMemberPack = [];
              Object.keys(childGraphMap).forEach(function(id) {
                var compoundNode = idToNode[id];
                self.tiledMemberPack[id] = self.tileNodes(childGraphMap[id], compoundNode.paddingLeft + compoundNode.paddingRight);
                compoundNode.rect.width = self.tiledMemberPack[id].width;
                compoundNode.rect.height = self.tiledMemberPack[id].height;
              });
            };
            CoSELayout.prototype.tileNodes = function(nodes, minWidth) {
              var verticalPadding = CoSEConstants.TILING_PADDING_VERTICAL;
              var horizontalPadding = CoSEConstants.TILING_PADDING_HORIZONTAL;
              var organization = {
                rows: [],
                rowWidth: [],
                rowHeight: [],
                width: 0,
                height: minWidth,
                // assume minHeight equals to minWidth
                verticalPadding,
                horizontalPadding
              };
              nodes.sort(function(n1, n2) {
                if (n1.rect.width * n1.rect.height > n2.rect.width * n2.rect.height) return -1;
                if (n1.rect.width * n1.rect.height < n2.rect.width * n2.rect.height) return 1;
                return 0;
              });
              for (var i = 0; i < nodes.length; i++) {
                var lNode = nodes[i];
                if (organization.rows.length == 0) {
                  this.insertNodeToRow(organization, lNode, 0, minWidth);
                } else if (this.canAddHorizontal(organization, lNode.rect.width, lNode.rect.height)) {
                  this.insertNodeToRow(organization, lNode, this.getShortestRowIndex(organization), minWidth);
                } else {
                  this.insertNodeToRow(organization, lNode, organization.rows.length, minWidth);
                }
                this.shiftToLastRow(organization);
              }
              return organization;
            };
            CoSELayout.prototype.insertNodeToRow = function(organization, node, rowIndex, minWidth) {
              var minCompoundSize = minWidth;
              if (rowIndex == organization.rows.length) {
                var secondDimension = [];
                organization.rows.push(secondDimension);
                organization.rowWidth.push(minCompoundSize);
                organization.rowHeight.push(0);
              }
              var w = organization.rowWidth[rowIndex] + node.rect.width;
              if (organization.rows[rowIndex].length > 0) {
                w += organization.horizontalPadding;
              }
              organization.rowWidth[rowIndex] = w;
              if (organization.width < w) {
                organization.width = w;
              }
              var h = node.rect.height;
              if (rowIndex > 0) h += organization.verticalPadding;
              var extraHeight = 0;
              if (h > organization.rowHeight[rowIndex]) {
                extraHeight = organization.rowHeight[rowIndex];
                organization.rowHeight[rowIndex] = h;
                extraHeight = organization.rowHeight[rowIndex] - extraHeight;
              }
              organization.height += extraHeight;
              organization.rows[rowIndex].push(node);
            };
            CoSELayout.prototype.getShortestRowIndex = function(organization) {
              var r = -1;
              var min = Number.MAX_VALUE;
              for (var i = 0; i < organization.rows.length; i++) {
                if (organization.rowWidth[i] < min) {
                  r = i;
                  min = organization.rowWidth[i];
                }
              }
              return r;
            };
            CoSELayout.prototype.getLongestRowIndex = function(organization) {
              var r = -1;
              var max = Number.MIN_VALUE;
              for (var i = 0; i < organization.rows.length; i++) {
                if (organization.rowWidth[i] > max) {
                  r = i;
                  max = organization.rowWidth[i];
                }
              }
              return r;
            };
            CoSELayout.prototype.canAddHorizontal = function(organization, extraWidth, extraHeight) {
              var sri = this.getShortestRowIndex(organization);
              if (sri < 0) {
                return true;
              }
              var min = organization.rowWidth[sri];
              if (min + organization.horizontalPadding + extraWidth <= organization.width) return true;
              var hDiff = 0;
              if (organization.rowHeight[sri] < extraHeight) {
                if (sri > 0) hDiff = extraHeight + organization.verticalPadding - organization.rowHeight[sri];
              }
              var add_to_row_ratio;
              if (organization.width - min >= extraWidth + organization.horizontalPadding) {
                add_to_row_ratio = (organization.height + hDiff) / (min + extraWidth + organization.horizontalPadding);
              } else {
                add_to_row_ratio = (organization.height + hDiff) / organization.width;
              }
              hDiff = extraHeight + organization.verticalPadding;
              var add_new_row_ratio;
              if (organization.width < extraWidth) {
                add_new_row_ratio = (organization.height + hDiff) / extraWidth;
              } else {
                add_new_row_ratio = (organization.height + hDiff) / organization.width;
              }
              if (add_new_row_ratio < 1) add_new_row_ratio = 1 / add_new_row_ratio;
              if (add_to_row_ratio < 1) add_to_row_ratio = 1 / add_to_row_ratio;
              return add_to_row_ratio < add_new_row_ratio;
            };
            CoSELayout.prototype.shiftToLastRow = function(organization) {
              var longest = this.getLongestRowIndex(organization);
              var last = organization.rowWidth.length - 1;
              var row = organization.rows[longest];
              var node = row[row.length - 1];
              var diff = node.width + organization.horizontalPadding;
              if (organization.width - organization.rowWidth[last] > diff && longest != last) {
                row.splice(-1, 1);
                organization.rows[last].push(node);
                organization.rowWidth[longest] = organization.rowWidth[longest] - diff;
                organization.rowWidth[last] = organization.rowWidth[last] + diff;
                organization.width = organization.rowWidth[instance.getLongestRowIndex(organization)];
                var maxHeight = Number.MIN_VALUE;
                for (var i = 0; i < row.length; i++) {
                  if (row[i].height > maxHeight) maxHeight = row[i].height;
                }
                if (longest > 0) maxHeight += organization.verticalPadding;
                var prevTotal = organization.rowHeight[longest] + organization.rowHeight[last];
                organization.rowHeight[longest] = maxHeight;
                if (organization.rowHeight[last] < node.height + organization.verticalPadding) organization.rowHeight[last] = node.height + organization.verticalPadding;
                var finalTotal = organization.rowHeight[longest] + organization.rowHeight[last];
                organization.height += finalTotal - prevTotal;
                this.shiftToLastRow(organization);
              }
            };
            CoSELayout.prototype.tilingPreLayout = function() {
              if (CoSEConstants.TILE) {
                this.groupZeroDegreeMembers();
                this.clearCompounds();
                this.clearZeroDegreeMembers();
              }
            };
            CoSELayout.prototype.tilingPostLayout = function() {
              if (CoSEConstants.TILE) {
                this.repopulateZeroDegreeMembers();
                this.repopulateCompounds();
              }
            };
            CoSELayout.prototype.reduceTrees = function() {
              var prunedNodesAll = [];
              var containsLeaf = true;
              var node;
              while (containsLeaf) {
                var allNodes = this.graphManager.getAllNodes();
                var prunedNodesInStepTemp = [];
                containsLeaf = false;
                for (var i = 0; i < allNodes.length; i++) {
                  node = allNodes[i];
                  if (node.getEdges().length == 1 && !node.getEdges()[0].isInterGraph && node.getChild() == null) {
                    prunedNodesInStepTemp.push([node, node.getEdges()[0], node.getOwner()]);
                    containsLeaf = true;
                  }
                }
                if (containsLeaf == true) {
                  var prunedNodesInStep = [];
                  for (var j = 0; j < prunedNodesInStepTemp.length; j++) {
                    if (prunedNodesInStepTemp[j][0].getEdges().length == 1) {
                      prunedNodesInStep.push(prunedNodesInStepTemp[j]);
                      prunedNodesInStepTemp[j][0].getOwner().remove(prunedNodesInStepTemp[j][0]);
                    }
                  }
                  prunedNodesAll.push(prunedNodesInStep);
                  this.graphManager.resetAllNodes();
                  this.graphManager.resetAllEdges();
                }
              }
              this.prunedNodesAll = prunedNodesAll;
            };
            CoSELayout.prototype.growTree = function(prunedNodesAll) {
              var lengthOfPrunedNodesInStep = prunedNodesAll.length;
              var prunedNodesInStep = prunedNodesAll[lengthOfPrunedNodesInStep - 1];
              var nodeData;
              for (var i = 0; i < prunedNodesInStep.length; i++) {
                nodeData = prunedNodesInStep[i];
                this.findPlaceforPrunedNode(nodeData);
                nodeData[2].add(nodeData[0]);
                nodeData[2].add(nodeData[1], nodeData[1].source, nodeData[1].target);
              }
              prunedNodesAll.splice(prunedNodesAll.length - 1, 1);
              this.graphManager.resetAllNodes();
              this.graphManager.resetAllEdges();
            };
            CoSELayout.prototype.findPlaceforPrunedNode = function(nodeData) {
              var gridForPrunedNode;
              var nodeToConnect;
              var prunedNode = nodeData[0];
              if (prunedNode == nodeData[1].source) {
                nodeToConnect = nodeData[1].target;
              } else {
                nodeToConnect = nodeData[1].source;
              }
              var startGridX = nodeToConnect.startX;
              var finishGridX = nodeToConnect.finishX;
              var startGridY = nodeToConnect.startY;
              var finishGridY = nodeToConnect.finishY;
              var upNodeCount = 0;
              var downNodeCount = 0;
              var rightNodeCount = 0;
              var leftNodeCount = 0;
              var controlRegions = [upNodeCount, rightNodeCount, downNodeCount, leftNodeCount];
              if (startGridY > 0) {
                for (var i = startGridX; i <= finishGridX; i++) {
                  controlRegions[0] += this.grid[i][startGridY - 1].length + this.grid[i][startGridY].length - 1;
                }
              }
              if (finishGridX < this.grid.length - 1) {
                for (var i = startGridY; i <= finishGridY; i++) {
                  controlRegions[1] += this.grid[finishGridX + 1][i].length + this.grid[finishGridX][i].length - 1;
                }
              }
              if (finishGridY < this.grid[0].length - 1) {
                for (var i = startGridX; i <= finishGridX; i++) {
                  controlRegions[2] += this.grid[i][finishGridY + 1].length + this.grid[i][finishGridY].length - 1;
                }
              }
              if (startGridX > 0) {
                for (var i = startGridY; i <= finishGridY; i++) {
                  controlRegions[3] += this.grid[startGridX - 1][i].length + this.grid[startGridX][i].length - 1;
                }
              }
              var min = Integer.MAX_VALUE;
              var minCount;
              var minIndex;
              for (var j = 0; j < controlRegions.length; j++) {
                if (controlRegions[j] < min) {
                  min = controlRegions[j];
                  minCount = 1;
                  minIndex = j;
                } else if (controlRegions[j] == min) {
                  minCount++;
                }
              }
              if (minCount == 3 && min == 0) {
                if (controlRegions[0] == 0 && controlRegions[1] == 0 && controlRegions[2] == 0) {
                  gridForPrunedNode = 1;
                } else if (controlRegions[0] == 0 && controlRegions[1] == 0 && controlRegions[3] == 0) {
                  gridForPrunedNode = 0;
                } else if (controlRegions[0] == 0 && controlRegions[2] == 0 && controlRegions[3] == 0) {
                  gridForPrunedNode = 3;
                } else if (controlRegions[1] == 0 && controlRegions[2] == 0 && controlRegions[3] == 0) {
                  gridForPrunedNode = 2;
                }
              } else if (minCount == 2 && min == 0) {
                var random = Math.floor(Math.random() * 2);
                if (controlRegions[0] == 0 && controlRegions[1] == 0) {
                  ;
                  if (random == 0) {
                    gridForPrunedNode = 0;
                  } else {
                    gridForPrunedNode = 1;
                  }
                } else if (controlRegions[0] == 0 && controlRegions[2] == 0) {
                  if (random == 0) {
                    gridForPrunedNode = 0;
                  } else {
                    gridForPrunedNode = 2;
                  }
                } else if (controlRegions[0] == 0 && controlRegions[3] == 0) {
                  if (random == 0) {
                    gridForPrunedNode = 0;
                  } else {
                    gridForPrunedNode = 3;
                  }
                } else if (controlRegions[1] == 0 && controlRegions[2] == 0) {
                  if (random == 0) {
                    gridForPrunedNode = 1;
                  } else {
                    gridForPrunedNode = 2;
                  }
                } else if (controlRegions[1] == 0 && controlRegions[3] == 0) {
                  if (random == 0) {
                    gridForPrunedNode = 1;
                  } else {
                    gridForPrunedNode = 3;
                  }
                } else {
                  if (random == 0) {
                    gridForPrunedNode = 2;
                  } else {
                    gridForPrunedNode = 3;
                  }
                }
              } else if (minCount == 4 && min == 0) {
                var random = Math.floor(Math.random() * 4);
                gridForPrunedNode = random;
              } else {
                gridForPrunedNode = minIndex;
              }
              if (gridForPrunedNode == 0) {
                prunedNode.setCenter(nodeToConnect.getCenterX(), nodeToConnect.getCenterY() - nodeToConnect.getHeight() / 2 - FDLayoutConstants.DEFAULT_EDGE_LENGTH - prunedNode.getHeight() / 2);
              } else if (gridForPrunedNode == 1) {
                prunedNode.setCenter(nodeToConnect.getCenterX() + nodeToConnect.getWidth() / 2 + FDLayoutConstants.DEFAULT_EDGE_LENGTH + prunedNode.getWidth() / 2, nodeToConnect.getCenterY());
              } else if (gridForPrunedNode == 2) {
                prunedNode.setCenter(nodeToConnect.getCenterX(), nodeToConnect.getCenterY() + nodeToConnect.getHeight() / 2 + FDLayoutConstants.DEFAULT_EDGE_LENGTH + prunedNode.getHeight() / 2);
              } else {
                prunedNode.setCenter(nodeToConnect.getCenterX() - nodeToConnect.getWidth() / 2 - FDLayoutConstants.DEFAULT_EDGE_LENGTH - prunedNode.getWidth() / 2, nodeToConnect.getCenterY());
              }
            };
            module2.exports = CoSELayout;
          },
          /* 7 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var coseBase = {};
            coseBase.layoutBase = __webpack_require__(0);
            coseBase.CoSEConstants = __webpack_require__(1);
            coseBase.CoSEEdge = __webpack_require__(2);
            coseBase.CoSEGraph = __webpack_require__(3);
            coseBase.CoSEGraphManager = __webpack_require__(4);
            coseBase.CoSELayout = __webpack_require__(6);
            coseBase.CoSENode = __webpack_require__(5);
            module2.exports = coseBase;
          }
          /******/
        ])
      );
    });
  }
});

// ../../node_modules/.pnpm/cytoscape-cose-bilkent@4.1.0_cytoscape@3.31.0/node_modules/cytoscape-cose-bilkent/cytoscape-cose-bilkent.js
var require_cytoscape_cose_bilkent = __commonJS({
  "../../node_modules/.pnpm/cytoscape-cose-bilkent@4.1.0_cytoscape@3.31.0/node_modules/cytoscape-cose-bilkent/cytoscape-cose-bilkent.js"(exports, module) {
    "use strict";
    (/* @__PURE__ */ __name(function webpackUniversalModuleDefinition(root, factory) {
      if (typeof exports === "object" && typeof module === "object")
        module.exports = factory(require_cose_base());
      else if (typeof define === "function" && define.amd)
        define(["cose-base"], factory);
      else if (typeof exports === "object")
        exports["cytoscapeCoseBilkent"] = factory(require_cose_base());
      else
        root["cytoscapeCoseBilkent"] = factory(root["coseBase"]);
    }, "webpackUniversalModuleDefinition"))(exports, function(__WEBPACK_EXTERNAL_MODULE_0__) {
      return (
        /******/
        function(modules) {
          var installedModules = {};
          function __webpack_require__(moduleId) {
            if (installedModules[moduleId]) {
              return installedModules[moduleId].exports;
            }
            var module2 = installedModules[moduleId] = {
              /******/
              i: moduleId,
              /******/
              l: false,
              /******/
              exports: {}
              /******/
            };
            modules[moduleId].call(module2.exports, module2, module2.exports, __webpack_require__);
            module2.l = true;
            return module2.exports;
          }
          __name(__webpack_require__, "__webpack_require__");
          __webpack_require__.m = modules;
          __webpack_require__.c = installedModules;
          __webpack_require__.i = function(value) {
            return value;
          };
          __webpack_require__.d = function(exports2, name, getter) {
            if (!__webpack_require__.o(exports2, name)) {
              Object.defineProperty(exports2, name, {
                /******/
                configurable: false,
                /******/
                enumerable: true,
                /******/
                get: getter
                /******/
              });
            }
          };
          __webpack_require__.n = function(module2) {
            var getter = module2 && module2.__esModule ? (
              /******/
              /* @__PURE__ */ __name(function getDefault() {
                return module2["default"];
              }, "getDefault")
            ) : (
              /******/
              /* @__PURE__ */ __name(function getModuleExports() {
                return module2;
              }, "getModuleExports")
            );
            __webpack_require__.d(getter, "a", getter);
            return getter;
          };
          __webpack_require__.o = function(object, property) {
            return Object.prototype.hasOwnProperty.call(object, property);
          };
          __webpack_require__.p = "";
          return __webpack_require__(__webpack_require__.s = 1);
        }([
          /* 0 */
          /***/
          function(module2, exports2) {
            module2.exports = __WEBPACK_EXTERNAL_MODULE_0__;
          },
          /* 1 */
          /***/
          function(module2, exports2, __webpack_require__) {
            "use strict";
            var LayoutConstants = __webpack_require__(0).layoutBase.LayoutConstants;
            var FDLayoutConstants = __webpack_require__(0).layoutBase.FDLayoutConstants;
            var CoSEConstants = __webpack_require__(0).CoSEConstants;
            var CoSELayout = __webpack_require__(0).CoSELayout;
            var CoSENode = __webpack_require__(0).CoSENode;
            var PointD = __webpack_require__(0).layoutBase.PointD;
            var DimensionD2 = __webpack_require__(0).layoutBase.DimensionD;
            var defaults = {
              // Called on `layoutready`
              ready: /* @__PURE__ */ __name(function ready() {
              }, "ready"),
              // Called on `layoutstop`
              stop: /* @__PURE__ */ __name(function stop() {
              }, "stop"),
              // 'draft', 'default' or 'proof" 
              // - 'draft' fast cooling rate 
              // - 'default' moderate cooling rate 
              // - "proof" slow cooling rate
              quality: "default",
              // include labels in node dimensions
              nodeDimensionsIncludeLabels: false,
              // number of ticks per frame; higher is faster but more jerky
              refresh: 30,
              // Whether to fit the network view after when done
              fit: true,
              // Padding on fit
              padding: 10,
              // Whether to enable incremental mode
              randomize: true,
              // Node repulsion (non overlapping) multiplier
              nodeRepulsion: 4500,
              // Ideal edge (non nested) length
              idealEdgeLength: 50,
              // Divisor to compute edge forces
              edgeElasticity: 0.45,
              // Nesting factor (multiplier) to compute ideal edge length for nested edges
              nestingFactor: 0.1,
              // Gravity force (constant)
              gravity: 0.25,
              // Maximum number of iterations to perform
              numIter: 2500,
              // For enabling tiling
              tile: true,
              // Type of layout animation. The option set is {'during', 'end', false}
              animate: "end",
              // Duration for animate:end
              animationDuration: 500,
              // Represents the amount of the vertical space to put between the zero degree members during the tiling operation(can also be a function)
              tilingPaddingVertical: 10,
              // Represents the amount of the horizontal space to put between the zero degree members during the tiling operation(can also be a function)
              tilingPaddingHorizontal: 10,
              // Gravity range (constant) for compounds
              gravityRangeCompound: 1.5,
              // Gravity force (constant) for compounds
              gravityCompound: 1,
              // Gravity range (constant)
              gravityRange: 3.8,
              // Initial cooling factor for incremental layout
              initialEnergyOnIncremental: 0.5
            };
            function extend(defaults2, options) {
              var obj = {};
              for (var i in defaults2) {
                obj[i] = defaults2[i];
              }
              for (var i in options) {
                obj[i] = options[i];
              }
              return obj;
            }
            __name(extend, "extend");
            ;
            function _CoSELayout(_options) {
              this.options = extend(defaults, _options);
              getUserOptions(this.options);
            }
            __name(_CoSELayout, "_CoSELayout");
            var getUserOptions = /* @__PURE__ */ __name(function getUserOptions2(options) {
              if (options.nodeRepulsion != null) CoSEConstants.DEFAULT_REPULSION_STRENGTH = FDLayoutConstants.DEFAULT_REPULSION_STRENGTH = options.nodeRepulsion;
              if (options.idealEdgeLength != null) CoSEConstants.DEFAULT_EDGE_LENGTH = FDLayoutConstants.DEFAULT_EDGE_LENGTH = options.idealEdgeLength;
              if (options.edgeElasticity != null) CoSEConstants.DEFAULT_SPRING_STRENGTH = FDLayoutConstants.DEFAULT_SPRING_STRENGTH = options.edgeElasticity;
              if (options.nestingFactor != null) CoSEConstants.PER_LEVEL_IDEAL_EDGE_LENGTH_FACTOR = FDLayoutConstants.PER_LEVEL_IDEAL_EDGE_LENGTH_FACTOR = options.nestingFactor;
              if (options.gravity != null) CoSEConstants.DEFAULT_GRAVITY_STRENGTH = FDLayoutConstants.DEFAULT_GRAVITY_STRENGTH = options.gravity;
              if (options.numIter != null) CoSEConstants.MAX_ITERATIONS = FDLayoutConstants.MAX_ITERATIONS = options.numIter;
              if (options.gravityRange != null) CoSEConstants.DEFAULT_GRAVITY_RANGE_FACTOR = FDLayoutConstants.DEFAULT_GRAVITY_RANGE_FACTOR = options.gravityRange;
              if (options.gravityCompound != null) CoSEConstants.DEFAULT_COMPOUND_GRAVITY_STRENGTH = FDLayoutConstants.DEFAULT_COMPOUND_GRAVITY_STRENGTH = options.gravityCompound;
              if (options.gravityRangeCompound != null) CoSEConstants.DEFAULT_COMPOUND_GRAVITY_RANGE_FACTOR = FDLayoutConstants.DEFAULT_COMPOUND_GRAVITY_RANGE_FACTOR = options.gravityRangeCompound;
              if (options.initialEnergyOnIncremental != null) CoSEConstants.DEFAULT_COOLING_FACTOR_INCREMENTAL = FDLayoutConstants.DEFAULT_COOLING_FACTOR_INCREMENTAL = options.initialEnergyOnIncremental;
              if (options.quality == "draft") LayoutConstants.QUALITY = 0;
              else if (options.quality == "proof") LayoutConstants.QUALITY = 2;
              else LayoutConstants.QUALITY = 1;
              CoSEConstants.NODE_DIMENSIONS_INCLUDE_LABELS = FDLayoutConstants.NODE_DIMENSIONS_INCLUDE_LABELS = LayoutConstants.NODE_DIMENSIONS_INCLUDE_LABELS = options.nodeDimensionsIncludeLabels;
              CoSEConstants.DEFAULT_INCREMENTAL = FDLayoutConstants.DEFAULT_INCREMENTAL = LayoutConstants.DEFAULT_INCREMENTAL = !options.randomize;
              CoSEConstants.ANIMATE = FDLayoutConstants.ANIMATE = LayoutConstants.ANIMATE = options.animate;
              CoSEConstants.TILE = options.tile;
              CoSEConstants.TILING_PADDING_VERTICAL = typeof options.tilingPaddingVertical === "function" ? options.tilingPaddingVertical.call() : options.tilingPaddingVertical;
              CoSEConstants.TILING_PADDING_HORIZONTAL = typeof options.tilingPaddingHorizontal === "function" ? options.tilingPaddingHorizontal.call() : options.tilingPaddingHorizontal;
            }, "getUserOptions");
            _CoSELayout.prototype.run = function() {
              var ready;
              var frameId;
              var options = this.options;
              var idToLNode = this.idToLNode = {};
              var layout = this.layout = new CoSELayout();
              var self = this;
              self.stopped = false;
              this.cy = this.options.cy;
              this.cy.trigger({ type: "layoutstart", layout: this });
              var gm = layout.newGraphManager();
              this.gm = gm;
              var nodes = this.options.eles.nodes();
              var edges = this.options.eles.edges();
              this.root = gm.addRoot();
              this.processChildrenList(this.root, this.getTopMostNodes(nodes), layout);
              for (var i = 0; i < edges.length; i++) {
                var edge = edges[i];
                var sourceNode = this.idToLNode[edge.data("source")];
                var targetNode = this.idToLNode[edge.data("target")];
                if (sourceNode !== targetNode && sourceNode.getEdgesBetween(targetNode).length == 0) {
                  var e1 = gm.add(layout.newEdge(), sourceNode, targetNode);
                  e1.id = edge.id();
                }
              }
              var getPositions = /* @__PURE__ */ __name(function getPositions2(ele, i2) {
                if (typeof ele === "number") {
                  ele = i2;
                }
                var theId = ele.data("id");
                var lNode = self.idToLNode[theId];
                return {
                  x: lNode.getRect().getCenterX(),
                  y: lNode.getRect().getCenterY()
                };
              }, "getPositions");
              var iterateAnimated = /* @__PURE__ */ __name(function iterateAnimated2() {
                var afterReposition = /* @__PURE__ */ __name(function afterReposition2() {
                  if (options.fit) {
                    options.cy.fit(options.eles, options.padding);
                  }
                  if (!ready) {
                    ready = true;
                    self.cy.one("layoutready", options.ready);
                    self.cy.trigger({ type: "layoutready", layout: self });
                  }
                }, "afterReposition");
                var ticksPerFrame = self.options.refresh;
                var isDone;
                for (var i2 = 0; i2 < ticksPerFrame && !isDone; i2++) {
                  isDone = self.stopped || self.layout.tick();
                }
                if (isDone) {
                  if (layout.checkLayoutSuccess() && !layout.isSubLayout) {
                    layout.doPostLayout();
                  }
                  if (layout.tilingPostLayout) {
                    layout.tilingPostLayout();
                  }
                  layout.isLayoutFinished = true;
                  self.options.eles.nodes().positions(getPositions);
                  afterReposition();
                  self.cy.one("layoutstop", self.options.stop);
                  self.cy.trigger({ type: "layoutstop", layout: self });
                  if (frameId) {
                    cancelAnimationFrame(frameId);
                  }
                  ready = false;
                  return;
                }
                var animationData = self.layout.getPositionsData();
                options.eles.nodes().positions(function(ele, i3) {
                  if (typeof ele === "number") {
                    ele = i3;
                  }
                  if (!ele.isParent()) {
                    var theId = ele.id();
                    var pNode = animationData[theId];
                    var temp = ele;
                    while (pNode == null) {
                      pNode = animationData[temp.data("parent")] || animationData["DummyCompound_" + temp.data("parent")];
                      animationData[theId] = pNode;
                      temp = temp.parent()[0];
                      if (temp == void 0) {
                        break;
                      }
                    }
                    if (pNode != null) {
                      return {
                        x: pNode.x,
                        y: pNode.y
                      };
                    } else {
                      return {
                        x: ele.position("x"),
                        y: ele.position("y")
                      };
                    }
                  }
                });
                afterReposition();
                frameId = requestAnimationFrame(iterateAnimated2);
              }, "iterateAnimated");
              layout.addListener("layoutstarted", function() {
                if (self.options.animate === "during") {
                  frameId = requestAnimationFrame(iterateAnimated);
                }
              });
              layout.runLayout();
              if (this.options.animate !== "during") {
                self.options.eles.nodes().not(":parent").layoutPositions(self, self.options, getPositions);
                ready = false;
              }
              return this;
            };
            _CoSELayout.prototype.getTopMostNodes = function(nodes) {
              var nodesMap = {};
              for (var i = 0; i < nodes.length; i++) {
                nodesMap[nodes[i].id()] = true;
              }
              var roots = nodes.filter(function(ele, i2) {
                if (typeof ele === "number") {
                  ele = i2;
                }
                var parent = ele.parent()[0];
                while (parent != null) {
                  if (nodesMap[parent.id()]) {
                    return false;
                  }
                  parent = parent.parent()[0];
                }
                return true;
              });
              return roots;
            };
            _CoSELayout.prototype.processChildrenList = function(parent, children, layout) {
              var size = children.length;
              for (var i = 0; i < size; i++) {
                var theChild = children[i];
                var children_of_children = theChild.children();
                var theNode;
                var dimensions = theChild.layoutDimensions({
                  nodeDimensionsIncludeLabels: this.options.nodeDimensionsIncludeLabels
                });
                if (theChild.outerWidth() != null && theChild.outerHeight() != null) {
                  theNode = parent.add(new CoSENode(layout.graphManager, new PointD(theChild.position("x") - dimensions.w / 2, theChild.position("y") - dimensions.h / 2), new DimensionD2(parseFloat(dimensions.w), parseFloat(dimensions.h))));
                } else {
                  theNode = parent.add(new CoSENode(this.graphManager));
                }
                theNode.id = theChild.data("id");
                theNode.paddingLeft = parseInt(theChild.css("padding"));
                theNode.paddingTop = parseInt(theChild.css("padding"));
                theNode.paddingRight = parseInt(theChild.css("padding"));
                theNode.paddingBottom = parseInt(theChild.css("padding"));
                if (this.options.nodeDimensionsIncludeLabels) {
                  if (theChild.isParent()) {
                    var labelWidth = theChild.boundingBox({ includeLabels: true, includeNodes: false }).w;
                    var labelHeight = theChild.boundingBox({ includeLabels: true, includeNodes: false }).h;
                    var labelPos = theChild.css("text-halign");
                    theNode.labelWidth = labelWidth;
                    theNode.labelHeight = labelHeight;
                    theNode.labelPos = labelPos;
                  }
                }
                this.idToLNode[theChild.data("id")] = theNode;
                if (isNaN(theNode.rect.x)) {
                  theNode.rect.x = 0;
                }
                if (isNaN(theNode.rect.y)) {
                  theNode.rect.y = 0;
                }
                if (children_of_children != null && children_of_children.length > 0) {
                  var theNewGraph;
                  theNewGraph = layout.getGraphManager().add(layout.newGraph(), theNode);
                  this.processChildrenList(theNewGraph, children_of_children, layout);
                }
              }
            };
            _CoSELayout.prototype.stop = function() {
              this.stopped = true;
              return this;
            };
            var register = /* @__PURE__ */ __name(function register2(cytoscape3) {
              cytoscape3("layout", "cose-bilkent", _CoSELayout);
            }, "register");
            if (typeof cytoscape !== "undefined") {
              register(cytoscape);
            }
            module2.exports = register;
          }
          /******/
        ])
      );
    });
  }
});

// src/diagrams/mindmap/parser/mindmap.jison
var parser = function() {
  var o = /* @__PURE__ */ __name(function(k, v, o2, l) {
    for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v) ;
    return o2;
  }, "o"), $V0 = [1, 4], $V1 = [1, 13], $V2 = [1, 12], $V3 = [1, 15], $V4 = [1, 16], $V5 = [1, 20], $V6 = [1, 19], $V7 = [6, 7, 8], $V8 = [1, 26], $V9 = [1, 24], $Va = [1, 25], $Vb = [6, 7, 11], $Vc = [1, 6, 13, 15, 16, 19, 22], $Vd = [1, 33], $Ve = [1, 34], $Vf = [1, 6, 7, 11, 13, 15, 16, 19, 22];
  var parser2 = {
    trace: /* @__PURE__ */ __name(function trace() {
    }, "trace"),
    yy: {},
    symbols_: { "error": 2, "start": 3, "mindMap": 4, "spaceLines": 5, "SPACELINE": 6, "NL": 7, "MINDMAP": 8, "document": 9, "stop": 10, "EOF": 11, "statement": 12, "SPACELIST": 13, "node": 14, "ICON": 15, "CLASS": 16, "nodeWithId": 17, "nodeWithoutId": 18, "NODE_DSTART": 19, "NODE_DESCR": 20, "NODE_DEND": 21, "NODE_ID": 22, "$accept": 0, "$end": 1 },
    terminals_: { 2: "error", 6: "SPACELINE", 7: "NL", 8: "MINDMAP", 11: "EOF", 13: "SPACELIST", 15: "ICON", 16: "CLASS", 19: "NODE_DSTART", 20: "NODE_DESCR", 21: "NODE_DEND", 22: "NODE_ID" },
    productions_: [0, [3, 1], [3, 2], [5, 1], [5, 2], [5, 2], [4, 2], [4, 3], [10, 1], [10, 1], [10, 1], [10, 2], [10, 2], [9, 3], [9, 2], [12, 2], [12, 2], [12, 2], [12, 1], [12, 1], [12, 1], [12, 1], [12, 1], [14, 1], [14, 1], [18, 3], [17, 1], [17, 4]],
    performAction: /* @__PURE__ */ __name(function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
      var $0 = $$.length - 1;
      switch (yystate) {
        case 6:
        case 7:
          return yy;
          break;
        case 8:
          yy.getLogger().trace("Stop NL ");
          break;
        case 9:
          yy.getLogger().trace("Stop EOF ");
          break;
        case 11:
          yy.getLogger().trace("Stop NL2 ");
          break;
        case 12:
          yy.getLogger().trace("Stop EOF2 ");
          break;
        case 15:
          yy.getLogger().info("Node: ", $$[$0].id);
          yy.addNode($$[$0 - 1].length, $$[$0].id, $$[$0].descr, $$[$0].type);
          break;
        case 16:
          yy.getLogger().trace("Icon: ", $$[$0]);
          yy.decorateNode({ icon: $$[$0] });
          break;
        case 17:
        case 21:
          yy.decorateNode({ class: $$[$0] });
          break;
        case 18:
          yy.getLogger().trace("SPACELIST");
          break;
        case 19:
          yy.getLogger().trace("Node: ", $$[$0].id);
          yy.addNode(0, $$[$0].id, $$[$0].descr, $$[$0].type);
          break;
        case 20:
          yy.decorateNode({ icon: $$[$0] });
          break;
        case 25:
          yy.getLogger().trace("node found ..", $$[$0 - 2]);
          this.$ = { id: $$[$0 - 1], descr: $$[$0 - 1], type: yy.getType($$[$0 - 2], $$[$0]) };
          break;
        case 26:
          this.$ = { id: $$[$0], descr: $$[$0], type: yy.nodeType.DEFAULT };
          break;
        case 27:
          yy.getLogger().trace("node found ..", $$[$0 - 3]);
          this.$ = { id: $$[$0 - 3], descr: $$[$0 - 1], type: yy.getType($$[$0 - 2], $$[$0]) };
          break;
      }
    }, "anonymous"),
    table: [{ 3: 1, 4: 2, 5: 3, 6: [1, 5], 8: $V0 }, { 1: [3] }, { 1: [2, 1] }, { 4: 6, 6: [1, 7], 7: [1, 8], 8: $V0 }, { 6: $V1, 7: [1, 10], 9: 9, 12: 11, 13: $V2, 14: 14, 15: $V3, 16: $V4, 17: 17, 18: 18, 19: $V5, 22: $V6 }, o($V7, [2, 3]), { 1: [2, 2] }, o($V7, [2, 4]), o($V7, [2, 5]), { 1: [2, 6], 6: $V1, 12: 21, 13: $V2, 14: 14, 15: $V3, 16: $V4, 17: 17, 18: 18, 19: $V5, 22: $V6 }, { 6: $V1, 9: 22, 12: 11, 13: $V2, 14: 14, 15: $V3, 16: $V4, 17: 17, 18: 18, 19: $V5, 22: $V6 }, { 6: $V8, 7: $V9, 10: 23, 11: $Va }, o($Vb, [2, 22], { 17: 17, 18: 18, 14: 27, 15: [1, 28], 16: [1, 29], 19: $V5, 22: $V6 }), o($Vb, [2, 18]), o($Vb, [2, 19]), o($Vb, [2, 20]), o($Vb, [2, 21]), o($Vb, [2, 23]), o($Vb, [2, 24]), o($Vb, [2, 26], { 19: [1, 30] }), { 20: [1, 31] }, { 6: $V8, 7: $V9, 10: 32, 11: $Va }, { 1: [2, 7], 6: $V1, 12: 21, 13: $V2, 14: 14, 15: $V3, 16: $V4, 17: 17, 18: 18, 19: $V5, 22: $V6 }, o($Vc, [2, 14], { 7: $Vd, 11: $Ve }), o($Vf, [2, 8]), o($Vf, [2, 9]), o($Vf, [2, 10]), o($Vb, [2, 15]), o($Vb, [2, 16]), o($Vb, [2, 17]), { 20: [1, 35] }, { 21: [1, 36] }, o($Vc, [2, 13], { 7: $Vd, 11: $Ve }), o($Vf, [2, 11]), o($Vf, [2, 12]), { 21: [1, 37] }, o($Vb, [2, 25]), o($Vb, [2, 27])],
    defaultActions: { 2: [2, 1], 6: [2, 2] },
    parseError: /* @__PURE__ */ __name(function parseError(str, hash) {
      if (hash.recoverable) {
        this.trace(str);
      } else {
        var error = new Error(str);
        error.hash = hash;
        throw error;
      }
    }, "parseError"),
    parse: /* @__PURE__ */ __name(function parse(input) {
      var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, recovering = 0, TERROR = 2, EOF = 1;
      var args = lstack.slice.call(arguments, 1);
      var lexer2 = Object.create(this.lexer);
      var sharedState = { yy: {} };
      for (var k in this.yy) {
        if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
          sharedState.yy[k] = this.yy[k];
        }
      }
      lexer2.setInput(input, sharedState.yy);
      sharedState.yy.lexer = lexer2;
      sharedState.yy.parser = this;
      if (typeof lexer2.yylloc == "undefined") {
        lexer2.yylloc = {};
      }
      var yyloc = lexer2.yylloc;
      lstack.push(yyloc);
      var ranges = lexer2.options && lexer2.options.ranges;
      if (typeof sharedState.yy.parseError === "function") {
        this.parseError = sharedState.yy.parseError;
      } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
      }
      function popStack(n) {
        stack.length = stack.length - 2 * n;
        vstack.length = vstack.length - n;
        lstack.length = lstack.length - n;
      }
      __name(popStack, "popStack");
      function lex() {
        var token;
        token = tstack.pop() || lexer2.lex() || EOF;
        if (typeof token !== "number") {
          if (token instanceof Array) {
            tstack = token;
            token = tstack.pop();
          }
          token = self.symbols_[token] || token;
        }
        return token;
      }
      __name(lex, "lex");
      var symbol, preErrorSymbol, state, action, a, r, yyval = {}, p, len, newState, expected;
      while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
          action = this.defaultActions[state];
        } else {
          if (symbol === null || typeof symbol == "undefined") {
            symbol = lex();
          }
          action = table[state] && table[state][symbol];
        }
        if (typeof action === "undefined" || !action.length || !action[0]) {
          var errStr = "";
          expected = [];
          for (p in table[state]) {
            if (this.terminals_[p] && p > TERROR) {
              expected.push("'" + this.terminals_[p] + "'");
            }
          }
          if (lexer2.showPosition) {
            errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
          } else {
            errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
          }
          this.parseError(errStr, {
            text: lexer2.match,
            token: this.terminals_[symbol] || symbol,
            line: lexer2.yylineno,
            loc: yyloc,
            expected
          });
        }
        if (action[0] instanceof Array && action.length > 1) {
          throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
        }
        switch (action[0]) {
          case 1:
            stack.push(symbol);
            vstack.push(lexer2.yytext);
            lstack.push(lexer2.yylloc);
            stack.push(action[1]);
            symbol = null;
            if (!preErrorSymbol) {
              yyleng = lexer2.yyleng;
              yytext = lexer2.yytext;
              yylineno = lexer2.yylineno;
              yyloc = lexer2.yylloc;
              if (recovering > 0) {
                recovering--;
              }
            } else {
              symbol = preErrorSymbol;
              preErrorSymbol = null;
            }
            break;
          case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
              first_line: lstack[lstack.length - (len || 1)].first_line,
              last_line: lstack[lstack.length - 1].last_line,
              first_column: lstack[lstack.length - (len || 1)].first_column,
              last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
              yyval._$.range = [
                lstack[lstack.length - (len || 1)].range[0],
                lstack[lstack.length - 1].range[1]
              ];
            }
            r = this.performAction.apply(yyval, [
              yytext,
              yyleng,
              yylineno,
              sharedState.yy,
              action[1],
              vstack,
              lstack
            ].concat(args));
            if (typeof r !== "undefined") {
              return r;
            }
            if (len) {
              stack = stack.slice(0, -1 * len * 2);
              vstack = vstack.slice(0, -1 * len);
              lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
          case 3:
            return true;
        }
      }
      return true;
    }, "parse")
  };
  var lexer = /* @__PURE__ */ function() {
    var lexer2 = {
      EOF: 1,
      parseError: /* @__PURE__ */ __name(function parseError(str, hash) {
        if (this.yy.parser) {
          this.yy.parser.parseError(str, hash);
        } else {
          throw new Error(str);
        }
      }, "parseError"),
      // resets the lexer, sets new input
      setInput: /* @__PURE__ */ __name(function(input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = "";
        this.conditionStack = ["INITIAL"];
        this.yylloc = {
          first_line: 1,
          first_column: 0,
          last_line: 1,
          last_column: 0
        };
        if (this.options.ranges) {
          this.yylloc.range = [0, 0];
        }
        this.offset = 0;
        return this;
      }, "setInput"),
      // consumes and returns one char from the input
      input: /* @__PURE__ */ __name(function() {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno++;
          this.yylloc.last_line++;
        } else {
          this.yylloc.last_column++;
        }
        if (this.options.ranges) {
          this.yylloc.range[1]++;
        }
        this._input = this._input.slice(1);
        return ch;
      }, "input"),
      // unshifts one char (or a string) into the input
      unput: /* @__PURE__ */ __name(function(ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);
        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);
        if (lines.length - 1) {
          this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;
        this.yylloc = {
          first_line: this.yylloc.first_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.first_column,
          last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
        };
        if (this.options.ranges) {
          this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
      }, "unput"),
      // When called from action, caches matched text and appends it on next action
      more: /* @__PURE__ */ __name(function() {
        this._more = true;
        return this;
      }, "more"),
      // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
      reject: /* @__PURE__ */ __name(function() {
        if (this.options.backtrack_lexer) {
          this._backtrack = true;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
        return this;
      }, "reject"),
      // retain first n characters of the match
      less: /* @__PURE__ */ __name(function(n) {
        this.unput(this.match.slice(n));
      }, "less"),
      // displays already matched input, i.e. for error messages
      pastInput: /* @__PURE__ */ __name(function() {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
      }, "pastInput"),
      // displays upcoming input, i.e. for error messages
      upcomingInput: /* @__PURE__ */ __name(function() {
        var next2 = this.match;
        if (next2.length < 20) {
          next2 += this._input.substr(0, 20 - next2.length);
        }
        return (next2.substr(0, 20) + (next2.length > 20 ? "..." : "")).replace(/\n/g, "");
      }, "upcomingInput"),
      // displays the character position where the lexing error occurred, i.e. for error messages
      showPosition: /* @__PURE__ */ __name(function() {
        var pre = this.pastInput();
        var c = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c + "^";
      }, "showPosition"),
      // test the lexed token: return FALSE when not a match, otherwise return token
      test_match: /* @__PURE__ */ __name(function(match, indexed_rule) {
        var token, lines, backup;
        if (this.options.backtrack_lexer) {
          backup = {
            yylineno: this.yylineno,
            yylloc: {
              first_line: this.yylloc.first_line,
              last_line: this.last_line,
              first_column: this.yylloc.first_column,
              last_column: this.yylloc.last_column
            },
            yytext: this.yytext,
            match: this.match,
            matches: this.matches,
            matched: this.matched,
            yyleng: this.yyleng,
            offset: this.offset,
            _more: this._more,
            _input: this._input,
            yy: this.yy,
            conditionStack: this.conditionStack.slice(0),
            done: this.done
          };
          if (this.options.ranges) {
            backup.yylloc.range = this.yylloc.range.slice(0);
          }
        }
        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
          this.yylineno += lines.length;
        }
        this.yylloc = {
          first_line: this.yylloc.last_line,
          last_line: this.yylineno + 1,
          first_column: this.yylloc.last_column,
          last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
          this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
          this.done = false;
        }
        if (token) {
          return token;
        } else if (this._backtrack) {
          for (var k in backup) {
            this[k] = backup[k];
          }
          return false;
        }
        return false;
      }, "test_match"),
      // return next match in input
      next: /* @__PURE__ */ __name(function() {
        if (this.done) {
          return this.EOF;
        }
        if (!this._input) {
          this.done = true;
        }
        var token, match, tempMatch, index;
        if (!this._more) {
          this.yytext = "";
          this.match = "";
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
          tempMatch = this._input.match(this.rules[rules[i]]);
          if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
            match = tempMatch;
            index = i;
            if (this.options.backtrack_lexer) {
              token = this.test_match(tempMatch, rules[i]);
              if (token !== false) {
                return token;
              } else if (this._backtrack) {
                match = false;
                continue;
              } else {
                return false;
              }
            } else if (!this.options.flex) {
              break;
            }
          }
        }
        if (match) {
          token = this.test_match(match, rules[index]);
          if (token !== false) {
            return token;
          }
          return false;
        }
        if (this._input === "") {
          return this.EOF;
        } else {
          return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
            text: "",
            token: null,
            line: this.yylineno
          });
        }
      }, "next"),
      // return next match that has a token
      lex: /* @__PURE__ */ __name(function lex() {
        var r = this.next();
        if (r) {
          return r;
        } else {
          return this.lex();
        }
      }, "lex"),
      // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
      begin: /* @__PURE__ */ __name(function begin(condition) {
        this.conditionStack.push(condition);
      }, "begin"),
      // pop the previously active lexer condition state off the condition stack
      popState: /* @__PURE__ */ __name(function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
          return this.conditionStack.pop();
        } else {
          return this.conditionStack[0];
        }
      }, "popState"),
      // produce the lexer rule set which is active for the currently active lexer condition state
      _currentRules: /* @__PURE__ */ __name(function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
          return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
          return this.conditions["INITIAL"].rules;
        }
      }, "_currentRules"),
      // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
      topState: /* @__PURE__ */ __name(function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
          return this.conditionStack[n];
        } else {
          return "INITIAL";
        }
      }, "topState"),
      // alias for begin(condition)
      pushState: /* @__PURE__ */ __name(function pushState(condition) {
        this.begin(condition);
      }, "pushState"),
      // return the number of states currently on the stack
      stateStackSize: /* @__PURE__ */ __name(function stateStackSize() {
        return this.conditionStack.length;
      }, "stateStackSize"),
      options: { "case-insensitive": true },
      performAction: /* @__PURE__ */ __name(function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
        var YYSTATE = YY_START;
        switch ($avoiding_name_collisions) {
          case 0:
            yy.getLogger().trace("Found comment", yy_.yytext);
            return 6;
            break;
          case 1:
            return 8;
            break;
          case 2:
            this.begin("CLASS");
            break;
          case 3:
            this.popState();
            return 16;
            break;
          case 4:
            this.popState();
            break;
          case 5:
            yy.getLogger().trace("Begin icon");
            this.begin("ICON");
            break;
          case 6:
            yy.getLogger().trace("SPACELINE");
            return 6;
            break;
          case 7:
            return 7;
            break;
          case 8:
            return 15;
            break;
          case 9:
            yy.getLogger().trace("end icon");
            this.popState();
            break;
          case 10:
            yy.getLogger().trace("Exploding node");
            this.begin("NODE");
            return 19;
            break;
          case 11:
            yy.getLogger().trace("Cloud");
            this.begin("NODE");
            return 19;
            break;
          case 12:
            yy.getLogger().trace("Explosion Bang");
            this.begin("NODE");
            return 19;
            break;
          case 13:
            yy.getLogger().trace("Cloud Bang");
            this.begin("NODE");
            return 19;
            break;
          case 14:
            this.begin("NODE");
            return 19;
            break;
          case 15:
            this.begin("NODE");
            return 19;
            break;
          case 16:
            this.begin("NODE");
            return 19;
            break;
          case 17:
            this.begin("NODE");
            return 19;
            break;
          case 18:
            return 13;
            break;
          case 19:
            return 22;
            break;
          case 20:
            return 11;
            break;
          case 21:
            this.begin("NSTR2");
            break;
          case 22:
            return "NODE_DESCR";
            break;
          case 23:
            this.popState();
            break;
          case 24:
            yy.getLogger().trace("Starting NSTR");
            this.begin("NSTR");
            break;
          case 25:
            yy.getLogger().trace("description:", yy_.yytext);
            return "NODE_DESCR";
            break;
          case 26:
            this.popState();
            break;
          case 27:
            this.popState();
            yy.getLogger().trace("node end ))");
            return "NODE_DEND";
            break;
          case 28:
            this.popState();
            yy.getLogger().trace("node end )");
            return "NODE_DEND";
            break;
          case 29:
            this.popState();
            yy.getLogger().trace("node end ...", yy_.yytext);
            return "NODE_DEND";
            break;
          case 30:
            this.popState();
            yy.getLogger().trace("node end ((");
            return "NODE_DEND";
            break;
          case 31:
            this.popState();
            yy.getLogger().trace("node end (-");
            return "NODE_DEND";
            break;
          case 32:
            this.popState();
            yy.getLogger().trace("node end (-");
            return "NODE_DEND";
            break;
          case 33:
            this.popState();
            yy.getLogger().trace("node end ((");
            return "NODE_DEND";
            break;
          case 34:
            this.popState();
            yy.getLogger().trace("node end ((");
            return "NODE_DEND";
            break;
          case 35:
            yy.getLogger().trace("Long description:", yy_.yytext);
            return 20;
            break;
          case 36:
            yy.getLogger().trace("Long description:", yy_.yytext);
            return 20;
            break;
        }
      }, "anonymous"),
      rules: [/^(?:\s*%%.*)/i, /^(?:mindmap\b)/i, /^(?::::)/i, /^(?:.+)/i, /^(?:\n)/i, /^(?:::icon\()/i, /^(?:[\s]+[\n])/i, /^(?:[\n]+)/i, /^(?:[^\)]+)/i, /^(?:\))/i, /^(?:-\))/i, /^(?:\(-)/i, /^(?:\)\))/i, /^(?:\))/i, /^(?:\(\()/i, /^(?:\{\{)/i, /^(?:\()/i, /^(?:\[)/i, /^(?:[\s]+)/i, /^(?:[^\(\[\n\)\{\}]+)/i, /^(?:$)/i, /^(?:["][`])/i, /^(?:[^`"]+)/i, /^(?:[`]["])/i, /^(?:["])/i, /^(?:[^"]+)/i, /^(?:["])/i, /^(?:[\)]\))/i, /^(?:[\)])/i, /^(?:[\]])/i, /^(?:\}\})/i, /^(?:\(-)/i, /^(?:-\))/i, /^(?:\(\()/i, /^(?:\()/i, /^(?:[^\)\]\(\}]+)/i, /^(?:.+(?!\(\())/i],
      conditions: { "CLASS": { "rules": [3, 4], "inclusive": false }, "ICON": { "rules": [8, 9], "inclusive": false }, "NSTR2": { "rules": [22, 23], "inclusive": false }, "NSTR": { "rules": [25, 26], "inclusive": false }, "NODE": { "rules": [21, 24, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36], "inclusive": false }, "INITIAL": { "rules": [0, 1, 2, 5, 6, 7, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20], "inclusive": true } }
    };
    return lexer2;
  }();
  parser2.lexer = lexer;
  function Parser() {
    this.yy = {};
  }
  __name(Parser, "Parser");
  Parser.prototype = parser2;
  parser2.Parser = Parser;
  return new Parser();
}();
parser.parser = parser;
var mindmap_default = parser;

// src/diagrams/mindmap/mindmapDb.ts
var nodeType = {
  DEFAULT: 0,
  NO_BORDER: 0,
  ROUNDED_RECT: 1,
  RECT: 2,
  CIRCLE: 3,
  CLOUD: 4,
  BANG: 5,
  HEXAGON: 6
};
var MindmapDB = class {
  constructor() {
    this.nodes = [];
    this.count = 0;
    this.elements = {};
    this.getLogger = this.getLogger.bind(this);
    this.nodeType = nodeType;
    this.clear();
    this.getType = this.getType.bind(this);
    this.getMindmap = this.getMindmap.bind(this);
    this.getElementById = this.getElementById.bind(this);
    this.getParent = this.getParent.bind(this);
    this.getMindmap = this.getMindmap.bind(this);
    this.addNode = this.addNode.bind(this);
    this.decorateNode = this.decorateNode.bind(this);
  }
  static {
    __name(this, "MindmapDB");
  }
  clear() {
    this.nodes = [];
    this.count = 0;
    this.elements = {};
  }
  getParent(level) {
    for (let i = this.nodes.length - 1; i >= 0; i--) {
      if (this.nodes[i].level < level) {
        return this.nodes[i];
      }
    }
    return null;
  }
  getMindmap() {
    return this.nodes.length > 0 ? this.nodes[0] : null;
  }
  addNode(level, id, descr, type) {
    log.info("addNode", level, id, descr, type);
    const conf = getConfig();
    let padding = conf.mindmap?.padding ?? defaultConfig_default.mindmap.padding;
    switch (type) {
      case this.nodeType.ROUNDED_RECT:
      case this.nodeType.RECT:
      case this.nodeType.HEXAGON:
        padding *= 2;
        break;
    }
    const node = {
      id: this.count++,
      nodeId: sanitizeText(id, conf),
      level,
      descr: sanitizeText(descr, conf),
      type,
      children: [],
      width: conf.mindmap?.maxNodeWidth ?? defaultConfig_default.mindmap.maxNodeWidth,
      padding
    };
    const parent = this.getParent(level);
    if (parent) {
      parent.children.push(node);
      this.nodes.push(node);
    } else {
      if (this.nodes.length === 0) {
        this.nodes.push(node);
      } else {
        throw new Error(
          `There can be only one root. No parent could be found for ("${node.descr}")`
        );
      }
    }
  }
  getType(startStr, endStr) {
    log.debug("In get type", startStr, endStr);
    switch (startStr) {
      case "[":
        return this.nodeType.RECT;
      case "(":
        return endStr === ")" ? this.nodeType.ROUNDED_RECT : this.nodeType.CLOUD;
      case "((":
        return this.nodeType.CIRCLE;
      case ")":
        return this.nodeType.CLOUD;
      case "))":
        return this.nodeType.BANG;
      case "{{":
        return this.nodeType.HEXAGON;
      default:
        return this.nodeType.DEFAULT;
    }
  }
  setElementForId(id, element) {
    this.elements[id] = element;
  }
  getElementById(id) {
    return this.elements[id];
  }
  decorateNode(decoration) {
    if (!decoration) {
      return;
    }
    const config = getConfig();
    const node = this.nodes[this.nodes.length - 1];
    if (decoration.icon) {
      node.icon = sanitizeText(decoration.icon, config);
    }
    if (decoration.class) {
      node.class = sanitizeText(decoration.class, config);
    }
  }
  type2Str(type) {
    switch (type) {
      case this.nodeType.DEFAULT:
        return "no-border";
      case this.nodeType.RECT:
        return "rect";
      case this.nodeType.ROUNDED_RECT:
        return "rounded-rect";
      case this.nodeType.CIRCLE:
        return "circle";
      case this.nodeType.CLOUD:
        return "cloud";
      case this.nodeType.BANG:
        return "bang";
      case this.nodeType.HEXAGON:
        return "hexgon";
      // cspell: disable-line
      default:
        return "no-border";
    }
  }
  getLogger() {
    return log;
  }
};

// src/diagrams/mindmap/mindmapRenderer.ts
var import_cytoscape_cose_bilkent = __toESM(require_cytoscape_cose_bilkent(), 1);

// src/diagrams/mindmap/svgDraw.ts
var MAX_SECTIONS = 12;
var defaultBkg = /* @__PURE__ */ __name(function(db, elem, node, section) {
  const rd = 5;
  elem.append("path").attr("id", "node-" + node.id).attr("class", "node-bkg node-" + db.type2Str(node.type)).attr(
    "d",
    `M0 ${node.height - rd} v${-node.height + 2 * rd} q0,-5 5,-5 h${node.width - 2 * rd} q5,0 5,5 v${node.height - rd} H0 Z`
  );
  elem.append("line").attr("class", "node-line-" + section).attr("x1", 0).attr("y1", node.height).attr("x2", node.width).attr("y2", node.height);
}, "defaultBkg");
var rectBkg = /* @__PURE__ */ __name(function(db, elem, node) {
  elem.append("rect").attr("id", "node-" + node.id).attr("class", "node-bkg node-" + db.type2Str(node.type)).attr("height", node.height).attr("width", node.width);
}, "rectBkg");
var cloudBkg = /* @__PURE__ */ __name(function(db, elem, node) {
  const w = node.width;
  const h = node.height;
  const r1 = 0.15 * w;
  const r2 = 0.25 * w;
  const r3 = 0.35 * w;
  const r4 = 0.2 * w;
  elem.append("path").attr("id", "node-" + node.id).attr("class", "node-bkg node-" + db.type2Str(node.type)).attr(
    "d",
    `M0 0 a${r1},${r1} 0 0,1 ${w * 0.25},${-1 * w * 0.1}
      a${r3},${r3} 1 0,1 ${w * 0.4},${-1 * w * 0.1}
      a${r2},${r2} 1 0,1 ${w * 0.35},${1 * w * 0.2}

      a${r1},${r1} 1 0,1 ${w * 0.15},${1 * h * 0.35}
      a${r4},${r4} 1 0,1 ${-1 * w * 0.15},${1 * h * 0.65}

      a${r2},${r1} 1 0,1 ${-1 * w * 0.25},${w * 0.15}
      a${r3},${r3} 1 0,1 ${-1 * w * 0.5},${0}
      a${r1},${r1} 1 0,1 ${-1 * w * 0.25},${-1 * w * 0.15}

      a${r1},${r1} 1 0,1 ${-1 * w * 0.1},${-1 * h * 0.35}
      a${r4},${r4} 1 0,1 ${w * 0.1},${-1 * h * 0.65}

    H0 V0 Z`
  );
}, "cloudBkg");
var bangBkg = /* @__PURE__ */ __name(function(db, elem, node) {
  const w = node.width;
  const h = node.height;
  const r = 0.15 * w;
  elem.append("path").attr("id", "node-" + node.id).attr("class", "node-bkg node-" + db.type2Str(node.type)).attr(
    "d",
    `M0 0 a${r},${r} 1 0,0 ${w * 0.25},${-1 * h * 0.1}
      a${r},${r} 1 0,0 ${w * 0.25},${0}
      a${r},${r} 1 0,0 ${w * 0.25},${0}
      a${r},${r} 1 0,0 ${w * 0.25},${1 * h * 0.1}

      a${r},${r} 1 0,0 ${w * 0.15},${1 * h * 0.33}
      a${r * 0.8},${r * 0.8} 1 0,0 ${0},${1 * h * 0.34}
      a${r},${r} 1 0,0 ${-1 * w * 0.15},${1 * h * 0.33}

      a${r},${r} 1 0,0 ${-1 * w * 0.25},${h * 0.15}
      a${r},${r} 1 0,0 ${-1 * w * 0.25},${0}
      a${r},${r} 1 0,0 ${-1 * w * 0.25},${0}
      a${r},${r} 1 0,0 ${-1 * w * 0.25},${-1 * h * 0.15}

      a${r},${r} 1 0,0 ${-1 * w * 0.1},${-1 * h * 0.33}
      a${r * 0.8},${r * 0.8} 1 0,0 ${0},${-1 * h * 0.34}
      a${r},${r} 1 0,0 ${w * 0.1},${-1 * h * 0.33}

    H0 V0 Z`
  );
}, "bangBkg");
var circleBkg = /* @__PURE__ */ __name(function(db, elem, node) {
  elem.append("circle").attr("id", "node-" + node.id).attr("class", "node-bkg node-" + db.type2Str(node.type)).attr("r", node.width / 2);
}, "circleBkg");
function insertPolygonShape(parent, w, h, points, node) {
  return parent.insert("polygon", ":first-child").attr(
    "points",
    points.map(function(d) {
      return d.x + "," + d.y;
    }).join(" ")
  ).attr("transform", "translate(" + (node.width - w) / 2 + ", " + h + ")");
}
__name(insertPolygonShape, "insertPolygonShape");
var hexagonBkg = /* @__PURE__ */ __name(function(_db, elem, node) {
  const h = node.height;
  const f = 4;
  const m = h / f;
  const w = node.width - node.padding + 2 * m;
  const points = [
    { x: m, y: 0 },
    { x: w - m, y: 0 },
    { x: w, y: -h / 2 },
    { x: w - m, y: -h },
    { x: m, y: -h },
    { x: 0, y: -h / 2 }
  ];
  insertPolygonShape(elem, w, h, points, node);
}, "hexagonBkg");
var roundedRectBkg = /* @__PURE__ */ __name(function(db, elem, node) {
  elem.append("rect").attr("id", "node-" + node.id).attr("class", "node-bkg node-" + db.type2Str(node.type)).attr("height", node.height).attr("rx", node.padding).attr("ry", node.padding).attr("width", node.width);
}, "roundedRectBkg");
var drawNode = /* @__PURE__ */ __name(async function(db, elem, node, fullSection, conf) {
  const htmlLabels = conf.htmlLabels;
  const section = fullSection % (MAX_SECTIONS - 1);
  const nodeElem = elem.append("g");
  node.section = section;
  let sectionClass = "section-" + section;
  if (section < 0) {
    sectionClass += " section-root";
  }
  nodeElem.attr("class", (node.class ? node.class + " " : "") + "mindmap-node " + sectionClass);
  const bkgElem = nodeElem.append("g");
  const textElem = nodeElem.append("g");
  const description = node.descr.replace(/(<br\/*>)/g, "\n");
  await createText(
    textElem,
    description,
    {
      useHtmlLabels: htmlLabels,
      width: node.width,
      classes: "mindmap-node-label"
    },
    conf
  );
  if (!htmlLabels) {
    textElem.attr("dy", "1em").attr("alignment-baseline", "middle").attr("dominant-baseline", "middle").attr("text-anchor", "middle");
  }
  const bbox = textElem.node().getBBox();
  const [fontSize] = parseFontSize(conf.fontSize);
  node.height = bbox.height + fontSize * 1.1 * 0.5 + node.padding;
  node.width = bbox.width + 2 * node.padding;
  if (node.icon) {
    if (node.type === db.nodeType.CIRCLE) {
      node.height += 50;
      node.width += 50;
      const icon = nodeElem.append("foreignObject").attr("height", "50px").attr("width", node.width).attr("style", "text-align: center;");
      icon.append("div").attr("class", "icon-container").append("i").attr("class", "node-icon-" + section + " " + node.icon);
      textElem.attr(
        "transform",
        "translate(" + node.width / 2 + ", " + (node.height / 2 - 1.5 * node.padding) + ")"
      );
    } else {
      node.width += 50;
      const orgHeight = node.height;
      node.height = Math.max(orgHeight, 60);
      const heightDiff = Math.abs(node.height - orgHeight);
      const icon = nodeElem.append("foreignObject").attr("width", "60px").attr("height", node.height).attr("style", "text-align: center;margin-top:" + heightDiff / 2 + "px;");
      icon.append("div").attr("class", "icon-container").append("i").attr("class", "node-icon-" + section + " " + node.icon);
      textElem.attr(
        "transform",
        "translate(" + (25 + node.width / 2) + ", " + (heightDiff / 2 + node.padding / 2) + ")"
      );
    }
  } else {
    if (!htmlLabels) {
      const dx = node.width / 2;
      const dy = node.padding / 2;
      textElem.attr("transform", "translate(" + dx + ", " + dy + ")");
    } else {
      const dx = (node.width - bbox.width) / 2;
      const dy = (node.height - bbox.height) / 2;
      textElem.attr("transform", "translate(" + dx + ", " + dy + ")");
    }
  }
  switch (node.type) {
    case db.nodeType.DEFAULT:
      defaultBkg(db, bkgElem, node, section);
      break;
    case db.nodeType.ROUNDED_RECT:
      roundedRectBkg(db, bkgElem, node, section);
      break;
    case db.nodeType.RECT:
      rectBkg(db, bkgElem, node, section);
      break;
    case db.nodeType.CIRCLE:
      bkgElem.attr("transform", "translate(" + node.width / 2 + ", " + +node.height / 2 + ")");
      circleBkg(db, bkgElem, node, section);
      break;
    case db.nodeType.CLOUD:
      cloudBkg(db, bkgElem, node, section);
      break;
    case db.nodeType.BANG:
      bangBkg(db, bkgElem, node, section);
      break;
    case db.nodeType.HEXAGON:
      hexagonBkg(db, bkgElem, node, section);
      break;
  }
  db.setElementForId(node.id, nodeElem);
  return node.height;
}, "drawNode");
var positionNode = /* @__PURE__ */ __name(function(db, node) {
  const nodeElem = db.getElementById(node.id);
  const x = node.x || 0;
  const y = node.y || 0;
  nodeElem.attr("transform", "translate(" + x + "," + y + ")");
}, "positionNode");

// src/diagrams/mindmap/mindmapRenderer.ts
cytoscape2.use(import_cytoscape_cose_bilkent.default);
async function drawNodes(db, svg, mindmap, section, conf) {
  await drawNode(db, svg, mindmap, section, conf);
  if (mindmap.children) {
    await Promise.all(
      mindmap.children.map(
        (child, index) => drawNodes(db, svg, child, section < 0 ? index : section, conf)
      )
    );
  }
}
__name(drawNodes, "drawNodes");
function drawEdges(edgesEl, cy) {
  cy.edges().map((edge, id) => {
    const data = edge.data();
    if (edge[0]._private.bodyBounds) {
      const bounds = edge[0]._private.rscratch;
      log.trace("Edge: ", id, data);
      edgesEl.insert("path").attr(
        "d",
        `M ${bounds.startX},${bounds.startY} L ${bounds.midX},${bounds.midY} L${bounds.endX},${bounds.endY} `
      ).attr("class", "edge section-edge-" + data.section + " edge-depth-" + data.depth);
    }
  });
}
__name(drawEdges, "drawEdges");
function addNodes(mindmap, cy, conf, level) {
  cy.add({
    group: "nodes",
    data: {
      id: mindmap.id.toString(),
      labelText: mindmap.descr,
      height: mindmap.height,
      width: mindmap.width,
      level,
      nodeId: mindmap.id,
      padding: mindmap.padding,
      type: mindmap.type
    },
    position: {
      x: mindmap.x,
      y: mindmap.y
    }
  });
  if (mindmap.children) {
    mindmap.children.forEach((child) => {
      addNodes(child, cy, conf, level + 1);
      cy.add({
        group: "edges",
        data: {
          id: `${mindmap.id}_${child.id}`,
          source: mindmap.id,
          target: child.id,
          depth: level,
          section: child.section
        }
      });
    });
  }
}
__name(addNodes, "addNodes");
function layoutMindmap(node, conf) {
  return new Promise((resolve) => {
    const renderEl = select_default("body").append("div").attr("id", "cy").attr("style", "display:none");
    const cy = cytoscape2({
      container: document.getElementById("cy"),
      // container to render in
      style: [
        {
          selector: "edge",
          style: {
            "curve-style": "bezier"
          }
        }
      ]
    });
    renderEl.remove();
    addNodes(node, cy, conf, 0);
    cy.nodes().forEach(function(n) {
      n.layoutDimensions = () => {
        const data = n.data();
        return { w: data.width, h: data.height };
      };
    });
    cy.layout({
      name: "cose-bilkent",
      // @ts-ignore Types for cose-bilkent are not correct?
      quality: "proof",
      styleEnabled: false,
      animate: false
    }).run();
    cy.ready((e) => {
      log.info("Ready", e);
      resolve(cy);
    });
  });
}
__name(layoutMindmap, "layoutMindmap");
function positionNodes(db, cy) {
  cy.nodes().map((node, id) => {
    const data = node.data();
    data.x = node.position().x;
    data.y = node.position().y;
    positionNode(db, data);
    const el = db.getElementById(data.nodeId);
    log.info("id:", id, "Position: (", node.position().x, ", ", node.position().y, ")", data);
    el.attr(
      "transform",
      `translate(${node.position().x - data.width / 2}, ${node.position().y - data.height / 2})`
    );
    el.attr("attr", `apa-${id})`);
  });
}
__name(positionNodes, "positionNodes");
var draw = /* @__PURE__ */ __name(async (text, id, _version, diagObj) => {
  log.debug("Rendering mindmap diagram\n" + text);
  const db = diagObj.db;
  const mm = db.getMindmap();
  if (!mm) {
    return;
  }
  const conf = getConfig();
  conf.htmlLabels = false;
  const svg = selectSvgElement(id);
  const edgesElem = svg.append("g");
  edgesElem.attr("class", "mindmap-edges");
  const nodesElem = svg.append("g");
  nodesElem.attr("class", "mindmap-nodes");
  await drawNodes(db, nodesElem, mm, -1, conf);
  const cy = await layoutMindmap(mm, conf);
  drawEdges(edgesElem, cy);
  positionNodes(db, cy);
  setupGraphViewbox(
    void 0,
    svg,
    conf.mindmap?.padding ?? defaultConfig_default.mindmap.padding,
    conf.mindmap?.useMaxWidth ?? defaultConfig_default.mindmap.useMaxWidth
  );
}, "draw");
var mindmapRenderer_default = {
  draw
};

// src/diagrams/mindmap/styles.ts
var genSections = /* @__PURE__ */ __name((options) => {
  let sections = "";
  for (let i = 0; i < options.THEME_COLOR_LIMIT; i++) {
    options["lineColor" + i] = options["lineColor" + i] || options["cScaleInv" + i];
    if (is_dark_default(options["lineColor" + i])) {
      options["lineColor" + i] = lighten_default(options["lineColor" + i], 20);
    } else {
      options["lineColor" + i] = darken_default(options["lineColor" + i], 20);
    }
  }
  for (let i = 0; i < options.THEME_COLOR_LIMIT; i++) {
    const sw = "" + (17 - 3 * i);
    sections += `
    .section-${i - 1} rect, .section-${i - 1} path, .section-${i - 1} circle, .section-${i - 1} polygon, .section-${i - 1} path  {
      fill: ${options["cScale" + i]};
    }
    .section-${i - 1} text {
     fill: ${options["cScaleLabel" + i]};
    }
    .node-icon-${i - 1} {
      font-size: 40px;
      color: ${options["cScaleLabel" + i]};
    }
    .section-edge-${i - 1}{
      stroke: ${options["cScale" + i]};
    }
    .edge-depth-${i - 1}{
      stroke-width: ${sw};
    }
    .section-${i - 1} line {
      stroke: ${options["cScaleInv" + i]} ;
      stroke-width: 3;
    }

    .disabled, .disabled circle, .disabled text {
      fill: lightgray;
    }
    .disabled text {
      fill: #efefef;
    }
    `;
  }
  return sections;
}, "genSections");
var getStyles = /* @__PURE__ */ __name((options) => `
  .edge {
    stroke-width: 3;
  }
  ${genSections(options)}
  .section-root rect, .section-root path, .section-root circle, .section-root polygon  {
    fill: ${options.git0};
  }
  .section-root text {
    fill: ${options.gitBranchLabel0};
  }
  .icon-container {
    height:100%;
    display: flex;
    justify-content: center;
    align-items: center;
  }
  .edge {
    fill: none;
  }
  .mindmap-node-label {
    dy: 1em;
    alignment-baseline: middle;
    text-anchor: middle;
    dominant-baseline: middle;
    text-align: center;
  }
`, "getStyles");
var styles_default = getStyles;

// src/diagrams/mindmap/mindmap-definition.ts
var diagram = {
  get db() {
    return new MindmapDB();
  },
  renderer: mindmapRenderer_default,
  parser: mindmap_default,
  styles: styles_default
};
export {
  diagram
};
