"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.replaceAllFactory = exports.regexQuote = exports.replaceAll = exports.flatten = exports.unique = exports.clean = exports.cleanCopy = exports.isDefined = void 0;
function isDefined(a) {
    return a !== undefined;
}
exports.isDefined = isDefined;
/**
 * Remove any fields with an `undefined` value.
 * @param t - object to clean
 * @returns t
 */
function cleanCopy(t) {
    const r = { ...t };
    return clean(r);
}
exports.cleanCopy = cleanCopy;
/**
 * Remove any fields with an `undefined` value.
 * **MODIFIES THE OBJECT**
 * @param t - object to clean
 * @returns t
 */
function clean(t) {
    for (const prop in t) {
        if (t[prop] === undefined) {
            delete t[prop];
        }
    }
    return t;
}
exports.clean = clean;
function unique(a) {
    return [...new Set(a)];
}
exports.unique = unique;
function* flatten(i) {
    for (const v of i) {
        yield* v;
    }
}
exports.flatten = flatten;
function replaceAll(text, match, withText) {
    const fn = replaceAllFactory(match, withText);
    return fn(text);
}
exports.replaceAll = replaceAll;
/**
 *
 * @param text verbatim text to be inserted into a regexp
 * @returns text that can be used in a regexp.
 */
function regexQuote(text) {
    return text.replace(/([[\]\-+(){},|*.\\])/g, '\\$1');
}
exports.regexQuote = regexQuote;
/**
 * Factory to create a function that will replace all occurrences of `match` with `withText`
 * @param match - string to match
 * @param replaceWithText - the text to substitute.
 */
function replaceAllFactory(match, replaceWithText) {
    const r = RegExp(regexQuote(match), 'g');
    return (text) => text.replace(r, replaceWithText);
}
exports.replaceAllFactory = replaceAllFactory;
//# sourceMappingURL=util.js.map