"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.polyHrTime = exports.toMilliseconds = exports.createTimer = void 0;
const _hrTime = (process === null || process === void 0 ? void 0 : process.hrtime) || polyHrTime;
function createTimer(hrTimeFn = _hrTime) {
    let start = hrTimeFn();
    return {
        start() {
            start = hrTimeFn();
        },
        elapsed() {
            return toMilliseconds(hrTimeFn(start));
        },
    };
}
exports.createTimer = createTimer;
function toMilliseconds(t) {
    return (t[0] + t[1] * 1e-9) * 1000;
}
exports.toMilliseconds = toMilliseconds;
function polyHrTime(time) {
    const now = Date.now() - (time ? toMilliseconds(time) : 0);
    const inSeconds = now * 1.0e-3;
    const s = Math.floor(inSeconds);
    const n = (inSeconds - s) * 1.0e9;
    return [s, n];
}
exports.polyHrTime = polyHrTime;
//# sourceMappingURL=timer.js.map