/**
 * Expand a line into a set of characters.
 *
 * Example:
 * - `a-c` -> `<a,b,c>`
 * - `ac-` -> `<a,c,->`
 * - `-abz` -> `<-,a,b,z>`
 * - `\u0300-\u0308` -> `<accents>`
 *
 * @param line - set of characters
 * @param rangeChar - the character to indicate ranges, set to empty to not have ranges.
 */
export declare function expandCharacterSet(line: string, rangeChar?: string): Set<string>;
/**
 * Expands a range between two characters.
 * - `a <= b` -- `[a, b]`
 * - `a > b` -- `[]`
 * @param a - staring character
 * @param b - ending character
 * @returns array of unicode characters.
 */
export declare function expandRange(a: string, b: string): string[];
/**
 * Tries to find the different cases for a letter.
 * It can generate multiple forms:
 * - `ß` => `['ß', 'SS', 'ss']`
 * - `a` => `['a', 'A']`
 * - `A` => `['A', 'z']`
 * - `Å` => `['A', 'z']`
 * @param letter - the letter to generate upper and lower cases.
 * @param locale - the locale to use for changing case.
 * @returns the set of found cases.
 */
export declare function caseForms(letter: string, locale: string | string[] | undefined): string[];
/**
 * Generate the different normalized forms of the letters.
 * @param letter - letter to normalize.
 * @returns combined set of possible forms.
 */
export declare function accentForms(letter: string): Iterable<string>;
/**
 * Remove all accents.
 * @param characters - unicode characters
 * @returns characters with accents removed (if it was possible)
 */
export declare function stripAccents(characters: string): string;
/**
 * Remove all non accent characters from a string.
 * @param characters - characters with accents.
 * @returns - only the accents.
 */
export declare function stripNonAccents(characters: string): string;
//# sourceMappingURL=text.d.ts.map