"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecondChanceCache = void 0;
class SecondChanceCache {
    constructor(maxL0Size) {
        this.maxL0Size = maxL0Size;
        this.map0 = new Map();
        this.map1 = new Map();
    }
    has(key) {
        if (this.map0.has(key))
            return true;
        if (this.map1.has(key)) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            this.set(key, this.get1(key));
            return true;
        }
        return false;
    }
    get(key) {
        var _a;
        return (_a = this.map0.get(key)) !== null && _a !== void 0 ? _a : this.get1(key);
    }
    set(key, value) {
        if (this.map0.size >= this.maxL0Size && !this.map0.has(key)) {
            this.map1 = this.map0;
            this.map0 = new Map();
        }
        this.map0.set(key, value);
        return this;
    }
    get size() {
        return this.map0.size + this.map1.size;
    }
    get size0() {
        return this.map0.size;
    }
    get size1() {
        return this.map1.size;
    }
    clear() {
        this.map0.clear();
        this.map1.clear();
        return this;
    }
    get1(key) {
        if (this.map1.has(key)) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            const v = this.map1.get(key);
            this.map1.delete(key);
            this.set(key, v);
            return v;
        }
        return undefined;
    }
    toArray() {
        return [...this.map1, ...this.map0];
    }
}
exports.SecondChanceCache = SecondChanceCache;
//# sourceMappingURL=secondChanceCache.js.map