"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bufferLines = exports.buffer = void 0;
function* buffer(iter, bufferSize) {
    const buffer = [];
    for (const s of iter) {
        buffer.push(s);
        if (buffer.length >= bufferSize) {
            yield buffer;
            buffer.length = 0;
        }
    }
    if (buffer.length) {
        yield buffer;
        buffer.length = 0;
    }
}
exports.buffer = buffer;
function* bufferLines(iter, bufferSize, eol) {
    if (eol) {
        for (const s of buffer(iter, bufferSize)) {
            yield s.join('') + eol;
        }
    }
    else {
        for (const s of buffer(iter, bufferSize)) {
            yield s.join('');
        }
    }
}
exports.bufferLines = bufferLines;
//# sourceMappingURL=bufferLines.js.map