import { Sequence } from 'gensequence';
import { FindFullResult } from './find';
import { SuggestionCollector, SuggestionResult } from './suggestCollector';
import { SuggestionOptions } from './suggestions/genSuggestionsOptions';
import { PartialTrieOptions, TrieNode, TrieOptions, TrieRoot } from './TrieNode';
import { CompoundWordsMethod, WalkerIterator } from './walker';
export { CASE_INSENSITIVE_PREFIX, COMPOUND_FIX, defaultTrieOptions, FORBID_PREFIX, OPTIONAL_COMPOUND_FIX, } from './constants';
export { PartialTrieOptions, TrieOptions } from './TrieNode';
/** @deprecated */
export declare const COMPOUND = "+";
/** @deprecated */
export declare const OPTIONAL_COMPOUND = "*";
/** @deprecated */
export declare const NORMALIZED = "~";
/** @deprecated */
export declare const FORBID = "!";
export declare class Trie {
    readonly root: TrieRoot;
    private count?;
    private _options;
    readonly isLegacy: boolean;
    private hasForbidden;
    constructor(root: TrieRoot, count?: number | undefined);
    /**
     * Number of words in the Trie
     */
    size(): number;
    isSizeKnown(): boolean;
    get options(): TrieOptions;
    /**
     * @param text - text to find in the Trie
     * @param minCompoundLength - deprecated - allows words to be glued together
     */
    find(text: string, minCompoundLength?: boolean | number): TrieNode | undefined;
    /**
     *
     * @param text - text to search for
     * @param minCompoundLength - minimum word compound length
     * @deprecated - this method is no longer needed since compounding can be explicitly defined by the dictionary words.
     */
    findCompound(text: string, minCompoundLength?: number): TrieNode | undefined;
    findExact(text: string): TrieNode | undefined;
    has(word: string, minLegacyCompoundLength?: boolean | number): boolean;
    /**
     * Determine if a word is in the dictionary.
     * @param word - the exact word to search for - must be normalized.
     * @param caseSensitive - false means also searching a dictionary where the words were normalized to lower case and accents removed.
     * @returns true if the word was found and is not forbidden.
     */
    hasWord(word: string, caseSensitive: boolean): boolean;
    findWord(word: string, options?: FindWordOptions): FindFullResult;
    /**
     * Determine if a word is in the forbidden word list.
     * @param word the word to lookup.
     */
    isForbiddenWord(word: string): boolean;
    /**
     * Provides an ordered sequence of words with the prefix of text.
     */
    completeWord(text: string): Sequence<string>;
    /**
     * Suggest spellings for `text`.  The results are sorted by edit distance with changes near the beginning of a word having a greater impact.
     * @param text - the text to search for
     * @param maxNumSuggestions - the maximum number of suggestions to return.
     * @param compoundMethod - Use to control splitting words.
     * @param numChanges - the maximum number of changes allowed to text. This is an approximate value, since some changes cost less than others.
     *                      the lower the value, the faster results are returned. Values less than 4 are best.
     */
    suggest(text: string, options: SuggestionOptions): string[];
    /**
     * Suggest spellings for `text`.  The results are sorted by edit distance with changes near the beginning of a word having a greater impact.
     * The results include the word and adjusted edit cost.  This is useful for merging results from multiple tries.
     */
    suggestWithCost(text: string, options: SuggestionOptions): SuggestionResult[];
    /**
     * genSuggestions will generate suggestions and send them to `collector`. `collector` is responsible for returning the max acceptable cost.
     * Costs are measured in weighted changes. A cost of 100 is the same as 1 edit. Some edits are considered cheaper.
     * Returning a MaxCost < 0 will effectively cause the search for suggestions to stop.
     */
    genSuggestions(collector: SuggestionCollector, compoundMethod?: CompoundWordsMethod): void;
    /**
     * Returns an iterator that can be used to get all words in the trie. For some dictionaries, this can result in millions of words.
     */
    words(): Sequence<string>;
    /**
     * Allows iteration over the entire tree.
     * On the returned Iterator, calling .next(goDeeper: boolean), allows for controlling the depth.
     */
    iterate(): WalkerIterator;
    insert(word: string): this;
    private calcIsLegacy;
    static create(words: Iterable<string> | IterableIterator<string>, options?: PartialTrieOptions): Trie;
    private createFindOptions;
}
export interface FindWordOptions {
    caseSensitive?: boolean;
    useLegacyWordCompounds?: boolean | number;
}
//# sourceMappingURL=trie.d.ts.map