import { TrieNode } from '../../TrieNode';
export declare const JOIN_SEPARATOR = "+";
export declare const WORD_SEPARATOR = " ";
export interface YieldResult {
    text: string;
    node: TrieNode;
    depth: number;
}
export declare enum CompoundWordsMethod {
    /**
     * Do not compound words.
     */
    NONE = 0,
    /**
     * Create word compounds separated by spaces.
     */
    SEPARATE_WORDS = 1,
    /**
     * Create word compounds without separation.
     */
    JOIN_WORDS = 2
}
export declare type WalkerIterator = Generator<YieldResult, void, boolean | undefined>;
//# sourceMappingURL=walkerTypes.d.ts.map