"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.__testing__ = exports.hintedWalker = void 0;
const trie_util_1 = require("../../trie-util");
const walkerTypes_1 = require("./walkerTypes");
function hintedWalker(root, ignoreCase, hint, compoundingMethod, emitWordSeparator) {
    return hintedWalkerNext(root, ignoreCase, hint, compoundingMethod, emitWordSeparator);
}
exports.hintedWalker = hintedWalker;
/**
 * Walks the Trie and yields a value at each node.
 * next(goDeeper: boolean):
 */
function* hintedWalkerNext(root, ignoreCase, hint, compoundingMethod, emitWordSeparator = '') {
    const _compoundingMethod = compoundingMethod !== null && compoundingMethod !== void 0 ? compoundingMethod : walkerTypes_1.CompoundWordsMethod.NONE;
    const compoundCharacter = root.compoundCharacter;
    const noCaseCharacter = root.stripCaseAndAccentsPrefix;
    const rawRoots = [root, ignoreCase ? root.c.get(noCaseCharacter) : undefined].filter(trie_util_1.isDefined);
    const specialRootsPrefix = existMap([compoundCharacter, noCaseCharacter, root.forbiddenWordPrefix]);
    function filterRoot(root) {
        var _a;
        const children = (_a = root.c) === null || _a === void 0 ? void 0 : _a.entries();
        const c = children && [...children].filter(([v]) => !(v in specialRootsPrefix));
        return {
            c: c && new Map(c),
        };
    }
    const roots = rawRoots.map(filterRoot);
    const compoundRoots = rawRoots.map((r) => { var _a; return (_a = r.c) === null || _a === void 0 ? void 0 : _a.get(compoundCharacter); }).filter(trie_util_1.isDefined);
    const setOfCompoundRoots = new Set(compoundRoots);
    const rootsForCompoundMethods = roots.concat(compoundRoots);
    const compoundMethodRoots = {
        [walkerTypes_1.CompoundWordsMethod.NONE]: [],
        [walkerTypes_1.CompoundWordsMethod.JOIN_WORDS]: [...rootsForCompoundMethods.map((r) => [walkerTypes_1.JOIN_SEPARATOR, r])],
        [walkerTypes_1.CompoundWordsMethod.SEPARATE_WORDS]: [...rootsForCompoundMethods.map((r) => [walkerTypes_1.WORD_SEPARATOR, r])],
    };
    function* children(n, hintOffset) {
        if (n.c) {
            const h = hint.slice(hintOffset, hintOffset + 3) + hint.slice(Math.max(0, hintOffset - 2), hintOffset);
            const hints = new Set(h);
            const c = n.c;
            // First yield the hints
            yield* [...hints]
                .filter((a) => c.has(a))
                .map((letter) => ({
                letter,
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                node: c.get(letter),
                hintOffset: hintOffset + 1,
            }));
            // We don't want to suggest the compound character.
            hints.add(compoundCharacter);
            // Then yield everything else.
            yield* [...c]
                .filter((a) => !hints.has(a[0]))
                .map(([letter, node]) => ({
                letter,
                node,
                hintOffset: hintOffset + 1,
            }));
            if (c.has(compoundCharacter) && !setOfCompoundRoots.has(n)) {
                for (const compoundRoot of compoundRoots) {
                    for (const child of children(compoundRoot, hintOffset)) {
                        const { letter, node, hintOffset } = child;
                        yield { letter: emitWordSeparator + letter, node, hintOffset };
                    }
                }
            }
        }
        if (n.f) {
            yield* [...compoundMethodRoots[_compoundingMethod]].map(([letter, node]) => ({
                letter: letter,
                node,
                hintOffset,
            }));
        }
    }
    for (const root of roots) {
        let depth = 0;
        const stack = [];
        const stackText = [''];
        stack[depth] = children(root, depth);
        let ir;
        while (depth >= 0) {
            while (!(ir = stack[depth].next()).done) {
                const { letter: char, node, hintOffset } = ir.value;
                const text = stackText[depth] + char;
                const hinting = (yield { text, node, depth });
                if (hinting && hinting.goDeeper) {
                    depth++;
                    stackText[depth] = text;
                    stack[depth] = children(node, hintOffset);
                }
            }
            depth -= 1;
        }
    }
}
function existMap(values) {
    const m = Object.create(null);
    for (const v of values) {
        m[v] = true;
    }
    return m;
}
exports.__testing__ = {
    hintedWalkerNext,
};
//# sourceMappingURL=hintedWalker.js.map