"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSuggestionOptions = exports.defaultSuggestionOptions = exports.defaultGenSuggestionOptions = void 0;
const walker_1 = require("./walker");
exports.defaultGenSuggestionOptions = {
    compoundMethod: walker_1.CompoundWordsMethod.NONE,
    ignoreCase: true,
    changeLimit: 5,
};
exports.defaultSuggestionOptions = {
    ...exports.defaultGenSuggestionOptions,
    numSuggestions: 8,
    includeTies: true,
    timeout: 5000,
};
const keyMapOfGenSuggestionOptionsStrict = {
    changeLimit: 'changeLimit',
    compoundMethod: 'compoundMethod',
    ignoreCase: 'ignoreCase',
    compoundSeparator: 'compoundSeparator',
};
const keyMapOfSuggestionOptionsStrict = {
    ...keyMapOfGenSuggestionOptionsStrict,
    filter: 'filter',
    includeTies: 'includeTies',
    numSuggestions: 'numSuggestions',
    timeout: 'timeout',
    weightMap: 'weightMap',
};
/**
 * Create suggestion options using composition.
 * @param opts - partial options.
 * @returns Options - with defaults.
 */
function createSuggestionOptions(...opts) {
    const options = { ...exports.defaultSuggestionOptions };
    const keys = Object.keys(keyMapOfSuggestionOptionsStrict);
    for (const opt of opts) {
        for (const key of keys) {
            assign(options, opt, key);
        }
    }
    return options;
}
exports.createSuggestionOptions = createSuggestionOptions;
function assign(dest, src, k) {
    var _a;
    dest[k] = (_a = src[k]) !== null && _a !== void 0 ? _a : dest[k];
}
//# sourceMappingURL=genSuggestionsOptions.js.map