import { WeightMap } from '..';
import { CompoundWordsMethod } from './walker';
export interface GenSuggestionOptionsStrict {
    /**
     * Controls forcing compound words.
     * @default CompoundWordsMethod.NONE
     */
    compoundMethod?: CompoundWordsMethod;
    /**
     * ignore case when searching.
     */
    ignoreCase: boolean;
    /**
     * Maximum number of "edits" allowed.
     * 3 is a good number. Above 5 can be very slow.
     */
    changeLimit: number;
    /**
     * Inserts a compound character between compounded word segments.
     * @default ""
     */
    compoundSeparator?: string;
}
export declare type GenSuggestionOptions = Partial<GenSuggestionOptionsStrict>;
export interface SuggestionOptionsStrict extends GenSuggestionOptionsStrict {
    /**
     * Maximum number of suggestions to make.
     */
    numSuggestions: number;
    /**
     * Allow ties when making suggestions.
     * if `true` it is possible to have more than `numSuggestions`.
     */
    includeTies: boolean;
    /**
     * Time alloted in milliseconds to generate suggestions.
     */
    timeout: number;
    /**
     * Optional filter function.
     * return true to keep the candidate.
     */
    filter?: (word: string, cost: number) => boolean;
    /**
     * Apply weights to improve the suggestions.
     */
    weightMap?: WeightMap;
}
export declare type SuggestionOptions = Partial<SuggestionOptionsStrict>;
export declare const defaultGenSuggestionOptions: GenSuggestionOptionsStrict;
export declare const defaultSuggestionOptions: SuggestionOptionsStrict;
/**
 * Create suggestion options using composition.
 * @param opts - partial options.
 * @returns Options - with defaults.
 */
export declare function createSuggestionOptions(...opts: SuggestionOptions[]): SuggestionOptionsStrict;
//# sourceMappingURL=genSuggestionsOptions.d.ts.map