export interface LocaleInfo {
    locale: string;
    language: string;
    country?: string | undefined;
}
export declare class Locale {
    readonly _raw: string;
    readonly _locale: string;
    constructor(locale: string);
    get locale(): string;
    localInfo(): LocaleInfo | undefined;
    isValid(): boolean;
    toJSON(): string;
    toString(): string;
}
/**
 * Attempt to normalize a locale.
 * @param locale a locale string
 */
export declare function normalizeLocale(locale: string): string;
export declare function isStandardLocale(locale: string): boolean;
export declare function lookupLocaleInfo(locale: string): LocaleInfo | undefined;
export declare function parseLocale(locales: string | string[]): Locale[];
//# sourceMappingURL=locale.d.ts.map