"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.splitMap = exports.calcCostsForAccentedLetters = exports.parseAccents = exports.calcFirstCharacterReplace = exports.calcFirstCharacterReplaceDefs = exports.parseAlphabetCaps = exports.parseAlphabet = void 0;
const cspell_pipe_1 = require("@cspell/cspell-pipe");
const operators_1 = require("gensequence/dist/operators");
const text_1 = require("../utils/text");
const util_1 = require("../utils/util");
const mapHunspellInformation_1 = require("./mapHunspellInformation");
function parseAlphabet(cs, locale, editCost) {
    const { cost, penalty } = cs;
    const characters = (0, text_1.expandCharacterSet)(cs.characters);
    const charForms = [
        ...(0, cspell_pipe_1.pipeSync)(characters, (0, cspell_pipe_1.opMap)((c) => (0, text_1.caseForms)(c, locale).sort())),
    ];
    const alphabet = (0, mapHunspellInformation_1.joinLetters)([
        ...(0, cspell_pipe_1.pipeSync)(charForms, (0, cspell_pipe_1.opFlatten)(), (0, cspell_pipe_1.opMap)((letter) => (0, text_1.accentForms)(letter)), (0, cspell_pipe_1.opFlatten)(), (0, cspell_pipe_1.opUnique)()),
    ].sort());
    const sugAlpha = (0, util_1.clean)({
        map: alphabet,
        replace: cost,
        insDel: cost,
        swap: cost,
        penalty,
    });
    return [
        sugAlpha,
        parseAlphabetCaps(cs.characters, locale, editCost),
        ...calcCostsForAccentedLetters(alphabet, locale, editCost),
    ];
}
exports.parseAlphabet = parseAlphabet;
function parseAlphabetCaps(alphabet, locale, editCost) {
    const characters = (0, text_1.expandCharacterSet)(alphabet);
    const charForms = [
        ...(0, cspell_pipe_1.pipeSync)(characters, (0, cspell_pipe_1.opMap)((c) => (0, text_1.caseForms)(c, locale).sort())),
    ];
    const caps = charForms.map((a) => (0, mapHunspellInformation_1.joinLetters)(a)).join('|');
    const sugCaps = {
        map: caps,
        replace: editCost.capsCosts,
    };
    return sugCaps;
}
exports.parseAlphabetCaps = parseAlphabetCaps;
function calcFirstCharacterReplaceDefs(alphabets, editCost) {
    return alphabets.map((cs) => calcFirstCharacterReplace(cs, editCost));
}
exports.calcFirstCharacterReplaceDefs = calcFirstCharacterReplaceDefs;
function calcFirstCharacterReplace(cs, editCost) {
    const mapOfFirstLetters = [
        ...(0, cspell_pipe_1.pipeSync)((0, text_1.expandCharacterSet)(cs.characters), (0, cspell_pipe_1.opUnique)(), (0, cspell_pipe_1.opMap)((letter) => `(^${letter})`)),
    ]
        .sort()
        .join('') + '(^)';
    const penalty = editCost.firstLetterPenalty;
    // Make it a bit cheaper so it will match
    const cost = cs.cost - penalty;
    return {
        map: mapOfFirstLetters,
        replace: cost,
        penalty: penalty * 2,
    };
}
exports.calcFirstCharacterReplace = calcFirstCharacterReplace;
function parseAccents(cs, _editCost) {
    const { cost, penalty } = cs;
    const accents = (0, mapHunspellInformation_1.joinLetters)([
        ...(0, cspell_pipe_1.pipeSync)((0, text_1.expandCharacterSet)(cs.characters), (0, operators_1.map)((char) => (0, text_1.stripNonAccents)(char))),
    ]);
    if (!accents)
        return undefined;
    return (0, util_1.clean)({
        map: accents,
        replace: cost,
        insDel: cost,
        penalty,
    });
}
exports.parseAccents = parseAccents;
function calcCostsForAccentedLetters(simpleMap, locale, costs) {
    const charactersWithAccents = [
        ...(0, cspell_pipe_1.pipeSync)(splitMap(simpleMap), (0, cspell_pipe_1.opMap)((char) => (0, text_1.caseForms)(char, locale)), (0, cspell_pipe_1.opFlatten)(), (0, cspell_pipe_1.opMap)((char) => [...(0, text_1.accentForms)(char)]), (0, cspell_pipe_1.opFilter)((forms) => forms.length > 1)),
    ];
    const characters = (0, cspell_pipe_1.pipeSync)(charactersWithAccents, (0, cspell_pipe_1.opMap)((forms) => new Set([...forms, ...forms.map((char) => (0, text_1.stripAccents)(char))])), (0, cspell_pipe_1.opMap)((forms) => [...forms].sort()), (0, cspell_pipe_1.opFilter)((forms) => forms.length > 1), (0, cspell_pipe_1.opMap)(mapHunspellInformation_1.joinLetters), (0, cspell_pipe_1.opUnique)());
    const replaceAccentMap = [...characters].join('|');
    const cost = costs.accentCosts;
    const costToReplaceAccent = !replaceAccentMap ? [] : [{ map: replaceAccentMap, replace: cost }];
    const normalizeMap = charactersWithAccents
        .map((a) => a.sort())
        .map(mapHunspellInformation_1.joinLetters)
        .join('|');
    const costToNormalizeAccent = !normalizeMap ? [] : [{ map: normalizeMap, replace: 0 }];
    return [...costToReplaceAccent, ...costToNormalizeAccent];
}
exports.calcCostsForAccentedLetters = calcCostsForAccentedLetters;
/**
 * Splits a simple map string into its parts.
 * - `abc` => `a`, `b`, `c`
 * - `a(bc)` => `a`, `bc`
 * @param map - string of characters
 */
function* splitMap(map) {
    let seq = '';
    let mode = 0;
    for (const char of map) {
        if (mode && char === ')') {
            yield seq;
            mode = 0;
            continue;
        }
        if (mode) {
            seq += char;
            continue;
        }
        if (char === '(') {
            mode = 1;
            seq = '';
            continue;
        }
        yield char;
    }
}
exports.splitMap = splitMap;
//# sourceMappingURL=mapToSuggestionCostDef.js.map