import type { HunspellCosts, HunspellInformation } from '../models/DictionaryInformation';
import { Locale } from '../models/locale';
import type { SuggestionCostMapDef } from '../models/suggestionCostsDef';
import { splitMap } from './mapToSuggestionCostDef';
interface Costs extends Required<HunspellCosts> {
    locale?: string[] | undefined;
}
export declare function hunspellInformationToSuggestionCostDef(hunInfo: HunspellInformation, locales: Locale[] | undefined): SuggestionCostMapDef[];
declare function calcCosts(costs?: HunspellCosts, locale?: Locale[] | undefined): Costs;
declare function affMap(line: string, costs: Costs): SuggestionCostMapDef | undefined;
declare function affTry(line: string, costs: Costs): SuggestionCostMapDef[] | undefined;
declare function affTryFirstCharacterReplace(line: string, costs: Costs): SuggestionCostMapDef | undefined;
declare function affNoTry(line: string, costs: Costs): SuggestionCostMapDef | undefined;
declare function affRepConv(line: string, costs: Costs): SuggestionCostMapDef | undefined;
declare function affKey(line: string, costs: Costs): SuggestionCostMapDef | undefined;
declare function affKeyCaps(line: string, costs: Costs): SuggestionCostMapDef | undefined;
declare function affMapCaps(line: string, costs: Costs): SuggestionCostMapDef | undefined;
declare function affTryAccents(line: string, costs: Costs): SuggestionCostMapDef[] | undefined;
declare function affMapAccents(line: string, costs: Costs): SuggestionCostMapDef[] | undefined;
/**
 * Bring letters / strings together.
 * - `['a', 'b'] => 'ab'`
 * - `['a', 'bc'] => 'a(bc)'`
 * @param letters - letters to join
 */
export declare function joinLetters(letters: string[]): string;
export declare const __testing__: {
    affKey: typeof affKey;
    affKeyCaps: typeof affKeyCaps;
    affMap: typeof affMap;
    affMapAccents: typeof affMapAccents;
    affMapCaps: typeof affMapCaps;
    affNoTry: typeof affNoTry;
    affRepConv: typeof affRepConv;
    affTry: typeof affTry;
    affTryAccents: typeof affTryAccents;
    affTryFirstCharacterReplace: typeof affTryFirstCharacterReplace;
    calcCosts: typeof calcCosts;
    split: typeof splitMap;
};
export {};
//# sourceMappingURL=mapHunspellInformation.d.ts.map