"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapDictionaryInformationToAdjustment = exports.mapDictionaryInformation = void 0;
const cspell_pipe_1 = require("@cspell/cspell-pipe");
const locale_1 = require("../models/locale");
const util_1 = require("../utils/util");
const mapCosts_1 = require("./mapCosts");
const mapHunspellInformation_1 = require("./mapHunspellInformation");
const mapToSuggestionCostDef_1 = require("./mapToSuggestionCostDef");
function mapDictionaryInformation(dictInfo) {
    const _locale = dictInfo.locale;
    const locale = _locale ? (0, locale_1.parseLocale)(_locale).filter((loc) => loc.isValid()) : undefined;
    const locales = locale === null || locale === void 0 ? void 0 : locale.map((loc) => loc.locale);
    const costs = (0, mapCosts_1.mapEditCosts)(dictInfo.costs);
    const defsEC = dictInfo.suggestionEditCosts || [];
    const defsHI = dictInfo.hunspellInformation
        ? (0, mapHunspellInformation_1.hunspellInformationToSuggestionCostDef)(dictInfo.hunspellInformation, locale)
        : [];
    return [
        ...defsEC,
        ...processAlphabet(dictInfo.alphabet, locales, costs),
        ...processAccents(dictInfo.accents, costs),
        ...defsHI,
    ];
}
exports.mapDictionaryInformation = mapDictionaryInformation;
function processAlphabet(alphabet, locale, editCost) {
    const csAlphabet = toCharSets(alphabet, 'a-zA-Z', editCost.baseCost);
    return [
        ...(0, cspell_pipe_1.pipeSync)(csAlphabet, (0, cspell_pipe_1.opMap)((cs) => (0, mapToSuggestionCostDef_1.parseAlphabet)(cs, locale, editCost)), (0, cspell_pipe_1.opFlatten)()),
        ...(0, mapToSuggestionCostDef_1.calcFirstCharacterReplaceDefs)(csAlphabet, editCost),
    ];
}
function toCharSets(cs, defaultValue, cost, penalty) {
    cs = cs !== null && cs !== void 0 ? cs : defaultValue;
    if (!cs)
        return [];
    if (typeof cs === 'string') {
        cs = [
            {
                characters: cs,
                cost,
            },
        ];
    }
    if (penalty !== undefined) {
        cs.forEach((cs) => (cs.penalty = penalty));
    }
    return cs;
}
function processAccents(accents, editCost) {
    const cs = toCharSets(accents, '\u0300-\u0341', editCost.accentCosts);
    return cs.map((cs) => (0, mapToSuggestionCostDef_1.parseAccents)(cs, editCost)).filter(util_1.isDefined);
}
function mapDictionaryInformationToAdjustment(dictInfo) {
    if (!dictInfo.adjustments)
        return [];
    return dictInfo.adjustments.map(mapAdjustment);
}
exports.mapDictionaryInformationToAdjustment = mapDictionaryInformationToAdjustment;
function mapAdjustment(adj) {
    const { id, regexp, penalty } = adj;
    return {
        id: id,
        regexp: new RegExp(regexp),
        penalty,
    };
}
//# sourceMappingURL=mapDictionaryInfo.js.map