import { TrieRoot } from '../TrieNode';
import { Sequence } from 'gensequence';
export declare const DATA = "__DATA__";
export interface ExportOptions {
    base?: number;
    comment?: string;
}
/**
 * Serialize a TrieNode.
 * Note: This is destructive.  The node will no longer be usable.
 * Even though it is possible to preserve the trie, dealing with very large tries can consume a lot of memory.
 * Considering this is the last step before exporting, it was decided to let this be destructive.
 */
export declare function serializeTrie(root: TrieRoot, options?: ExportOptions | number): Sequence<string>;
export declare function importTrie(linesX: Iterable<string> | IterableIterator<string>): TrieRoot;
//# sourceMappingURL=importExportV2.d.ts.map