"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.importTrie = exports.serializeTrie = void 0;
const gensequence_1 = require("gensequence");
const iv1 = __importStar(require("./importExportV1"));
const iv2 = __importStar(require("./importExportV2"));
const iv3 = __importStar(require("./importExportV3"));
const serializers = [iv1.serializeTrie, iv1.serializeTrie, iv2.serializeTrie, iv3.serializeTrie];
const deserializers = [iv1.importTrie, iv1.importTrie, iv2.importTrie, iv3.importTrie];
/**
 * Serialize a TrieNode.
 * Note: This is destructive.  The node will no longer be usable.
 * Even though it is possible to preserve the trie, dealing with very large tries can consume a lot of memory.
 * Considering this is the last step before exporting, it was decided to let this be destructive.
 */
function serializeTrie(root, options = 16) {
    const version = typeof options !== 'number' && options.version ? options.version : 0;
    const method = serializers[version];
    if (!method) {
        throw new Error(`Unknown version: ${version}`);
    }
    return method(root, options);
}
exports.serializeTrie = serializeTrie;
function importTrie(lines) {
    const comment = /^\s*#/;
    function* arrayToIterableIterator(i) {
        yield* i;
    }
    function parseHeaderRows(headerRows) {
        const header = headerRows.join('\n');
        const headerReg = /\bTrieXv(\d+)/;
        /* istanbul ignore if */
        const match = header.match(headerReg);
        if (!match)
            throw new Error('Unknown file format');
        return parseInt(match[1], 10);
    }
    function readHeader(iter) {
        const headerRows = [];
        // eslint-disable-next-line no-constant-condition
        while (true) {
            const next = iter.next();
            if (next.done) {
                break;
            }
            const line = next.value.trim();
            if (!line || comment.test(line)) {
                continue;
            }
            headerRows.push(line);
            if (line === iv1.DATA || line === iv2.DATA) {
                break;
            }
        }
        return headerRows;
    }
    const input = arrayToIterableIterator(lines);
    const headerLines = readHeader(input);
    const version = parseHeaderRows(headerLines);
    const stream = (0, gensequence_1.genSequence)(headerLines).concat(input);
    const method = deserializers[version];
    if (!method) {
        throw new Error(`Unsupported version: ${version}`);
    }
    return method(stream);
}
exports.importTrie = importTrie;
//# sourceMappingURL=importExport.js.map